/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.validation;

import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.emf.validation.validity.utilities.ComposedEValidator;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.utilities.ConstraintEvaluator;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironmentFactory;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PivotEObjectValidator
implements EValidator {
    @NonNull
    private static final PivotEObjectValidator INSTANCE = new PivotEObjectValidator();

    @NonNull
    public static ValidationAdapter install(@NonNull ResourceSet resourceSet, @NonNull MetaModelManager metaModelManager) {
        ValidationAdapter validationAdapter = ValidationAdapter.findAdapter(resourceSet);
        if (validationAdapter != null) {
            if (validationAdapter.getMetaModelManager() != metaModelManager) {
                throw new IllegalArgumentException("Inconsistent metaModelManager");
            }
        } else {
            validationAdapter = new ValidationAdapter(metaModelManager);
            resourceSet.eAdapters().add((Object)validationAdapter);
        }
        return validationAdapter;
    }

    public static synchronized void install(@NonNull EPackage ePackage) {
        ComposedEValidator composedEValidator = ComposedEValidator.install((EPackage)ePackage);
        composedEValidator.addChild((EValidator)INSTANCE);
    }

    public static ResourceSet getResourceSet(@NonNull EClassifier eClassifier, @Nullable Object object, @Nullable DiagnosticChain diagnostics) {
        ResourceSet resourceSet = null;
        if (diagnostics instanceof BasicDiagnostic) {
            for (Object dataObject : ((BasicDiagnostic)diagnostics).getData()) {
                Resource resource;
                if (dataObject instanceof EObject && (resource = EcoreUtil.getRootContainer((EObject)((EObject)dataObject)).eResource()) != null && (resourceSet = resource.getResourceSet()) != null) break;
            }
        }
        if (resourceSet == null) {
            Resource resource;
            if (object instanceof EObject && (resource = EcoreUtil.getRootContainer((EObject)((EObject)object)).eResource()) != null) {
                resourceSet = resource.getResourceSet();
            }
            if (resourceSet == null && (resource = EcoreUtil.getRootContainer((EObject)eClassifier).eResource()) != null) {
                resourceSet = resource.getResourceSet();
            }
        }
        return resourceSet;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean allOk = true;
        if (eClass != null && !eObject.eIsProxy()) {
            allOk &= this.validatePivot((EClassifier)eClass, eObject, diagnostics, context);
        }
        return allOk;
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean allOk = true;
        if (eDataType != null) {
            allOk &= this.validatePivot((EClassifier)eDataType, value, diagnostics, context);
        }
        return allOk;
    }

    protected boolean validatePivot(@NonNull EClassifier eClassifier, @Nullable Object object, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context) {
        ValidationAdapter validationAdapter;
        ResourceSet resourceSet = PivotEObjectValidator.getResourceSet(eClassifier, object, diagnostics);
        if (resourceSet != null && (validationAdapter = ValidationAdapter.findAdapter(resourceSet)) != null) {
            boolean allOk = validationAdapter.validate(eClassifier, object, diagnostics, context);
            return allOk || diagnostics != null;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValidationAdapter
    extends AdapterImpl {
        @NonNull
        protected final MetaModelManager metaModelManager;
        @NonNull
        protected final EnvironmentFactory environmentFactory;
        @NonNull
        protected final Environment rootEnvironment;

        public static ValidationAdapter findAdapter(@NonNull ResourceSet resourceSet) {
            for (Adapter adapter : resourceSet.eAdapters()) {
                if (!(adapter instanceof ValidationAdapter)) continue;
                return (ValidationAdapter)adapter;
            }
            MetaModelManager metaModelManager = PivotUtil.findMetaModelManager(resourceSet);
            if (metaModelManager != null) {
                ResourceSet externalResourceSet = metaModelManager.getExternalResourceSet();
                for (Adapter adapter : externalResourceSet.eAdapters()) {
                    if (!(adapter instanceof ValidationAdapter)) continue;
                    return (ValidationAdapter)adapter;
                }
            }
            return null;
        }

        public ValidationAdapter(@NonNull MetaModelManager metaModelManager) {
            this.metaModelManager = metaModelManager;
            this.environmentFactory = new PivotEnvironmentFactory(null, metaModelManager);
            this.rootEnvironment = this.environmentFactory.createEnvironment();
        }

        @NonNull
        public MetaModelManager getMetaModelManager() {
            return this.metaModelManager;
        }

        public boolean validate(@NonNull EClassifier eClassifier, @Nullable Object object, @Nullable DiagnosticChain diagnostics, @Nullable Map<Object, Object> context) {
            boolean allOk = true;
            Type type = this.metaModelManager.getPivotOfEcore(Type.class, (EObject)eClassifier);
            if (type != null) {
                for (Constraint constraint : this.metaModelManager.getAllInvariants(type)) {
                    Diagnostic diagnostic;
                    if (constraint == null || (diagnostic = this.validate(constraint, object, context)) == null) continue;
                    if (diagnostics != null) {
                        diagnostics.add(diagnostic);
                    }
                    allOk = false;
                    if (diagnostic.getSeverity() != 4) continue;
                    return allOk;
                }
            }
            return allOk;
        }

        @Nullable
        public Diagnostic validate(final @NonNull Constraint constraint, final @Nullable Object object, final @Nullable Map<Object, Object> context) {
            ConstraintEvaluator<Diagnostic> constraintEvaluator;
            Diagnostic diagnostic;
            OpaqueExpression specification = constraint.getSpecification();
            if (specification == null) {
                return null;
            }
            ExpressionInOCL query = specification.getExpressionInOCL();
            if (query == null) {
                return null;
            }
            Variable contextVariable = query.getContextVariable();
            if (contextVariable == null) {
                return null;
            }
            OCLExpression bodyExpression = query.getBodyExpression();
            if (bodyExpression == null) {
                return null;
            }
            DomainModelManager oldModelManager = null;
            if (context != null) {
                oldModelManager = (DomainModelManager)context.get(DomainModelManager.class);
            }
            EvaluationVisitor evaluationVisitor = this.environmentFactory.createEvaluationVisitor(this.rootEnvironment, object, query, oldModelManager);
            if (context != null) {
                Object monitor;
                DomainModelManager newModelManager = evaluationVisitor.getModelManager();
                if (newModelManager != oldModelManager) {
                    context.put(DomainModelManager.class, newModelManager);
                }
                if ((monitor = context.get(Monitor.class)) instanceof Monitor) {
                    evaluationVisitor.setMonitor((Monitor)monitor);
                }
            }
            if ((diagnostic = (Diagnostic)(constraintEvaluator = new ConstraintEvaluator<Diagnostic>(query){

                @Override
                protected String getObjectLabel() {
                    Type type = PivotUtil.getContainingType(constraint);
                    Type primaryType = type != null ? ValidationAdapter.this.metaModelManager.getPrimaryType(type) : null;
                    EObject eTarget = primaryType != null ? primaryType.getETarget() : null;
                    EClassifier eClassifier = eTarget instanceof EClassifier ? (EClassifier)eTarget : null;
                    return DomainUtil.getLabel((EClassifier)eClassifier, (Object)object, (Map)context);
                }

                @Override
                protected Diagnostic handleExceptionResult(@NonNull Throwable e) {
                    String message = DomainUtil.bind((String)OCLMessages.ValidationConstraintException_ERROR_, (Object[])new Object[]{this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel(), e});
                    return new BasicDiagnostic(4, "org.eclipse.emf.ecore", 0, message, new Object[]{object});
                }

                @Override
                protected Diagnostic handleFailureResult(@Nullable Object result) {
                    String message = this.getConstraintResultMessage(result);
                    int severity = this.getConstraintResultSeverity(result);
                    return new BasicDiagnostic(severity, "org.eclipse.emf.ecore", 0, message, new Object[]{object});
                }

                @Override
                protected Diagnostic handleInvalidExpression(@NonNull String message) {
                    return new BasicDiagnostic(4, "org.eclipse.emf.ecore", 0, message, new Object[]{object});
                }

                @Override
                protected Diagnostic handleInvalidResult(@NonNull InvalidValueException e) {
                    String message = DomainUtil.bind((String)OCLMessages.ValidationResultIsInvalid_ERROR_, (Object[])new Object[]{this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel(), e.getLocalizedMessage()});
                    return new BasicDiagnostic(4, "org.eclipse.emf.ecore", 0, message, new Object[]{object});
                }

                @Override
                protected Diagnostic handleSuccessResult() {
                    return null;
                }
            }).evaluate(evaluationVisitor)) != null) {
                constraintEvaluator.evaluate(evaluationVisitor);
            }
            return diagnostic;
        }
    }
}

