/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.validity.locator;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.emf.validation.validity.LeafConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.locator.AbstractConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityManager;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityModel;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.resource.ASResource;
import org.eclipse.ocl.examples.pivot.utilities.BaseResource;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.validation.PivotEObjectValidator;
import org.eclipse.ocl.examples.validity.plugin.OCLValidityPlugin;
import org.eclipse.ocl.examples.xtext.base.basecs.ElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;

public class PivotConstraintLocator
extends AbstractConstraintLocator {
    @NonNull
    public static PivotConstraintLocator INSTANCE = new PivotConstraintLocator();

    @Nullable
    public Map<EObject, List<LeafConstrainingNode>> getConstraints(@NonNull ValidityModel validityModel, @NonNull EPackage ePackage, @NonNull Set<Resource> resources, @NonNull Monitor monitor) {
        Map map = null;
        for (Resource resource : resources) {
            MetaModelManager metaModelManager;
            if (monitor.isCanceled()) {
                return null;
            }
            ASResource asResource = null;
            if (resource instanceof BaseResource) {
                asResource = ((BaseResource)resource).getASResource(null);
            }
            if (asResource == null || (metaModelManager = PivotUtil.findMetaModelManager(asResource)) == null) continue;
            TreeIterator tit = asResource.getAllContents();
            while (tit.hasNext()) {
                Constraint pConstraint;
                Namespace constrainedElement;
                if (monitor.isCanceled()) {
                    return null;
                }
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof Constraint) || (constrainedElement = (pConstraint = (Constraint)eObject).getContext()) == null) continue;
                String label = String.valueOf(pConstraint.getName());
                EModelElement eTarget = (EModelElement)metaModelManager.getEcoreOfPivot(EModelElement.class, (Element)constrainedElement);
                if (eTarget == null) continue;
                assert (resource != null);
                map = this.createLeafConstrainingNode(map, validityModel, (EObject)eTarget, pConstraint, label);
            }
        }
        return map;
    }

    public Object getImage() {
        return OCLValidityPlugin.INSTANCE.getImage("OCLModelFile.gif");
    }

    @NonNull
    public String getName() {
        return "Complete OCL constraints";
    }

    @Nullable
    public String getSourceExpression(@NonNull LeafConstrainingNode node) {
        Object constrainingObject = node.getConstrainingObject();
        if (!(constrainingObject instanceof Constraint)) {
            return null;
        }
        OpaqueExpression specification = ((Constraint)constrainingObject).getSpecification();
        if (specification == null) {
            return null;
        }
        ModelElementCS csElement = ElementUtil.getCsElement((Element)specification);
        if (csElement == null) {
            return null;
        }
        return ElementUtil.getText((ElementCS)csElement);
    }

    @Nullable
    public Resource getSourceResource(@NonNull LeafConstrainingNode node) {
        Object constrainingObject = node.getConstrainingObject();
        if (!(constrainingObject instanceof Constraint)) {
            return null;
        }
        ModelElementCS csElement = ElementUtil.getCsElement((Element)((Constraint)constrainingObject));
        if (csElement == null) {
            return null;
        }
        return csElement.eResource();
    }

    public void validate(@NonNull Result result, @NonNull ValidityManager validityManager, @Nullable Monitor monitor) {
        block6: {
            Severity severity = Severity.UNKNOWN;
            try {
                Constraint constraint = (Constraint)result.getLeafConstrainingNode().getConstrainingObject();
                if (constraint == null) break block6;
                EObject eObject = result.getValidatableNode().getConstrainedObject();
                try {
                    PivotEObjectValidator.ValidationAdapter validationAdapter;
                    ResourceSet resourceSet = eObject.eResource().getResourceSet();
                    if (resourceSet != null && (validationAdapter = PivotEObjectValidator.ValidationAdapter.findAdapter((ResourceSet)resourceSet)) != null) {
                        Map context = validityManager.createDefaultContext();
                        context.put(Monitor.class, monitor);
                        Diagnostic diagnostic = validationAdapter.validate(constraint, (Object)eObject, context);
                        result.setDiagnostic((Object)diagnostic);
                        severity = diagnostic != null ? this.getSeverity(diagnostic) : Severity.OK;
                    }
                }
                catch (Throwable e) {
                    result.setException(e);
                    severity = Severity.FATAL;
                }
            }
            finally {
                result.setSeverity(severity);
            }
        }
    }
}

