/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.validity.locator;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.emf.validation.validity.LeafConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ConstrainingURI;
import org.eclipse.ocl.examples.emf.validation.validity.manager.TypeURI;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityManager;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityModel;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.validity.locator.AbstractPivotConstraintLocator;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;

public class UMLConstraintLocator
extends AbstractPivotConstraintLocator {
    @NonNull
    public static UMLConstraintLocator INSTANCE = new UMLConstraintLocator();

    protected void appendPath(@NonNull StringBuilder s, @NonNull NamedElement eObject) {
        EObject eContainer = eObject.eContainer();
        if (eContainer instanceof NamedElement) {
            this.appendPath(s, (NamedElement)eContainer);
            s.append("::");
        }
        s.append(eObject.getName());
    }

    @NonNull
    public Set<TypeURI> getAllTypes(@NonNull ValidityManager validityManager, @NonNull EObject constrainingType) {
        if (constrainingType instanceof Class) {
            HashSet<TypeURI> allTypes = new HashSet<TypeURI>();
            allTypes.add(validityManager.getTypeURI(constrainingType));
            if (constrainingType instanceof Class) {
                this.getAllTypes(allTypes, validityManager, (Iterable<Class>)((Class)constrainingType).getSuperClasses());
            }
            return allTypes;
        }
        return super.getAllTypes(validityManager, constrainingType);
    }

    private void getAllTypes(Set<TypeURI> knownTypes, @NonNull ValidityManager validityManager, Iterable<Class> moreTypes) {
        for (Class anotherType : moreTypes) {
            if (anotherType == null || !knownTypes.add(validityManager.getTypeURI((EObject)anotherType))) continue;
            this.getAllTypes(knownTypes, validityManager, (Iterable<Class>)anotherType.getSuperClasses());
        }
    }

    @Nullable
    public Set<ConstrainingURI> getConstrainingURIs(@NonNull ValidityManager validityManager, @NonNull EObject validatableObject) {
        ValidityModel validityModel;
        EObject umlClass;
        EAnnotation eAnnotation;
        EClass eClass = validatableObject.eClass();
        if (eClass != null && (eAnnotation = eClass.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML")) != null && eAnnotation.getReferences().size() > 0 && (umlClass = (EObject)eAnnotation.getReferences().get(0)) != null) {
            ConstrainingURI constrainingURI = validityManager.getConstrainingURI(umlClass);
            HashSet<ConstrainingURI> allConstrainingURIs = new HashSet<ConstrainingURI>();
            allConstrainingURIs.add(constrainingURI);
            return allConstrainingURIs;
        }
        Set allConstrainingURIs = null;
        if (validatableObject instanceof InstanceSpecification && (validityModel = validityManager.getModel()) != null) {
            if (eClass != null) {
                TypeURI typeURI = validityManager.getTypeURI((EObject)eClass);
                allConstrainingURIs = validityModel.accumulateConstrainingURIs(allConstrainingURIs, typeURI);
            }
            for (Classifier classifier : ((InstanceSpecification)validatableObject).getClassifiers()) {
                if (classifier == null) continue;
                TypeURI typeURI = validityManager.getTypeURI((EObject)classifier);
                allConstrainingURIs = validityModel.accumulateConstrainingURIs(allConstrainingURIs, typeURI);
            }
        }
        return allConstrainingURIs;
    }

    @Nullable
    public Map<EObject, List<LeafConstrainingNode>> getConstraints(@NonNull ValidityModel validityModel, @NonNull EPackage ePackage, @NonNull Set<Resource> resources, @NonNull Monitor monitor) {
        Map map = null;
        for (Resource resource : resources) {
            if (monitor.isCanceled()) {
                return null;
            }
            TreeIterator tit = resource.getAllContents();
            while (tit.hasNext()) {
                Constraint umlConstraint;
                Namespace contextElement;
                EObject eObject = (EObject)tit.next();
                if (eObject instanceof Constraint && (contextElement = (umlConstraint = (Constraint)eObject).getContext()) instanceof Type) {
                    String label = String.valueOf(umlConstraint.getName());
                    map = this.createLeafConstrainingNode(map, validityModel, (EObject)contextElement, umlConstraint, label);
                }
                if (!monitor.isCanceled()) continue;
                return null;
            }
        }
        return map;
    }

    @Nullable
    public Collection<Resource> getImports(@NonNull EPackage ePackage, @NonNull Resource resource) {
        HashSet<Resource> imports = new HashSet<Resource>();
        TreeIterator tit = resource.getAllContents();
        while (tit.hasNext()) {
            Resource eResource;
            Resource eResource2;
            PackageImport umlPackageImport;
            Package importedPackage;
            EObject eObject = (EObject)tit.next();
            if (eObject instanceof PackageImport && (importedPackage = (umlPackageImport = (PackageImport)eObject).getImportedPackage()) != null && (eResource2 = importedPackage.eResource()) != null) {
                imports.add(eResource2);
            }
            if ((eResource = eObject.eClass().eResource()) == null) continue;
            imports.add(eResource);
        }
        return imports;
    }

    @NonNull
    public String getLabel(@NonNull EModelElement eObject) {
        if (eObject instanceof NamedElement) {
            StringBuilder s = new StringBuilder();
            this.appendPath(s, (NamedElement)eObject);
            String string = s.toString();
            return string;
        }
        return super.getLabel(eObject);
    }

    @NonNull
    public String getName() {
        return "UML Constraints";
    }

    @Nullable
    public String getSourceExpression(@NonNull LeafConstrainingNode node) {
        Object constrainingObject = node.getConstrainingObject();
        if (!(constrainingObject instanceof Constraint)) {
            return null;
        }
        ValueSpecification specification = ((Constraint)constrainingObject).getSpecification();
        if (!(specification instanceof OpaqueExpression)) {
            return null;
        }
        EList bodies = ((OpaqueExpression)specification).getBodies();
        return bodies.size() > 0 ? (String)bodies.get(0) : null;
    }

    @Nullable
    public Resource getSourceResource(@NonNull LeafConstrainingNode node) {
        Object constrainingObject = node.getConstrainingObject();
        if (!(constrainingObject instanceof EObject)) {
            return null;
        }
        return ((EObject)constrainingObject).eResource();
    }

    @Nullable
    public URI getURI(@NonNull EObject eObject) {
        Object value;
        EObject eContainer = eObject;
        while (true) {
            if (eContainer == null) {
                return null;
            }
            if (eContainer instanceof Package) break;
            eContainer = eContainer.eContainer();
        }
        String nsURI = null;
        Stereotype appliedStereotype = ((Package)eContainer).getAppliedStereotype("Ecore::EPackage");
        if (appliedStereotype != null && (value = ((Package)eContainer).getValue(appliedStereotype, "nsURI")) != null) {
            nsURI = value.toString();
        }
        if (nsURI == null) {
            nsURI = ((Package)eContainer).getURI();
        }
        if (nsURI == null) {
            return null;
        }
        Resource resource = eObject.eResource();
        if (resource == null) {
            return null;
        }
        String uriFragment = resource.getURIFragment(eObject);
        if (!uriFragment.startsWith("//")) {
            uriFragment = "//" + uriFragment;
        }
        return URI.createURI((String)nsURI).appendFragment(uriFragment);
    }

    public void validate(@NonNull Result result, @NonNull ValidityManager validityManager, @Nullable Monitor monitor) {
        ValidatableNode validatableNode = result.getValidatableNode();
        EObject contextObject = validatableNode.getConstrainedObject();
        LeafConstrainingNode leafConstrainingNode = result.getLeafConstrainingNode();
        Constraint umlConstraint = (Constraint)leafConstrainingNode.getConstrainingObject();
        if (umlConstraint == null) {
            return;
        }
        MetaModelManager metaModelManager = PivotUtil.findMetaModelManager((EObject)umlConstraint);
        if (metaModelManager == null) {
            Resource eResource = umlConstraint.eResource();
            if (eResource == null) {
                return;
            }
            metaModelManager = PivotUtil.getMetaModelManager((Resource)eResource);
        }
        Severity severity = Severity.UNKNOWN;
        try {
            try {
                final org.eclipse.ocl.examples.pivot.Constraint pivotConstraint = (org.eclipse.ocl.examples.pivot.Constraint)metaModelManager.getPivotOf(org.eclipse.ocl.examples.pivot.Constraint.class, (EObject)umlConstraint);
                if (pivotConstraint == null) {
                    throw new ParserException("Failed to create pivot Constraint");
                }
                ResourceSet resourceSet = contextObject.eResource().getResourceSet();
                if (resourceSet != null) {
                    ExpressionInOCL query = this.getQuery(pivotConstraint);
                    EvaluationVisitor evaluationVisitor = this.createEvaluationVisitor(metaModelManager, query, contextObject, monitor);
                    AbstractPivotConstraintLocator.AbstractConstraintLocator constraintEvaluator = new AbstractPivotConstraintLocator.AbstractConstraintLocator(metaModelManager, query, contextObject){

                        protected String getObjectLabel() {
                            org.eclipse.ocl.examples.pivot.Type type = PivotUtil.getContainingType((EObject)pivotConstraint);
                            org.eclipse.ocl.examples.pivot.Type primaryType = type != null ? this.metaModelManager.getPrimaryType((DomainType)type) : null;
                            Classifier classifier = primaryType != null ? (Classifier)primaryType.getETarget() : null;
                            return classifier != null ? classifier.getName() : "??";
                        }
                    };
                    Diagnostic diagnostic = (Diagnostic)constraintEvaluator.evaluate(evaluationVisitor);
                    result.setDiagnostic((Object)diagnostic);
                    severity = diagnostic != null ? this.getSeverity(diagnostic) : Severity.OK;
                }
            }
            catch (Throwable e) {
                result.setException(e);
                severity = Severity.FATAL;
                result.setSeverity(severity);
            }
        }
        finally {
            result.setSeverity(severity);
        }
    }
}

