/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.ui.utilities;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.registry.CompleteOCLRegistry;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class PDEUtils {
    @NonNull
    public static CompleteOCLRegistry createCompleteOCLRegistry() {
        IPluginModelBase[] activeModels;
        CompleteOCLRegistry registry = new CompleteOCLRegistry();
        IPluginModelBase[] iPluginModelBaseArray = activeModels = PluginRegistry.getActiveModels((boolean)false);
        int n = activeModels.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase activeModel = iPluginModelBaseArray[n2];
            if (activeModel != null) {
                IPluginExtension[] iPluginExtensionArray = activeModel.getExtensions().getExtensions();
                int n3 = iPluginExtensionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPluginExtension pluginExtension = iPluginExtensionArray[n4];
                    String point = pluginExtension.getPoint();
                    if ("org.eclipse.ocl.examples.pivot.complete_ocl_registry".equals(point)) {
                        URI location = PDEUtils.getLocation(activeModel);
                        PDEUtils.readCompleteOCLRegistryExtensionPoints(registry, location, pluginExtension);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return registry;
    }

    @NonNull
    private static URI getLocation(@NonNull IPluginModelBase activeModel) {
        IResource underlyingResource = activeModel.getUnderlyingResource();
        if (underlyingResource != null) {
            String projectPath = String.valueOf(underlyingResource.getProject().getFullPath().toString()) + "/";
            URI projectURI = URI.createPlatformResourceURI((String)projectPath, (boolean)true);
            return projectURI;
        }
        BundleDescription bundleDescription = activeModel.getBundleDescription();
        String bundlePath = String.valueOf(bundleDescription.getSymbolicName()) + "/";
        URI bundleURI = URI.createPlatformPluginURI((String)bundlePath, (boolean)true);
        return bundleURI;
    }

    private static void readCompleteOCLRegistryExtensionPoints(@NonNull CompleteOCLRegistry registry, @NonNull URI location, @NonNull IPluginExtension pluginExtension) {
        IPluginObject[] iPluginObjectArray = pluginExtension.getChildren();
        int n = iPluginObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompleteOCLRegistry.Registration registration;
            IPluginObject child1 = iPluginObjectArray[n2];
            if (child1 instanceof IPluginElement && (registration = PDEUtils.readCompleteOCLRegistryExtensionPoint(location, (IPluginElement)child1)) != null) {
                registry.addRegistration(registration);
            }
            ++n2;
        }
    }

    @Nullable
    private static CompleteOCLRegistry.Registration readCompleteOCLRegistryExtensionPoint(@NonNull URI location, @NonNull IPluginElement documentElement) {
        IPluginAttribute resourceAttribute = documentElement.getAttribute("resource");
        if (resourceAttribute == null) {
            return null;
        }
        ArrayList<String> nsURIs = new ArrayList<String>();
        IPluginObject[] iPluginObjectArray = documentElement.getChildren();
        int n = iPluginObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginObject child2 = iPluginObjectArray[n2];
            if (child2 instanceof IPluginElement) {
                IPluginElement forElement = (IPluginElement)child2;
                IPluginAttribute uriAttribute = forElement.getAttribute("uri");
                if (uriAttribute == null) {
                    return null;
                }
                String uriString = uriAttribute.getValue();
                if (uriString == null) {
                    return null;
                }
                nsURIs.add(uriString);
            }
            ++n2;
        }
        URI resourceURI = URI.createURI((String)resourceAttribute.getValue());
        URI resolvedResourceURI = resourceURI.resolve(location);
        return new CompleteOCLRegistry.Registration(resolvedResourceURI, nsURIs);
    }
}

