/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.cs2as;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.ids.PackageId;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Detail;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.Import;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.resource.ASResource;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.basecs.AnnotationCS;
import org.eclipse.ocl.examples.xtext.base.basecs.AnnotationElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.BaseCSPackage;
import org.eclipse.ocl.examples.xtext.base.basecs.ClassCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ClassifierCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ConstraintCS;
import org.eclipse.ocl.examples.xtext.base.basecs.DataTypeCS;
import org.eclipse.ocl.examples.xtext.base.basecs.DetailCS;
import org.eclipse.ocl.examples.xtext.base.basecs.DocumentationCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ElementRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.EnumerationCS;
import org.eclipse.ocl.examples.xtext.base.basecs.EnumerationLiteralCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ImportCS;
import org.eclipse.ocl.examples.xtext.base.basecs.LambdaTypeCS;
import org.eclipse.ocl.examples.xtext.base.basecs.LibraryCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ModelElementRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.MultiplicityBoundsCS;
import org.eclipse.ocl.examples.xtext.base.basecs.MultiplicityStringCS;
import org.eclipse.ocl.examples.xtext.base.basecs.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.OperationCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PackageCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ParameterCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PrimitiveTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.RootCS;
import org.eclipse.ocl.examples.xtext.base.basecs.RootPackageCS;
import org.eclipse.ocl.examples.xtext.base.basecs.SpecificationCS;
import org.eclipse.ocl.examples.xtext.base.basecs.StructuralFeatureCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TemplateBindingCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TemplateParameterCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TemplateParameterSubstitutionCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TemplateSignatureCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TuplePartCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TupleTypeCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TypeRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.WildcardTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.util.AbstractExtendingBaseCSVisitor;
import org.eclipse.ocl.examples.xtext.base.basecs.util.VisitableCS;
import org.eclipse.ocl.examples.xtext.base.cs2as.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2as.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.base.cs2as.Continuation;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseCSContainmentVisitor
extends AbstractExtendingBaseCSVisitor<Continuation<?>, CS2PivotConversion> {
    @NonNull
    protected final MetaModelManager metaModelManager;

    public BaseCSContainmentVisitor(@NonNull CS2PivotConversion context) {
        super(context);
        this.metaModelManager = context.getMetaModelManager();
    }

    protected PackageId getPackageId(@NonNull PackageCS csElement) {
        return null;
    }

    protected void importPackages(@NonNull RootPackageCS csElement) {
        for (LibraryCS csLibrary : csElement.getOwnedLibrary()) {
            csLibrary.getPackage();
        }
        for (ImportCS csImport : csElement.getOwnedImport()) {
            csImport.getNamespace();
        }
    }

    protected Continuation<?> refreshClass(@NonNull org.eclipse.ocl.examples.pivot.Class pivotElement, @NonNull ClassCS csElement) {
        EList<String> qualifiers = csElement.getQualifier();
        pivotElement.setIsAbstract(qualifiers.contains("abstract"));
        pivotElement.setIsInterface(qualifiers.contains("interface"));
        pivotElement.setIsStatic(qualifiers.contains("static"));
        ((CS2PivotConversion)((Object)this.context)).refreshPivotList(Property.class, pivotElement.getOwnedAttribute(), (List<? extends ModelElementCS>)csElement.getOwnedProperty());
        ((CS2PivotConversion)((Object)this.context)).refreshPivotList(Operation.class, pivotElement.getOwnedOperation(), (List<? extends ModelElementCS>)csElement.getOwnedOperation());
        this.refreshClassifier((Type)pivotElement, csElement);
        return null;
    }

    protected Type refreshClassifier(@NonNull Type pivotElement, @NonNull ClassifierCS csElement) {
        if (csElement.eIsSet((EStructuralFeature)BaseCSPackage.Literals.CLASSIFIER_CS__INSTANCE_CLASS_NAME)) {
            pivotElement.setInstanceClassName(csElement.getInstanceClassName());
        } else {
            pivotElement.eUnset((EStructuralFeature)PivotPackage.Literals.TYPE__INSTANCE_CLASS_NAME);
        }
        String newInstanceClassName = csElement.getInstanceClassName();
        String oldInstanceClassName = pivotElement.getInstanceClassName();
        if (!(newInstanceClassName == oldInstanceClassName || newInstanceClassName != null && newInstanceClassName.equals(oldInstanceClassName))) {
            pivotElement.setInstanceClassName(newInstanceClassName);
        }
        ((CS2PivotConversion)((Object)this.context)).refreshTemplateSignature(csElement, (TemplateableElement)pivotElement);
        ((CS2PivotConversion)((Object)this.context)).refreshPivotList(Constraint.class, pivotElement.getOwnedInvariant(), (List<? extends ModelElementCS>)csElement.getOwnedConstraint());
        return pivotElement;
    }

    @NonNull
    protected <T extends NamedElement> T refreshNamedElement(@NonNull Class<T> pivotClass, EClass pivotEClass, @NonNull NamedElementCS csElement) {
        NamedElement pivotElement = (NamedElement)((CS2PivotConversion)((Object)this.context)).refreshModelElement(pivotClass, pivotEClass, csElement);
        String name = csElement.getName();
        if (name != null) {
            ((CS2PivotConversion)((Object)this.context)).refreshName(pivotElement, name);
            ((CS2PivotConversion)((Object)this.context)).refreshComments((Element)pivotElement, csElement);
        }
        return (T)pivotElement;
    }

    protected <T extends Package> T refreshPackage(@NonNull Class<T> pivotClass, EClass pivotEClass, @NonNull PackageCS csElement) {
        String oldNsURI;
        String newNsURI;
        Package pivotElement;
        String name;
        assert (pivotEClass != null);
        Element pivotObject = csElement.getPivot();
        if (pivotObject == null) {
            pivotObject = ((CS2PivotConversion)((Object)this.context)).getOldPackageByQualifiedName(csElement);
        }
        if ((name = csElement.getName()) == null) {
            throw new IllegalStateException("Null name");
        }
        if (pivotObject == null) {
            pivotObject = ((CS2PivotConversion)((Object)this.context)).getOldPackageBySimpleName(name);
        }
        if (pivotObject == null) {
            pivotElement = this.metaModelManager.createPackage(pivotClass, pivotEClass, name, csElement.getNsURI(), this.getPackageId(csElement));
        } else {
            Package pivotElement2;
            if (!pivotClass.isAssignableFrom(pivotObject.getClass())) {
                throw new ClassCastException();
            }
            pivotElement = pivotElement2 = (Package)pivotObject;
            ((CS2PivotConversion)((Object)this.context)).refreshName((NamedElement)pivotElement, name);
        }
        ((CS2PivotConversion)((Object)this.context)).getConverter().installPivotDefinition(csElement, (Element)pivotElement);
        ((CS2PivotConversion)((Object)this.context)).refreshComments((Element)pivotElement, csElement);
        String newNsPrefix = csElement.getNsPrefix();
        String oldNsPrefix = pivotElement.getNsPrefix();
        if (!(newNsPrefix == oldNsPrefix || newNsPrefix != null && newNsPrefix.equals(oldNsPrefix))) {
            pivotElement.setNsPrefix(newNsPrefix);
        }
        if (!((newNsURI = csElement.getNsURI()) == (oldNsURI = pivotElement.getNsURI()) || newNsURI != null && newNsURI.equals(oldNsURI))) {
            pivotElement.setNsURI(newNsURI);
        }
        ((CS2PivotConversion)((Object)this.context)).refreshPivotList(Package.class, pivotElement.getNestedPackage(), (List<? extends ModelElementCS>)csElement.getOwnedNestedPackage());
        ((CS2PivotConversion)((Object)this.context)).refreshPivotList(Type.class, pivotElement.getOwnedType(), (List<? extends ModelElementCS>)csElement.getOwnedType());
        return (T)pivotElement;
    }

    @NonNull
    protected <T extends Root> T refreshRoot(@NonNull Class<T> pivotClass, EClass pivotEClass, @NonNull RootCS csElement) {
        Root pivotElement;
        URI csURI;
        String newExternalURI;
        ASResource asResource;
        assert (pivotEClass != null);
        Resource csResource = csElement.eResource();
        if (csResource == null) {
            throw new IllegalStateException("Null resource for root package");
        }
        Element pivotObject = csElement.getPivot();
        if (pivotObject == null && (asResource = ((CS2PivotConversion)((Object)this.context)).getConverter().getPivotResource((BaseCSResource)csResource)) != null) {
            for (EObject oldRoot : asResource.getContents()) {
                if (!(oldRoot instanceof Root)) continue;
                pivotObject = oldRoot;
                break;
            }
        }
        String string = newExternalURI = (csURI = csResource.getURI()) != null ? csURI.toString() : null;
        if (pivotObject == null) {
            pivotElement = this.metaModelManager.createRoot(pivotClass, pivotEClass, newExternalURI);
        } else {
            if (!pivotClass.isAssignableFrom(pivotObject.getClass())) {
                throw new ClassCastException();
            }
            Root pivotElement2 = (Root)pivotObject;
            pivotElement = pivotElement2;
            String oldExternalURI = pivotElement.getExternalURI();
            if (!(newExternalURI == oldExternalURI || newExternalURI != null && newExternalURI.equals(oldExternalURI))) {
                pivotElement.setExternalURI(newExternalURI);
            }
        }
        ((CS2PivotConversion)((Object)this.context)).getConverter().installPivotDefinition(csElement, (Element)pivotElement);
        ((CS2PivotConversion)((Object)this.context)).refreshComments((Element)pivotElement, csElement);
        return (T)pivotElement;
    }

    @NonNull
    protected <T extends Root> T refreshRootPackage(@NonNull Class<T> pivotClass, EClass pivotEClass, @NonNull RootPackageCS csElement) {
        T pivotElement = this.refreshRoot(pivotClass, pivotEClass, csElement);
        ((CS2PivotConversion)((Object)this.context)).refreshPivotList(Package.class, pivotElement.getNestedPackage(), (List<? extends ModelElementCS>)csElement.getOwnedNestedPackage());
        return pivotElement;
    }

    protected void refreshSerializable(DataType pivotElement, ClassifierCS csElement) {
        EList<String> qualifiers = csElement.getQualifier();
        pivotElement.setIsSerializable(qualifiers.contains("serializable"));
    }

    @Override
    public Continuation<?> visitAnnotationCS(@NonNull AnnotationCS csElement) {
        EClass eClass = PivotPackage.Literals.ANNOTATION;
        this.refreshNamedElement(Annotation.class, eClass, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitAnnotationElementCS(@NonNull AnnotationElementCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitClassCS(@NonNull ClassCS csElement) {
        EClass eClass = PivotPackage.Literals.CLASS;
        org.eclipse.ocl.examples.pivot.Class pivotElement = this.refreshNamedElement(org.eclipse.ocl.examples.pivot.Class.class, eClass, csElement);
        this.refreshClass(pivotElement, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitConstraintCS(@NonNull ConstraintCS csElement) {
        EClass eClass = PivotPackage.Literals.CONSTRAINT;
        Constraint pivotElement = this.refreshNamedElement(Constraint.class, eClass, csElement);
        pivotElement.setSpecification((OpaqueExpression)PivotUtil.getPivot(OpaqueExpression.class, (Pivotable)csElement.getSpecification()));
        return null;
    }

    @Override
    public Continuation<?> visitDataTypeCS(@NonNull DataTypeCS csElement) {
        EClass eClass = PivotPackage.Literals.DATA_TYPE;
        DataType pivotElement = this.refreshNamedElement(DataType.class, eClass, csElement);
        this.refreshSerializable(pivotElement, csElement);
        this.refreshClassifier((Type)pivotElement, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitDetailCS(@NonNull DetailCS csElement) {
        EClass eClass = PivotPackage.Literals.DETAIL;
        this.refreshNamedElement(Detail.class, eClass, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitDocumentationCS(@NonNull DocumentationCS csElement) {
        EClass eClass = PivotPackage.Literals.ANNOTATION;
        this.refreshNamedElement(Annotation.class, eClass, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitElementCS(@NonNull ElementCS csElement) {
        System.out.println("Unsupported " + csElement.eClass().getName() + " for CS2Pivot Containment pass");
        return null;
    }

    @Override
    public Continuation<?> visitElementRefCS(@NonNull ElementRefCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitEnumerationCS(@NonNull EnumerationCS csElement) {
        EClass eClass = PivotPackage.Literals.ENUMERATION;
        Enumeration pivotElement = this.refreshNamedElement(Enumeration.class, eClass, csElement);
        ((CS2PivotConversion)((Object)this.context)).refreshPivotList(EnumerationLiteral.class, pivotElement.getOwnedLiteral(), (List<? extends ModelElementCS>)csElement.getOwnedLiterals());
        this.refreshSerializable((DataType)pivotElement, csElement);
        this.refreshClassifier((Type)pivotElement, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitEnumerationLiteralCS(@NonNull EnumerationLiteralCS csElement) {
        EClass eClass = PivotPackage.Literals.ENUMERATION_LITERAL;
        EnumerationLiteral pivotElement = this.refreshNamedElement(EnumerationLiteral.class, eClass, csElement);
        pivotElement.setValue((Number)BigInteger.valueOf(csElement.getValue()));
        return null;
    }

    @Override
    public Continuation<?> visitImportCS(@NonNull ImportCS csElement) {
        Import pivotElement = this.refreshNamedElement(Import.class, PivotPackage.Literals.IMPORT, csElement);
        PathNameCS pathName = csElement.getPathName();
        if (pathName != null) {
            CS2Pivot.setElementType(pathName, PivotPackage.Literals.NAMESPACE, csElement, null);
        }
        if (csElement.isAll() && csElement.getName() != null) {
            ((CS2PivotConversion)((Object)this.context)).addDiagnostic((ElementCS)csElement, "An all-package import cannot have an associated alias name");
        }
        return null;
    }

    @Override
    public Continuation<?> visitLambdaTypeCS(@NonNull LambdaTypeCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitLibraryCS(@NonNull LibraryCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitModelElementRefCS(@NonNull ModelElementRefCS csElement) {
        PathNameCS pathName = csElement.getPathName();
        if (pathName != null) {
            CS2Pivot.setElementType(pathName, PivotPackage.Literals.ELEMENT, csElement, null);
        }
        return null;
    }

    @Override
    public Continuation<?> visitMultiplicityBoundsCS(@NonNull MultiplicityBoundsCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitMultiplicityStringCS(@NonNull MultiplicityStringCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitOperationCS(@NonNull OperationCS csElement) {
        EClass eClass = PivotPackage.Literals.OPERATION;
        Operation pivotElement = this.refreshNamedElement(Operation.class, eClass, csElement);
        ((CS2PivotConversion)((Object)this.context)).refreshTemplateSignature(csElement, (TemplateableElement)pivotElement);
        ((CS2PivotConversion)((Object)this.context)).refreshPivotList(Parameter.class, pivotElement.getOwnedParameter(), (List<? extends ModelElementCS>)csElement.getOwnedParameter());
        ((CS2PivotConversion)((Object)this.context)).refreshPivotList(Constraint.class, pivotElement.getPrecondition(), (List<? extends ModelElementCS>)csElement.getOwnedPrecondition());
        ((CS2PivotConversion)((Object)this.context)).refreshPivotList(Constraint.class, pivotElement.getPostcondition(), (List<? extends ModelElementCS>)csElement.getOwnedPostcondition());
        EList<SpecificationCS> csBodyExpressions = csElement.getOwnedBodyExpression();
        SpecificationCS csBodyExpression = csBodyExpressions.size() > 0 ? (SpecificationCS)csBodyExpressions.get(0) : null;
        pivotElement.setBodyExpression((OpaqueExpression)PivotUtil.getPivot(OpaqueExpression.class, (Pivotable)csBodyExpression));
        return null;
    }

    @Override
    public Continuation<?> visitPackageCS(@NonNull PackageCS csElement) {
        EClass eClass = PivotPackage.Literals.PACKAGE;
        this.refreshPackage(Package.class, eClass, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitParameterCS(@NonNull ParameterCS csElement) {
        EClass eClass = PivotPackage.Literals.PARAMETER;
        this.refreshNamedElement(Parameter.class, eClass, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitPathElementCS(@NonNull PathElementCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitPathNameCS(@NonNull PathNameCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitPrimitiveTypeRefCS(@NonNull PrimitiveTypeRefCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitRootPackageCS(@NonNull RootPackageCS csElement) {
        this.importPackages(csElement);
        EClass eClass = PivotPackage.Literals.ROOT;
        Root root = this.refreshRootPackage(Root.class, eClass, csElement);
        EList csImports = csElement.getOwnedImport();
        if (csImports.size() > 0) {
            ArrayList<Import> newImports = new ArrayList<Import>(csImports.size());
            for (ImportCS csImport : csImports) {
                Import pivotElement = (Import)PivotUtil.getPivot(Import.class, (Pivotable)csImport);
                if (pivotElement != null) {
                    pivotElement.setImportedNamespace(csImport.getNamespace());
                }
                newImports.add(pivotElement);
            }
            ((CS2PivotConversion)((Object)this.context)).refreshList(root.getImports(), newImports);
        } else {
            root.getImports().clear();
        }
        return null;
    }

    @Override
    public Continuation<?> visitSpecificationCS(@NonNull SpecificationCS csElement) {
        EClass eClass = PivotPackage.Literals.OPAQUE_EXPRESSION;
        OpaqueExpression pivotElement = ((CS2PivotConversion)((Object)this.context)).refreshModelElement(OpaqueExpression.class, eClass, csElement);
        pivotElement.getLanguage().add("OCL");
        pivotElement.getBody().add(csElement.getExprString());
        return null;
    }

    @Override
    public Continuation<?> visitStructuralFeatureCS(@NonNull StructuralFeatureCS csElement) {
        EClass eClass = PivotPackage.Literals.PROPERTY;
        Property pivotElement = this.refreshNamedElement(Property.class, eClass, csElement);
        EList<String> qualifiers = csElement.getQualifier();
        pivotElement.setIsComposite(qualifiers.contains("composes"));
        pivotElement.setIsDerived(qualifiers.contains("derived"));
        pivotElement.setIsID(qualifiers.contains("id"));
        pivotElement.setIsReadOnly(qualifiers.contains("readonly"));
        pivotElement.setIsResolveProxies(ElementUtil.getQualifier(qualifiers, "resolve", "!resolve", true));
        pivotElement.setIsStatic(qualifiers.contains("static"));
        pivotElement.setIsTransient(qualifiers.contains("transient"));
        pivotElement.setIsUnsettable(qualifiers.contains("unsettable"));
        pivotElement.setIsVolatile(qualifiers.contains("volatile"));
        if (csElement.eIsSet((EStructuralFeature)BaseCSPackage.Literals.STRUCTURAL_FEATURE_CS__DEFAULT)) {
            pivotElement.setDefault(csElement.getDefault());
        } else {
            pivotElement.eUnset((EStructuralFeature)PivotPackage.Literals.PROPERTY__DEFAULT);
        }
        EList<SpecificationCS> csDefaultExpressions = csElement.getOwnedDefaultExpression();
        SpecificationCS csDefaultExpression = csDefaultExpressions.size() > 0 ? (SpecificationCS)csDefaultExpressions.get(0) : null;
        pivotElement.setDefaultExpression((OpaqueExpression)PivotUtil.getPivot(OpaqueExpression.class, (Pivotable)csDefaultExpression));
        return null;
    }

    @Override
    public Continuation<?> visitTemplateBindingCS(@NonNull TemplateBindingCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitTemplateParameterCS(@NonNull TemplateParameterCS csElement) {
        EClass eClass = PivotPackage.Literals.CLASS;
        org.eclipse.ocl.examples.pivot.Class pivotElement = this.refreshNamedElement(org.eclipse.ocl.examples.pivot.Class.class, eClass, csElement);
        TemplateParameter pivotTemplateParameter = pivotElement.getOwningTemplateParameter();
        if (pivotTemplateParameter == null) {
            pivotTemplateParameter = PivotFactory.eINSTANCE.createTypeTemplateParameter();
            pivotTemplateParameter.setOwnedParameteredElement((ParameterableElement)pivotElement);
        }
        return null;
    }

    @Override
    public Continuation<?> visitTemplateParameterSubstitutionCS(@NonNull TemplateParameterSubstitutionCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitTemplateSignatureCS(@NonNull TemplateSignatureCS csElement) {
        EClass eClass = PivotPackage.Literals.TEMPLATE_SIGNATURE;
        TemplateSignature pivotElement = ((CS2PivotConversion)((Object)this.context)).refreshModelElement(TemplateSignature.class, eClass, csElement);
        ArrayList<TemplateParameter> newPivotTemplateParameters = new ArrayList<TemplateParameter>();
        EList<TemplateParameterCS> csTemplateParameters = csElement.getOwnedTemplateParameter();
        for (TemplateParameterCS csTemplateParameter : csTemplateParameters) {
            org.eclipse.ocl.examples.pivot.Class pivotTemplateParameterClass = (org.eclipse.ocl.examples.pivot.Class)PivotUtil.getPivot(org.eclipse.ocl.examples.pivot.Class.class, (Pivotable)csTemplateParameter);
            if (pivotTemplateParameterClass == null) continue;
            TemplateParameter pivotTemplateParameter = pivotTemplateParameterClass.getOwningTemplateParameter();
            newPivotTemplateParameters.add(pivotTemplateParameter);
        }
        PivotUtil.refreshList((List)pivotElement.getOwnedParameter(), newPivotTemplateParameters);
        return null;
    }

    @Override
    public Continuation<?> visitTuplePartCS(@NonNull TuplePartCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitTupleTypeCS(@NonNull TupleTypeCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitTypeRefCS(@NonNull TypeRefCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitTypedRefCS(@NonNull TypedRefCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitTypedTypeRefCS(@NonNull TypedTypeRefCS csElement) {
        PathNameCS pathName = csElement.getPathName();
        if (pathName != null) {
            CS2Pivot.setElementType(pathName, PivotPackage.Literals.TYPE, csElement, null);
        }
        return null;
    }

    @Override
    public Continuation<?> visitWildcardTypeRefCS(@NonNull WildcardTypeRefCS csElement) {
        EClass eClass = PivotPackage.Literals.CLASS;
        org.eclipse.ocl.examples.pivot.Class pivotElement = ((CS2PivotConversion)((Object)this.context)).refreshModelElement(org.eclipse.ocl.examples.pivot.Class.class, eClass, null);
        ((CS2PivotConversion)((Object)this.context)).installPivotReference(csElement, (Element)pivotElement, BaseCSPackage.Literals.PIVOTABLE_ELEMENT_CS__PIVOT);
        return null;
    }

    @Override
    public Continuation<?> visiting(@NonNull VisitableCS visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for CS2Pivot Containment pass");
    }
}

