/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.completeocl.utilities;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.resource.ASResource;
import org.eclipse.ocl.examples.pivot.utilities.BaseResource;
import org.eclipse.ocl.examples.pivot.utilities.PivotObjectImpl;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.validation.PivotEObjectValidator;
import org.eclipse.ocl.examples.xtext.completeocl.CompleteOCLStandaloneSetup;

public abstract class CompleteOCLLoader {
    @NonNull
    protected final ResourceSet resourceSet;
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    protected final Set<EPackage> mmPackages;

    public CompleteOCLLoader(@NonNull ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
        MetaModelManagerResourceSetAdapter adapter = MetaModelManagerResourceSetAdapter.getAdapter((ResourceSet)resourceSet, null);
        this.metaModelManager = adapter.getMetaModelManager();
        this.mmPackages = new HashSet<EPackage>();
    }

    @NonNull
    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    public boolean loadMetaModels() {
        for (Resource resource : this.resourceSet.getResources()) {
            assert (resource != null);
            Ecore2Pivot ecore2Pivot = Ecore2Pivot.findAdapter((Resource)resource, (MetaModelManager)this.metaModelManager);
            if (ecore2Pivot != null) continue;
            TreeIterator tit = resource.getAllContents();
            while (tit.hasNext()) {
                EPackage mmPackage;
                EObject eObject = (EObject)tit.next();
                EClass eClass = eObject.eClass();
                if (eClass == null || (mmPackage = eClass.getEPackage()) == null) continue;
                this.mmPackages.add(mmPackage);
            }
        }
        HashSet<Resource> mmResources = new HashSet<Resource>();
        for (EPackage mmPackage : this.mmPackages) {
            Resource mmResource = EcoreUtil.getRootContainer((EObject)mmPackage).eResource();
            if (mmResource == null) continue;
            mmResources.add(mmResource);
        }
        for (Resource mmResource : mmResources) {
            assert (mmResource != null);
            try {
                Element pivotRoot = this.metaModelManager.loadResource(mmResource, null);
                if (pivotRoot != null) {
                    EList errors = pivotRoot.eResource().getErrors();
                    assert (errors != null);
                    String message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
                    if (message == null) continue;
                    return this.error("Failed to load Pivot from '" + mmResource.getURI(), message);
                }
                return this.error("Failed to load Pivot from '" + mmResource.getURI(), "");
            }
            catch (ParserException e) {
                return this.error("Failed to load Pivot from '" + mmResource.getURI(), e.getMessage());
            }
        }
        return true;
    }

    protected abstract boolean error(@NonNull String var1, @Nullable String var2);

    public void installPackages() {
        PivotEObjectValidator.install((ResourceSet)this.resourceSet, (MetaModelManager)this.metaModelManager);
        for (EPackage mmPackage : this.mmPackages) {
            assert (mmPackage != null);
            PivotEObjectValidator.install((EPackage)mmPackage);
        }
    }

    public boolean loadDocument(@NonNull URI oclURI) {
        Resource resource = this.loadResource(oclURI);
        if (resource == null) {
            return false;
        }
        TreeIterator tit = resource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (eObject instanceof Package) {
                EObject mmPackage;
                DomainPackage aPackage = this.metaModelManager.getPrimaryPackage((DomainPackage)((Package)eObject));
                if (!(aPackage instanceof PivotObjectImpl) || !((mmPackage = ((PivotObjectImpl)aPackage).getETarget()) instanceof EPackage)) continue;
                this.mmPackages.add((EPackage)mmPackage);
                continue;
            }
            if (!(eObject instanceof Type)) continue;
            tit.prune();
        }
        return true;
    }

    public Resource loadResource(@NonNull URI oclURI) {
        BaseResource xtextResource = null;
        CompleteOCLStandaloneSetup.init();
        try {
            xtextResource = (BaseResource)this.resourceSet.getResource(oclURI, true);
        }
        catch (WrappedException e) {
            IStatus status;
            URI retryURI = null;
            Throwable cause = e.getCause();
            if (cause instanceof CoreException && (status = ((CoreException)cause).getStatus()).getCode() == 368 && status.getPlugin().equals("org.eclipse.core.resources") && oclURI.isPlatformResource()) {
                retryURI = URI.createPlatformPluginURI((String)oclURI.toPlatformString(false), (boolean)false);
            }
            if (retryURI != null) {
                xtextResource = (BaseResource)this.resourceSet.getResource(retryURI, true);
            }
            throw e;
        }
        EList errors = xtextResource.getErrors();
        assert (errors != null);
        String message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
        if (message != null) {
            this.error("Failed to load '" + oclURI, message);
            return null;
        }
        ASResource asResource = xtextResource.getASResource(this.metaModelManager);
        errors = asResource.getErrors();
        assert (errors != null);
        message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
        if (message != null) {
            this.error("Failed to load Pivot from '" + oclURI, message);
            return null;
        }
        return asResource;
    }
}

