/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.console;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ocl.examples.debug.vm.core.VMVariable;
import org.eclipse.ocl.examples.debug.vm.data.VMVariableData;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainLogger;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.evaluation.EvaluationHaltedException;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.context.ClassContext;
import org.eclipse.ocl.examples.pivot.context.ParserContext;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitorImpl;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerListener;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.manager.PivotIdResolver;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.BaseResource;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironment;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironmentFactory;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.ui.utilities.BaseUIUtil;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.examples.xtext.base.utilities.CS2PivotResourceAdapter;
import org.eclipse.ocl.examples.xtext.console.ColorManager;
import org.eclipse.ocl.examples.xtext.console.OCLConsole;
import org.eclipse.ocl.examples.xtext.console.XtextConsolePlugin;
import org.eclipse.ocl.examples.xtext.console.actions.CloseAction;
import org.eclipse.ocl.examples.xtext.console.actions.DebugAction;
import org.eclipse.ocl.examples.xtext.console.actions.LoadExpressionAction;
import org.eclipse.ocl.examples.xtext.console.actions.SaveExpressionAction;
import org.eclipse.ocl.examples.xtext.console.messages.ConsoleMessages;
import org.eclipse.ocl.examples.xtext.console.xtfo.EmbeddedXtextEditor;
import org.eclipse.ocl.examples.xtext.essentialocl.ui.model.BaseDocument;
import org.eclipse.ocl.examples.xtext.essentialocl.utilities.EssentialOCLCSResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.actions.ClearOutputAction;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.contentassist.DefaultContentAssistantFactory;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.ui.editor.outline.impl.OutlinePage;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class OCLConsolePage
extends Page
implements MetaModelManagerListener {
    private final OCLConsole console;
    private Composite page;
    private ITextViewer output;
    private ColorManager colorManager;
    private SourceViewer input;
    private EmbeddedXtextEditor editor;
    private String lastOCLExpression;
    private DebugAction debugAction;
    private ISelectionService selectionService;
    private ISelectionListener selectionListener;
    private EObject contextObject;
    private ParserContext parserContext;
    private MetaModelManager nullMetaModelManager = null;
    private DomainModelManager modelManager = null;

    protected OCLConsolePage(OCLConsole console) {
        this.console = console;
    }

    protected void append(String text, RGB rgb, boolean bold) {
        IDocument doc = this.getDocument();
        try {
            int offset = doc.getLength();
            text = String.valueOf(text != null ? text : "") + '\n';
            int length = text.length();
            if (offset > 0) {
                doc.replace(offset, 0, text);
            } else {
                doc.set(text);
            }
            StyleRange style = new StyleRange();
            style.start = offset;
            style.length = length;
            style.foreground = this.colorManager.getColor(rgb);
            if (bold) {
                style.fontStyle = 1;
            }
            this.output.getTextWidget().setStyleRange(style);
        }
        catch (BadLocationException e) {
            Status status = new Status(4, XtextConsolePlugin.getPluginId(), 1, ConsoleMessages.Output_Exception, (Throwable)e);
            XtextConsolePlugin.getInstance().getLog().log((IStatus)status);
        }
    }

    public void cancelValidation() {
        BaseDocument editorDocument = this.getEditorDocument();
        Job validationJob = editorDocument.getValidationJob();
        if (validationJob != null) {
            validationJob.cancel();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            while (validationJob.getState() == 4) {
                validationJob.cancel();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void createControl(Composite parent) {
        this.page = new SashForm(parent, 0x2000200);
        this.output = new TextViewer(this.page, 2818);
        this.output.getTextWidget().setLayoutData((Object)new GridData(1808));
        this.output.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.output.setEditable(false);
        this.output.setDocument((IDocument)new Document());
        this.colorManager = new ColorManager();
        this.createEditor(this.page);
        this.input = this.editor.getViewer();
        this.input.getTextWidget().addKeyListener((KeyListener)new InputKeyListener());
        this.input.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, final ISelection selection) {
                OutlinePage outlinePage;
                IXtextDocument xtextDocument;
                Element pivotElement;
                ContentOutline contentOutline;
                IPage currentPage;
                IConsole console;
                if (part instanceof IConsoleView && (console = ((IConsoleView)part).getConsole()) instanceof OCLConsole) {
                    return;
                }
                if (part instanceof ContentOutline && (currentPage = (contentOutline = (ContentOutline)part).getCurrentPage()) instanceof OutlinePage && (pivotElement = (Element)(xtextDocument = (outlinePage = (OutlinePage)currentPage).getXtextDocument()).readOnly((IUnitOfWork)new IUnitOfWork<Element, XtextResource>(){

                    public Element exec(@Nullable XtextResource state) throws Exception {
                        Element pivotObject;
                        EObjectNode eObjectNode;
                        URI uri;
                        EObject csObject;
                        Object selectedObject;
                        IStructuredSelection structuredSelection;
                        if (state != null && selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (selectedObject = structuredSelection.getFirstElement()) instanceof EObjectNode && (csObject = state.getEObject((uri = (eObjectNode = (EObjectNode)selectedObject).getEObjectURI()).fragment())) instanceof Pivotable && (pivotObject = ((Pivotable)csObject).getPivot()) != null) {
                            return pivotObject;
                        }
                        return null;
                    }
                })) != null) {
                    OCLConsolePage.this.selectionChanged((ISelection)new StructuredSelection((Object)pivotElement));
                    return;
                }
                OCLConsolePage.this.selectionChanged(selection);
            }
        };
        this.selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        this.selectionService.addPostSelectionListener(this.selectionListener);
        ISelection selection = BaseUIUtil.getActiveSelection((IWorkbenchSite)this.getSite());
        this.selectionChanged(selection);
        ((SashForm)this.page).setWeights(new int[]{2, 1});
        ClearOutputAction clear = new ClearOutputAction(this.output);
        CloseAction close = new CloseAction();
        SaveExpressionAction saveExpression = new SaveExpressionAction(this);
        LoadExpressionAction loadExpression = new LoadExpressionAction(this);
        this.debugAction = new DebugAction(this);
        IMenuManager menu = this.getSite().getActionBars().getMenuManager();
        menu.add((IAction)loadExpression);
        menu.add((IAction)saveExpression);
        menu.add((IAction)clear);
        menu.add((IAction)close);
        menu.add((IAction)this.debugAction);
        IToolBarManager toolbar = this.getSite().getActionBars().getToolBarManager();
        toolbar.appendToGroup("outputGroup", (IAction)loadExpression);
        toolbar.appendToGroup("outputGroup", (IAction)saveExpression);
        toolbar.appendToGroup("outputGroup", (IAction)clear);
        toolbar.appendToGroup("outputGroup", (IAction)close);
        toolbar.appendToGroup("outputGroup", (IAction)this.debugAction);
    }

    private int convertHeightInCharsToPixels(int i) {
        GC gc = new GC((Drawable)Display.getDefault());
        gc.setFont(this.editor.getViewer().getTextWidget().getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        int ret = (fontMetrics.getHeight() + fontMetrics.getAscent() + fontMetrics.getDescent() + fontMetrics.getLeading()) * i;
        gc.dispose();
        return ret;
    }

    private void createEditor(Composite s1) {
        Composite client = s1;
        Injector injector = XtextConsolePlugin.getInstance().getInjector("org.eclipse.ocl.examples.xtext.essentialocl.EssentialOCL");
        Composite editorComposite = client;
        this.editor = new EmbeddedXtextEditor(editorComposite, injector, 770);
        this.editor.getViewer().getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent e) {
                if ((e.keyCode == 0x1000050 || e.keyCode == 13) && (e.stateMask & 0x60000) == 0) {
                    e.doit = false;
                }
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = this.convertHeightInCharsToPixels(1);
        editorComposite.setLayoutData((Object)data);
    }

    public void dispose() {
        this.colorManager.dispose();
        this.selectionService.removePostSelectionListener(this.selectionListener);
        this.reset();
        super.dispose();
    }

    private void error(String message) {
        this.append(message, ColorManager.OUTPUT_ERROR, false);
        this.scrollText();
    }

    protected boolean evaluate(final String expression) {
        if (expression == null || expression.trim().length() <= 0) {
            this.error(ConsoleMessages.Result_NoExpression);
            return false;
        }
        boolean result = true;
        try {
            IDocument doc = this.getDocument();
            if (doc.getLength() > 0) {
                this.append("", ColorManager.DEFAULT, false);
            }
            this.append(ConsoleMessages.Heading_Evaluating, ColorManager.DEFAULT, true);
            this.append(expression, ColorManager.DEFAULT, false);
            this.append(ConsoleMessages.Heading_Results, ColorManager.DEFAULT, true);
            BaseDocument editorDocument = this.getEditorDocument();
            Object value = null;
            try {
                value = editorDocument.readOnly((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

                    public Object exec(@Nullable XtextResource state) throws Exception {
                        if (state != null) {
                            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                            EvaluationRunnable runnable = new EvaluationRunnable((BaseResource)state, expression);
                            progressService.busyCursorWhile((IRunnableWithProgress)runnable);
                            return runnable.getValue();
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                this.append(e.getMessage(), ColorManager.OUTPUT_ERROR, false);
            }
            if (value instanceof InvalidValueException) {
                InvalidValueException exception = (InvalidValueException)((Object)value);
                this.append(exception.getMessage(), ColorManager.OUTPUT_ERROR, true);
                Throwable cause = exception.getCause();
                if (cause != null && cause != exception) {
                    this.append(cause.getMessage(), ColorManager.OUTPUT_ERROR, false);
                }
            } else if (value != null) {
                CollectionValue collectionValue = ValuesUtil.isCollectionValue((Object)value);
                if (collectionValue != null) {
                    for (Object elementValue : collectionValue.iterable()) {
                        this.append(ValuesUtil.stringValueOf(elementValue), ColorManager.OUTPUT_RESULTS, false);
                    }
                } else {
                    this.append(ValuesUtil.stringValueOf((Object)value), ColorManager.OUTPUT_RESULTS, false);
                }
            } else {
                this.append(ValuesUtil.stringValueOf((Object)value), ColorManager.OUTPUT_ERROR, false);
            }
            this.scrollText();
            this.lastOCLExpression = expression;
        }
        catch (Exception e) {
            result = false;
            this.error(e.getLocalizedMessage() == null ? e.getClass().getName() : e.getLocalizedMessage());
        }
        return result;
    }

    protected void flushEvents() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        while (workbench.getDisplay().readAndDispatch()) {
        }
    }

    public EObject getContextObject() {
        return this.contextObject;
    }

    public Control getControl() {
        return this.page;
    }

    private IDocument getDocument() {
        return this.output.getDocument();
    }

    public IXtextDocument getDocument(URI trimFragment) {
        return this.getEditorDocument();
    }

    public BaseDocument getEditorDocument() {
        return (BaseDocument)this.editor.getDocument();
    }

    public String getLastOCLExpression() {
        return this.lastOCLExpression;
    }

    @NonNull
    public MetaModelManager getMetaModelManager(@Nullable EObject contextObject) {
        MetaModelManager metaModelManager;
        MetaModelManager metaModelManager2 = metaModelManager = contextObject != null ? PivotUtil.findMetaModelManager((EObject)contextObject) : null;
        if (metaModelManager != null) {
            return metaModelManager;
        }
        MetaModelManager nullMetaModelManager2 = this.nullMetaModelManager;
        if (nullMetaModelManager2 == null) {
            nullMetaModelManager2 = this.nullMetaModelManager = new MetaModelManager();
            nullMetaModelManager2.addListener((MetaModelManagerListener)this);
        }
        return nullMetaModelManager2;
    }

    protected ILaunch internalLaunchDebugger() {
        return this.debugAction.launch();
    }

    public void metaModelManagerDisposed(@NonNull MetaModelManager metaModelManager) {
        metaModelManager.removeListener((MetaModelManagerListener)this);
        this.reset();
    }

    protected void refreshSelection(final Object selected) {
        BaseDocument editorDocument = this.getEditorDocument();
        editorDocument.modify((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

            public Value exec(@Nullable XtextResource resource) throws Exception {
                CS2PivotResourceAdapter cs2PivotAdapter;
                Object adapted;
                Object selectedObject = selected;
                if (selectedObject instanceof IAdaptable && (adapted = ((IAdaptable)selectedObject).getAdapter(EObject.class)) != null) {
                    selectedObject = adapted;
                }
                if (selectedObject instanceof EObject) {
                    OCLConsolePage.this.contextObject = (EObject)selectedObject;
                } else {
                    OCLConsolePage.this.contextObject = null;
                }
                if (resource instanceof BaseCSResource && (cs2PivotAdapter = ((BaseCSResource)resource).findCS2ASAdapter()) != null) {
                    cs2PivotAdapter.dispose();
                }
                MetaModelManager metaModelManager = OCLConsolePage.this.getMetaModelManager(OCLConsolePage.this.contextObject);
                PivotIdResolver idResolver = metaModelManager.getIdResolver();
                DomainType staticType = idResolver.getStaticTypeOf((Object)OCLConsolePage.this.contextObject);
                Type contextType = metaModelManager.getType(staticType);
                OCLConsolePage.this.parserContext = (ParserContext)new ClassContext(metaModelManager, null, contextType);
                EssentialOCLCSResource csResource = (EssentialOCLCSResource)resource;
                if (csResource != null) {
                    ResourceSet resourceSet;
                    if (OCLConsolePage.this.contextObject != null) {
                        csResource.getCS2ASAdapter(metaModelManager);
                    }
                    if ((resourceSet = OCLConsolePage.this.editor.getResourceSet()) != null) {
                        MetaModelManagerResourceSetAdapter.getAdapter((ResourceSet)resourceSet, (MetaModelManager)metaModelManager);
                    }
                    csResource.setParserContext(OCLConsolePage.this.parserContext);
                }
                OCLConsolePage.this.console.setSelection(OCLConsolePage.this.contextObject);
                return null;
            }
        });
    }

    public void reset() {
        if (this.editor != null) {
            IXtextDocument document = this.editor.getDocument();
            MetaModelManager metaModelManager = (MetaModelManager)document.readOnly((IUnitOfWork)new IUnitOfWork<MetaModelManager, XtextResource>(){

                public MetaModelManager exec(@Nullable XtextResource state) throws Exception {
                    if (state == null) {
                        return null;
                    }
                    if (state instanceof BaseResource) {
                        ((BaseResource)state).setParserContext(null);
                    }
                    return PivotUtil.findMetaModelManager((Resource)state);
                }
            });
            this.flushEvents();
            if (metaModelManager != null) {
                metaModelManager.dispose();
            }
        }
        if (this.modelManager != null) {
            this.modelManager = null;
        }
        if (this.nullMetaModelManager != null) {
            this.nullMetaModelManager.dispose();
            this.nullMetaModelManager = null;
        }
        this.parserContext = null;
        this.contextObject = null;
    }

    protected void resetDocument() {
        IDocument doc = this.getDocument();
        if (doc != null) {
            doc.set("");
        }
    }

    private void scrollText() {
        this.output.revealRange(this.getDocument().getLength(), 0);
    }

    private void selectionChanged(ISelection sel) {
        VMVariableData vmVar;
        Object selectedObject = BaseUIUtil.getSelectedObject((ISelection)sel, (IWorkbenchSite)this.getSite());
        if (selectedObject instanceof VMVariable && (vmVar = ((VMVariable)selectedObject).getVmVar()) != null) {
            selectedObject = vmVar.valueObject;
        }
        this.refreshSelection(selectedObject);
    }

    public void setFocus() {
        this.input.getTextWidget().setFocus();
    }

    protected static class CancelableEvaluationVisitor
    extends EvaluationVisitorImpl {
        @NonNull
        private final IProgressMonitor monitor;

        protected CancelableEvaluationVisitor(@NonNull IProgressMonitor monitor, @NonNull Environment env, @NonNull EvaluationEnvironment evalEnv, @NonNull DomainModelManager modelManager) {
            super(env, evalEnv, modelManager);
            this.monitor = monitor;
        }

        @NonNull
        public EvaluationVisitor createNestedEvaluator() {
            EnvironmentFactory factory = this.environment.getFactory();
            EvaluationEnvironment nestedEvalEnv = factory.createEvaluationEnvironment(this.evaluationEnvironment);
            CancelableEvaluationVisitor nestedVisitor = new CancelableEvaluationVisitor(this.monitor, this.environment, nestedEvalEnv, this.modelManager);
            nestedVisitor.setLogger(this.getLogger());
            return nestedVisitor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColorChoices {
        DEFAULT,
        ERROR;

    }

    private class EvaluationRunnable
    implements IRunnableWithProgress {
        @NonNull
        private final BaseResource resource;
        @NonNull
        private final String expression;
        private Object value = null;

        public EvaluationRunnable(@NonNull BaseResource resource, String expression) {
            this.resource = resource;
            this.expression = expression;
        }

        public Object getValue() {
            return this.value;
        }

        public void run(IProgressMonitor monitor) {
            ExpressionInOCL expressionInOCL;
            monitor.beginTask(NLS.bind((String)ConsoleMessages.Progress_Title, (Object)this.expression), 10);
            monitor.subTask(ConsoleMessages.Progress_Synchronising);
            monitor.worked(1);
            MetaModelManager metaModelManager = OCLConsolePage.this.getMetaModelManager(OCLConsolePage.this.contextObject);
            try {
                PivotUtil.checkResourceErrors((String)"", (Resource)this.resource);
                expressionInOCL = OCLConsolePage.this.parserContext.getExpression(this.resource);
            }
            catch (ParserException e) {
                this.value = new InvalidValueException((Exception)((Object)e), ConsoleMessages.Result_ParsingFailure);
                return;
            }
            if (expressionInOCL != null) {
                monitor.subTask(ConsoleMessages.Progress_Extent);
                PivotEnvironmentFactory envFactory = new PivotEnvironmentFactory(null, metaModelManager);
                PivotEnvironment environment = envFactory.createEnvironment();
                EvaluationEnvironment evaluationEnvironment = envFactory.createEvaluationEnvironment();
                Object contextValue = metaModelManager.getIdResolver().boxedValueOf((Object)OCLConsolePage.this.contextObject);
                evaluationEnvironment.add((DomainTypedElement)DomainUtil.nonNullModel((Object)expressionInOCL.getContextVariable()), contextValue);
                DomainModelManager domainModelManager = evaluationEnvironment.createModelManager((Object)OCLConsolePage.this.contextObject);
                OCLConsolePage.this.modelManager = domainModelManager;
                DomainModelManager modelManager2 = domainModelManager;
                monitor.worked(2);
                monitor.subTask(ConsoleMessages.Progress_Evaluating);
                try {
                    CancelableEvaluationVisitor evaluationVisitor = new CancelableEvaluationVisitor(monitor, (Environment)environment, evaluationEnvironment, modelManager2);
                    evaluationVisitor.setLogger(new DomainLogger(){

                        public void append(final @NonNull String message) {
                            OCLConsolePage.this.getControl().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    OCLConsolePage.this.append(message, ColorManager.DEFAULT, false);
                                }
                            });
                        }
                    });
                    this.value = evaluationVisitor.visitExpressionInOCL(expressionInOCL);
                }
                catch (EvaluationHaltedException e) {
                    this.value = new InvalidValueException(ConsoleMessages.Result_EvaluationTerminated, new Object[0]);
                }
                catch (InvalidValueException e) {
                    this.value = e;
                }
                catch (Exception e) {
                    this.value = new InvalidValueException(e, ConsoleMessages.Result_EvaluationFailure);
                }
            }
            monitor.worked(4);
        }
    }

    private class InputKeyListener
    implements KeyListener {
        private boolean evaluationSuccess = false;
        private List<String> history = new ArrayList<String>();
        private int currentHistoryPointer = 0;

        private InputKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            IContentAssistant contentAssistant = OCLConsolePage.this.editor.getViewer().getContentAssistant();
            if (contentAssistant instanceof InterrogatableContentAssistant && ((InterrogatableContentAssistant)contentAssistant).isProposalPopupActive()) {
                return;
            }
            switch (e.keyCode) {
                case 13: {
                    if ((e.stateMask & 0x60000) != 0) break;
                    String text = OCLConsolePage.this.getEditorDocument().get();
                    this.evaluationSuccess = OCLConsolePage.this.evaluate(text.trim());
                    break;
                }
                case 0x1000005: {
                    if ((e.stateMask & 0x60000) != 0) break;
                    if (this.currentHistoryPointer == 0 && this.history.size() > 0) {
                        if (this.history.size() > 0 && this.history.get(0).length() == 0) {
                            this.history.remove(0);
                        }
                        this.history.add(0, OCLConsolePage.this.getEditorDocument().get().trim());
                        this.currentHistoryPointer = 1;
                        this.setTextFromHistory();
                        break;
                    }
                    if (this.currentHistoryPointer >= this.history.size() - 1) break;
                    ++this.currentHistoryPointer;
                    this.setTextFromHistory();
                    break;
                }
                case 0x1000006: {
                    if ((e.stateMask & 0x60000) != 0 || this.currentHistoryPointer <= 0) break;
                    --this.currentHistoryPointer;
                    this.setTextFromHistory();
                }
            }
        }

        public void keyReleased(KeyEvent e) {
            switch (e.keyCode) {
                case 13: {
                    if ((e.stateMask & 0x60000) != 0) break;
                    if (this.evaluationSuccess) {
                        OCLConsolePage.this.getEditorDocument().set("");
                        if (this.history.size() > 0 && this.history.get(0).trim().length() == 0) {
                            this.history.remove(0);
                        }
                        if (this.history.size() == 0 || !this.history.get(0).equals(OCLConsolePage.this.lastOCLExpression.trim())) {
                            this.history.add(0, OCLConsolePage.this.lastOCLExpression.trim());
                        }
                        this.currentHistoryPointer = 0;
                    }
                    this.evaluationSuccess = false;
                }
            }
        }

        protected void setTextFromHistory() {
            String newText = this.history.get(this.currentHistoryPointer);
            OCLConsolePage.this.getEditorDocument().set(newText);
            OCLConsolePage.this.input.setSelectedRange(newText.length(), 0);
        }
    }

    public static final class InterrogatableContentAssistant
    extends ContentAssistant {
        public boolean isProposalPopupActive() {
            return super.isProposalPopupActive();
        }
    }

    public static class InterrogatableContentAssistantFactory
    extends DefaultContentAssistantFactory {
        protected ContentAssistant createAssistant() {
            return new InterrogatableContentAssistant();
        }
    }
}

