/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.cs2as;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.Unlimited;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.BooleanLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionItem;
import org.eclipse.ocl.examples.pivot.CollectionLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionLiteralPart;
import org.eclipse.ocl.examples.pivot.CollectionRange;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.ConstructorExp;
import org.eclipse.ocl.examples.pivot.ConstructorPart;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.IfExp;
import org.eclipse.ocl.examples.pivot.IntegerLiteralExp;
import org.eclipse.ocl.examples.pivot.NullLiteralExp;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.RealLiteralExp;
import org.eclipse.ocl.examples.pivot.StringLiteralExp;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TupleLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralPart;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableExp;
import org.eclipse.ocl.examples.pivot.context.Base2PivotConversion;
import org.eclipse.ocl.examples.pivot.context.ParserContext;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.scoping.ScopeFilter;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.BaseResource;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.basecs.BaseCSPackage;
import org.eclipse.ocl.examples.xtext.base.basecs.ConstraintCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.basecs.SpecificationCS;
import org.eclipse.ocl.examples.xtext.base.cs2as.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2as.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.base.cs2as.Continuation;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.BooleanLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.CollectionLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.CollectionLiteralPartCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.CollectionTypeCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.ConstructorExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.ConstructorPartCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.ContextCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.ExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.ExpSpecificationCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.IfExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.IndexExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.InfixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.InvalidLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.InvocationExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.LiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NameExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NavigatingArgCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NestedExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NullLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NumberLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.OperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.PrefixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.PrimitiveLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.SelfExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.StringLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.TupleLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.TupleLiteralPartCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.TypeLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.TypeNameExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.UnlimitedNaturalLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.VariableCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.util.AbstractEssentialOCLCSContainmentVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EssentialOCLCSContainmentVisitor
extends AbstractEssentialOCLCSContainmentVisitor {
    private static final Logger logger = Logger.getLogger(EssentialOCLCSContainmentVisitor.class);

    public EssentialOCLCSContainmentVisitor(@NonNull CS2PivotConversion context) {
        super(context);
    }

    @Override
    public Continuation<?> visitBooleanLiteralExpCS(@NonNull BooleanLiteralExpCS csElement) {
        BooleanLiteralExp pivotElement = (BooleanLiteralExp)((CS2PivotConversion)this.context).refreshModelElement(BooleanLiteralExp.class, PivotPackage.Literals.BOOLEAN_LITERAL_EXP, (ModelElementCS)csElement);
        pivotElement.setBooleanSymbol(Boolean.valueOf(csElement.getName()).booleanValue());
        return null;
    }

    @Override
    public Continuation<?> visitCollectionLiteralExpCS(@NonNull CollectionLiteralExpCS csElement) {
        CollectionLiteralExp pivotElement = (CollectionLiteralExp)((CS2PivotConversion)this.context).refreshModelElement(CollectionLiteralExp.class, PivotPackage.Literals.COLLECTION_LITERAL_EXP, (ModelElementCS)csElement);
        ((CS2PivotConversion)this.context).refreshPivotList(CollectionLiteralPart.class, pivotElement.getPart(), csElement.getOwnedParts());
        return null;
    }

    @Override
    public Continuation<?> visitCollectionLiteralPartCS(@NonNull CollectionLiteralPartCS csElement) {
        if (csElement.getLastExpressionCS() == null) {
            ((CS2PivotConversion)this.context).refreshModelElement(CollectionItem.class, PivotPackage.Literals.COLLECTION_ITEM, (ModelElementCS)csElement);
        } else {
            ((CS2PivotConversion)this.context).refreshModelElement(CollectionRange.class, PivotPackage.Literals.COLLECTION_RANGE, (ModelElementCS)csElement);
        }
        return null;
    }

    @Override
    public Continuation<?> visitCollectionTypeCS(@NonNull CollectionTypeCS csElement) {
        return null;
    }

    public Continuation<?> visitConstraintCS(@NonNull ConstraintCS csElement) {
        Constraint asConstraint = (Constraint)this.refreshNamedElement(Constraint.class, PivotPackage.Literals.CONSTRAINT, (NamedElementCS)csElement);
        ExpSpecificationCS csStatusSpecification = (ExpSpecificationCS)csElement.getSpecification();
        ExpSpecificationCS csMessageSpecification = (ExpSpecificationCS)csElement.getMessageSpecification();
        if (csMessageSpecification == null) {
            OpaqueExpression asSpecification = (OpaqueExpression)PivotUtil.getPivot(OpaqueExpression.class, (Pivotable)csStatusSpecification);
            asConstraint.setSpecification(asSpecification);
        } else {
            TupleLiteralExp asTupleLiteralExp;
            PropertyCallExp asTuplePartExp;
            ExpressionInOCL asExpressionInOCL;
            HashMap<String, PrimitiveType> tupleParts = new HashMap<String, PrimitiveType>();
            tupleParts.put("message", this.metaModelManager.getStringType());
            tupleParts.put("status", this.metaModelManager.getBooleanType());
            TupleType tupleType = this.metaModelManager.getTupleManager().getTupleType("Tuple", tupleParts);
            Property statusProperty = (Property)DomainUtil.getNamedElement((Iterable)tupleType.getOwnedAttribute(), (String)"status");
            OpaqueExpression asSpecification = asConstraint.getSpecification();
            if (asSpecification instanceof ExpressionInOCL) {
                asExpressionInOCL = (ExpressionInOCL)asSpecification;
            } else {
                asExpressionInOCL = PivotFactory.eINSTANCE.createExpressionInOCL();
                asConstraint.setSpecification((OpaqueExpression)asExpressionInOCL);
            }
            OCLExpression asExpression = asExpressionInOCL.getBodyExpression();
            if (asExpression instanceof PropertyCallExp) {
                asTuplePartExp = (PropertyCallExp)asExpression;
            } else {
                asTuplePartExp = PivotFactory.eINSTANCE.createPropertyCallExp();
                asExpressionInOCL.setBodyExpression((OCLExpression)asTuplePartExp);
            }
            asTuplePartExp.setReferredProperty(statusProperty);
            asTuplePartExp.setType(statusProperty.getType());
            asTuplePartExp.setIsRequired(true);
            asExpression = asTuplePartExp.getSource();
            if (asExpression instanceof TupleLiteralExp) {
                asTupleLiteralExp = (TupleLiteralExp)asExpression;
            } else {
                asTupleLiteralExp = PivotFactory.eINSTANCE.createTupleLiteralExp();
                asTuplePartExp.setSource((OCLExpression)asTupleLiteralExp);
            }
            asTupleLiteralExp.setType((Type)tupleType);
            asTupleLiteralExp.setIsRequired(true);
            ArrayList<TupleLiteralPart> parts = new ArrayList<TupleLiteralPart>();
            TupleLiteralPart asStatusPart = (TupleLiteralPart)PivotUtil.getPivot(TupleLiteralPart.class, (Pivotable)csStatusSpecification);
            TupleLiteralPart asMessagePart = (TupleLiteralPart)PivotUtil.getPivot(TupleLiteralPart.class, (Pivotable)csMessageSpecification);
            if (asMessagePart != null && asStatusPart != null) {
                parts.add(asMessagePart);
                parts.add(asStatusPart);
            }
            ((CS2PivotConversion)this.context).refreshList(asTupleLiteralExp.getPart(), parts);
        }
        return null;
    }

    @Override
    public Continuation<?> visitConstructorExpCS(@NonNull ConstructorExpCS csElement) {
        PathNameCS pathName = csElement.getPathName();
        if (pathName != null) {
            CS2Pivot.setElementType((PathNameCS)pathName, (EClass)PivotPackage.Literals.TYPE, (ElementCS)csElement, null);
        }
        ConstructorExp pivotElement = (ConstructorExp)((CS2PivotConversion)this.context).refreshModelElement(ConstructorExp.class, PivotPackage.Literals.CONSTRUCTOR_EXP, (ModelElementCS)csElement);
        pivotElement.setValue(csElement.getValue());
        ((CS2PivotConversion)this.context).refreshPivotList(ConstructorPart.class, pivotElement.getPart(), csElement.getOwnedParts());
        return null;
    }

    @Override
    public Continuation<?> visitConstructorPartCS(@NonNull ConstructorPartCS csElement) {
        ((CS2PivotConversion)this.context).refreshModelElement(ConstructorPart.class, PivotPackage.Literals.CONSTRUCTOR_PART, (ModelElementCS)csElement);
        return null;
    }

    @Override
    public Continuation<?> visitContextCS(@NonNull ContextCS csElement) {
        ParserContext parserContext;
        ExpressionInOCL pivotElement = (ExpressionInOCL)((CS2PivotConversion)this.context).refreshModelElement(ExpressionInOCL.class, PivotPackage.Literals.EXPRESSION_IN_OCL, (ModelElementCS)csElement);
        PivotUtil.setBody((ExpressionInOCL)pivotElement, null, null);
        Resource resource = csElement.eResource();
        if (resource instanceof BaseResource && (parserContext = ((BaseResource)resource).getParserContext()) != null) {
            parserContext.initialize((Base2PivotConversion)this.context, pivotElement);
        }
        return null;
    }

    @Override
    public Continuation<?> visitExpCS(@NonNull ExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitExpSpecificationCS(@NonNull ExpSpecificationCS csElement) {
        EObject eContainer = csElement.eContainer();
        if (eContainer instanceof ConstraintCS) {
            ConstraintCS csConstraint = (ConstraintCS)eContainer;
            SpecificationCS csStatusSpecification = csConstraint.getSpecification();
            SpecificationCS csMessageSpecification = csConstraint.getMessageSpecification();
            if (csStatusSpecification != null && csMessageSpecification != null) {
                TupleLiteralPart csTupleLiteralPart = (TupleLiteralPart)((CS2PivotConversion)this.context).refreshModelElement(TupleLiteralPart.class, PivotPackage.Literals.TUPLE_LITERAL_PART, (ModelElementCS)csElement);
                EStructuralFeature eContainingFeature = csElement.eContainingFeature();
                if (eContainingFeature == BaseCSPackage.Literals.CONSTRAINT_CS__SPECIFICATION) {
                    csTupleLiteralPart.setName("status");
                    csTupleLiteralPart.setType((Type)this.metaModelManager.getBooleanType());
                } else if (eContainingFeature == BaseCSPackage.Literals.CONSTRAINT_CS__MESSAGE_SPECIFICATION) {
                    csTupleLiteralPart.setName("message");
                    csTupleLiteralPart.setType((Type)this.metaModelManager.getStringType());
                } else {
                    logger.error((Object)("unknown ExpSpecificationCS.eContainingFeature" + eContainingFeature));
                }
                return null;
            }
        }
        if (csElement.getOwnedExpression() != null) {
            ((CS2PivotConversion)this.context).refreshModelElement(ExpressionInOCL.class, PivotPackage.Literals.EXPRESSION_IN_OCL, (ModelElementCS)csElement);
        } else {
            ((CS2PivotConversion)this.context).refreshModelElement(OpaqueExpression.class, PivotPackage.Literals.OPAQUE_EXPRESSION, (ModelElementCS)csElement);
        }
        return null;
    }

    @Override
    public Continuation<?> visitIfExpCS(@NonNull IfExpCS csElement) {
        ((CS2PivotConversion)this.context).refreshModelElement(IfExp.class, PivotPackage.Literals.IF_EXP, (ModelElementCS)csElement);
        return null;
    }

    @Override
    public Continuation<?> visitIndexExpCS(@NonNull IndexExpCS csElement) {
        PathNameCS pathName = csElement.getPathName();
        assert (pathName != null);
        CS2Pivot.setElementType((PathNameCS)pathName, (EClass)PivotPackage.Literals.ELEMENT, (ElementCS)csElement, (ScopeFilter)NotOperationNotPackageFilter.INSTANCE);
        return null;
    }

    @Override
    public Continuation<?> visitInfixExpCS(@NonNull InfixExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitInvalidLiteralExpCS(@NonNull InvalidLiteralExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitInvocationExpCS(@NonNull InvocationExpCS csElement) {
        PathNameCS pathName = csElement.getPathName();
        assert (pathName != null);
        CS2Pivot.setElementType((PathNameCS)pathName, (EClass)PivotPackage.Literals.OPERATION, (ElementCS)csElement, null);
        return null;
    }

    @Override
    public Continuation<?> visitLiteralExpCS(@NonNull LiteralExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitNameExpCS(@NonNull NameExpCS csElement) {
        PathNameCS pathName = csElement.getPathName();
        assert (pathName != null);
        CS2Pivot.setElementType((PathNameCS)pathName, (EClass)PivotPackage.Literals.ELEMENT, (ElementCS)csElement, (ScopeFilter)NotOperationNotPackageFilter.INSTANCE);
        return null;
    }

    @Override
    public Continuation<?> visitNavigatingArgCS(@NonNull NavigatingArgCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitNestedExpCS(@NonNull NestedExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitNullLiteralExpCS(@NonNull NullLiteralExpCS csElement) {
        ((CS2PivotConversion)this.context).refreshModelElement(NullLiteralExp.class, PivotPackage.Literals.NULL_LITERAL_EXP, (ModelElementCS)csElement);
        return null;
    }

    @Override
    public Continuation<?> visitNumberLiteralExpCS(@NonNull NumberLiteralExpCS csElement) {
        Number number = csElement.getName();
        if (number instanceof BigDecimal || number instanceof Double || number instanceof Float) {
            RealLiteralExp pivotElement = (RealLiteralExp)((CS2PivotConversion)this.context).refreshModelElement(RealLiteralExp.class, PivotPackage.Literals.REAL_LITERAL_EXP, (ModelElementCS)csElement);
            pivotElement.setRealSymbol(number);
        } else {
            IntegerLiteralExp pivotElement;
            boolean isNegative;
            if (number instanceof BigInteger) {
                BigInteger bigInteger = (BigInteger)number;
                boolean bl = isNegative = bigInteger.signum() < 0;
                if (isNegative) {
                    if (bigInteger.compareTo(ValuesUtil.INTEGER_MIN_VALUE) >= 0) {
                        number = bigInteger.intValue();
                    } else if (bigInteger.compareTo(ValuesUtil.LONG_MIN_VALUE) >= 0) {
                        number = bigInteger.longValue();
                    }
                } else if (bigInteger.compareTo(ValuesUtil.INTEGER_MAX_VALUE) <= 0) {
                    number = bigInteger.intValue();
                } else if (bigInteger.compareTo(ValuesUtil.LONG_MAX_VALUE) <= 0) {
                    number = bigInteger.longValue();
                }
            } else {
                long longValue = number.longValue();
                boolean bl = isNegative = longValue < 0L;
                number = isNegative ? (Number)(longValue >= Integer.MIN_VALUE ? (Number)((int)longValue) : (Number)longValue) : (Number)(longValue <= Integer.MAX_VALUE ? (Number)((int)longValue) : (Number)longValue);
            }
            if (isNegative) {
                pivotElement = (IntegerLiteralExp)((CS2PivotConversion)this.context).refreshModelElement(IntegerLiteralExp.class, PivotPackage.Literals.INTEGER_LITERAL_EXP, (ModelElementCS)csElement);
                pivotElement.setIntegerSymbol(number);
            } else {
                pivotElement = (UnlimitedNaturalLiteralExp)((CS2PivotConversion)this.context).refreshModelElement(UnlimitedNaturalLiteralExp.class, PivotPackage.Literals.UNLIMITED_NATURAL_LITERAL_EXP, (ModelElementCS)csElement);
                pivotElement.setUnlimitedNaturalSymbol(number);
            }
        }
        return null;
    }

    @Override
    public Continuation<?> visitOperatorCS(@NonNull OperatorCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitPrefixExpCS(@NonNull PrefixExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitPrimitiveLiteralExpCS(@NonNull PrimitiveLiteralExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitSelfExpCS(@NonNull SelfExpCS csElement) {
        ((CS2PivotConversion)this.context).refreshModelElement(VariableExp.class, PivotPackage.Literals.VARIABLE_EXP, (ModelElementCS)csElement);
        return null;
    }

    @Override
    public Continuation<?> visitStringLiteralExpCS(@NonNull StringLiteralExpCS csElement) {
        StringLiteralExp pivotElement = (StringLiteralExp)((CS2PivotConversion)this.context).refreshModelElement(StringLiteralExp.class, PivotPackage.Literals.STRING_LITERAL_EXP, (ModelElementCS)csElement);
        EList<String> names = csElement.getName();
        if (names.size() == 0) {
            pivotElement.setStringSymbol("");
        } else if (names.size() == 1) {
            pivotElement.setStringSymbol((String)names.get(0));
        } else {
            StringBuilder s = new StringBuilder();
            for (String name : names) {
                s.append(name);
            }
            pivotElement.setStringSymbol(s.toString());
        }
        return null;
    }

    @Override
    public Continuation<?> visitTupleLiteralExpCS(@NonNull TupleLiteralExpCS csElement) {
        TupleLiteralExp pivotElement = (TupleLiteralExp)((CS2PivotConversion)this.context).refreshModelElement(TupleLiteralExp.class, PivotPackage.Literals.TUPLE_LITERAL_EXP, (ModelElementCS)csElement);
        ((CS2PivotConversion)this.context).refreshPivotList(TupleLiteralPart.class, pivotElement.getPart(), csElement.getOwnedParts());
        return null;
    }

    @Override
    public Continuation<?> visitTupleLiteralPartCS(@NonNull TupleLiteralPartCS csElement) {
        this.refreshNamedElement(TupleLiteralPart.class, PivotPackage.Literals.TUPLE_LITERAL_PART, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitTypeLiteralExpCS(@NonNull TypeLiteralExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitTypeNameExpCS(@NonNull TypeNameExpCS csElement) {
        PathNameCS pathName = csElement.getPathName();
        assert (pathName != null);
        CS2Pivot.setElementType((PathNameCS)pathName, (EClass)PivotPackage.Literals.TYPE, (ElementCS)csElement, null);
        return null;
    }

    @Override
    public Continuation<?> visitUnlimitedNaturalLiteralExpCS(@NonNull UnlimitedNaturalLiteralExpCS csElement) {
        UnlimitedNaturalLiteralExp pivotElement = (UnlimitedNaturalLiteralExp)((CS2PivotConversion)this.context).refreshModelElement(UnlimitedNaturalLiteralExp.class, PivotPackage.Literals.UNLIMITED_NATURAL_LITERAL_EXP, (ModelElementCS)csElement);
        pivotElement.setName("*");
        pivotElement.setUnlimitedNaturalSymbol((Number)Unlimited.INSTANCE);
        return null;
    }

    @Override
    public Continuation<?> visitVariableCS(@NonNull VariableCS csElement) {
        this.refreshNamedElement(Variable.class, PivotPackage.Literals.VARIABLE, csElement);
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NotOperationNotPackageFilter
    implements ScopeFilter {
        public static NotOperationNotPackageFilter INSTANCE = new NotOperationNotPackageFilter();

        private NotOperationNotPackageFilter() {
        }

        public int compareMatches(@NonNull MetaModelManager metaModelManager, @NonNull Object match1, @Nullable Map<TemplateParameter, ParameterableElement> bindings1, @NonNull Object match2, @Nullable Map<TemplateParameter, ParameterableElement> bindings2) {
            return 0;
        }

        public boolean matches(@NonNull EnvironmentView environmentView, @NonNull Object object) {
            return !(object instanceof Operation) && !(object instanceof Package);
        }
    }
}

