/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.cs2as;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.AssociativityKind;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Precedence;
import org.eclipse.ocl.examples.pivot.TupleLiteralPart;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.basecs.ConstraintCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.basecs.SpecificationCS;
import org.eclipse.ocl.examples.xtext.base.cs2as.BasicContinuation;
import org.eclipse.ocl.examples.xtext.base.cs2as.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.base.cs2as.Continuation;
import org.eclipse.ocl.examples.xtext.base.cs2as.Dependency;
import org.eclipse.ocl.examples.xtext.base.cs2as.SingleContinuation;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.BinaryOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.CollectionTypeCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.ContextCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.ExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.ExpSpecificationCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.InfixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.InvocationExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NameExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NavigatingArgCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NavigationRole;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.OperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.PrefixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.TypeNameExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.UnaryOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.VariableCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.util.AbstractEssentialOCLCSPostOrderVisitor;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EssentialOCLCSPostOrderVisitor
extends AbstractEssentialOCLCSPostOrderVisitor {
    static final Logger logger = Logger.getLogger(EssentialOCLCSPostOrderVisitor.class);
    @NonNull
    protected final MetaModelManager metaModelManager;

    public EssentialOCLCSPostOrderVisitor(@NonNull CS2PivotConversion context) {
        super(context);
        this.metaModelManager = context.getMetaModelManager();
    }

    protected void createInfixOperatorTree(InfixExpCS csInfix) {
        Map<Precedence, List<Integer>> precedenceToOperatorIndexes = this.createInfixPrecedenceToOperatorIndexesMap(csInfix);
        ArrayList<Precedence> sortedPrecedences = new ArrayList<Precedence>(precedenceToOperatorIndexes.keySet());
        Collections.sort(sortedPrecedences, PivotUtil.PrecedenceComparator.INSTANCE);
        EList<ExpCS> csExpressions = csInfix.getOwnedExpression();
        EList<BinaryOperatorCS> csOperators = csInfix.getOwnedOperator();
        for (Precedence precedence : sortedPrecedences) {
            boolean isLeft = precedence == null || precedence.getAssociativity() == AssociativityKind.LEFT;
            List<Integer> operatorIndexes = precedenceToOperatorIndexes.get(precedence);
            int operatorCount = operatorIndexes.size();
            int iFirst = isLeft ? 0 : operatorCount - 1;
            int iIndex = isLeft ? 1 : -1;
            int iLast = isLeft ? operatorCount : -1;
            int i = iFirst;
            while (i != iLast) {
                int operatorIndex = operatorIndexes.get(i);
                BinaryOperatorCS csOperator = (BinaryOperatorCS)csOperators.get(operatorIndex);
                ExpCS csSource = (ExpCS)csExpressions.get(operatorIndex);
                while (csSource.getParent() != null && csSource.getParent() != csOperator) {
                    csSource = csSource.getParent();
                }
                this.setSource(csOperator, csSource);
                ExpCS csArgument = (ExpCS)csExpressions.get(operatorIndex + 1);
                while (csArgument.getParent() != null && csArgument.getParent() != csOperator) {
                    csArgument = csArgument.getParent();
                }
                this.setArgument(csOperator, csArgument);
                i += iIndex;
            }
        }
    }

    protected Map<Precedence, List<Integer>> createInfixPrecedenceToOperatorIndexesMap(InfixExpCS csInfix) {
        EList<BinaryOperatorCS> csOperators = csInfix.getOwnedOperator();
        int operatorCount = csInfix.getOwnedExpression().size() - 1;
        HashMap<Precedence, List<Integer>> precedenceToOperatorIndex = new HashMap<Precedence, List<Integer>>();
        int operatorIndex = 0;
        while (operatorIndex < operatorCount) {
            BinaryOperatorCS csOperator = (BinaryOperatorCS)csOperators.get(operatorIndex);
            String operatorName = csOperator.getName();
            assert (operatorName != null);
            Precedence precedence = this.metaModelManager.getInfixPrecedence(operatorName);
            ArrayList<Integer> indexesList = (ArrayList<Integer>)precedenceToOperatorIndex.get(precedence);
            if (indexesList == null) {
                indexesList = new ArrayList<Integer>();
                precedenceToOperatorIndex.put(precedence, indexesList);
            }
            indexesList.add(operatorIndex);
            ++operatorIndex;
        }
        return precedenceToOperatorIndex;
    }

    protected void initializePrefixOperators(PrefixExpCS prefixExpCS, OperatorCS csParent) {
        prefixExpCS.setParent(null);
        for (UnaryOperatorCS csUnaryOperator : prefixExpCS.getOwnedOperator()) {
            if (csParent instanceof UnaryOperatorCS) {
                this.setSource(csParent, csUnaryOperator);
            } else if (csParent instanceof BinaryOperatorCS) {
                if (csParent.getSource() == prefixExpCS) {
                    this.setSource(csParent, csUnaryOperator);
                } else {
                    this.setArgument((BinaryOperatorCS)csParent, csUnaryOperator);
                }
            }
            ExpCS csChild = prefixExpCS.getOwnedExpression();
            this.setSource(csUnaryOperator, csChild);
            csParent = csUnaryOperator;
        }
    }

    protected void interleavePrefixes(InfixExpCS csElement) {
        for (ExpCS csExp : csElement.getOwnedExpression()) {
            if (!(csExp instanceof PrefixExpCS)) continue;
            PrefixExpCS prefixExpCS = (PrefixExpCS)csExp;
            OperatorCS csExpressionParent = prefixExpCS.getParent();
            this.initializePrefixOperators(prefixExpCS, csExpressionParent);
            for (UnaryOperatorCS csUnaryOperator : prefixExpCS.getOwnedOperator()) {
                this.interleaveUnaryOperator(csUnaryOperator);
            }
        }
    }

    protected void interleaveUnaryOperator(UnaryOperatorCS csOperator) {
        OperatorCS csParent;
        while ((csParent = csOperator.getParent()) instanceof BinaryOperatorCS) {
            int unaryOrder;
            String parentOperatorName = csParent.getName();
            assert (parentOperatorName != null);
            Precedence parentPrecedence = this.metaModelManager.getInfixPrecedence(parentOperatorName);
            String operatorName = csOperator.getName();
            assert (operatorName != null);
            Precedence unaryPrecedence = this.metaModelManager.getPrefixPrecedence(operatorName);
            int parentOrder = parentPrecedence != null ? parentPrecedence.getOrder().intValue() : -1;
            int n = unaryOrder = unaryPrecedence != null ? unaryPrecedence.getOrder().intValue() : -1;
            if (unaryOrder < parentOrder) break;
            OperatorCS csGrandParent = csParent.getParent();
            ExpCS csExp = csOperator.getSource();
            if (csOperator != csParent.getSource()) break;
            this.setSource(csParent, null);
            if (csGrandParent instanceof BinaryOperatorCS) {
                if (csGrandParent.getSource() == csParent) {
                    this.setSource(csGrandParent, csOperator);
                } else {
                    this.setArgument((BinaryOperatorCS)csGrandParent, csOperator);
                }
            }
            this.setSource(csOperator, csParent);
            this.setSource(csParent, csExp);
        }
    }

    private void setArgument(BinaryOperatorCS csParent, ExpCS csArgument) {
        csArgument.setParent(csParent);
        csParent.setArgument(csArgument);
        int i = 0;
        OperatorCS csOperator = csParent.getParent();
        while (csOperator != null) {
            if (csOperator == csParent) {
                logger.error((Object)"Operator loop established");
            } else if (i++ > 1000) {
                logger.error((Object)"Operator depth limit exceeded");
            }
            csOperator = csOperator.getParent();
        }
    }

    private void setParameterRole(NavigatingArgCS csArgument, NavigationRole aRole) {
        csArgument.setRole(aRole);
        ExpCS csName = csArgument.getName();
        if (csName instanceof NameExpCS) {
            ILeafNode leafNode;
            PathNameCS csPathName = ((NameExpCS)csName).getPathName();
            Variable parameter = (Variable)((CS2PivotConversion)this.context).refreshModelElement(Variable.class, PivotPackage.Literals.VARIABLE, (ModelElementCS)csName);
            ICompositeNode node = NodeModelUtils.getNode((EObject)csName);
            if (node != null && (leafNode = ElementUtil.getLeafNode((INode)node)) != null) {
                String varName = leafNode.getText();
                assert (varName != null);
                ((CS2PivotConversion)this.context).refreshName((NamedElement)parameter, varName);
                EList path = csPathName.getPath();
                PathElementCS csPathElement = (PathElementCS)path.get(path.size() - 1);
                csPathElement.setElement((Element)parameter);
                csPathElement.setElementType(null);
            }
        }
    }

    private void setSource(OperatorCS csParent, ExpCS csSource) {
        if (csSource != null) {
            csSource.setParent(csParent);
            int i = 0;
            OperatorCS csOperator = csParent.getParent();
            while (csOperator != null) {
                if (csOperator == csParent) {
                    logger.error((Object)"Operator loop established");
                } else if (i++ > 1000) {
                    logger.error((Object)"Operator depth limit exceeded");
                }
                csOperator = csOperator.getParent();
            }
            csParent.setSource(csSource);
        } else {
            csParent.getSource().setParent(null);
            csParent.setSource(csSource);
        }
    }

    @Override
    public Continuation<?> visitCollectionTypeCS(@NonNull CollectionTypeCS csCollectionType) {
        return null;
    }

    public Continuation<?> visitConstraintCS(@NonNull ConstraintCS csConstraint) {
        return new ConstraintCSCompletion((CS2PivotConversion)this.context, csConstraint);
    }

    @Override
    public Continuation<?> visitContextCS(@NonNull ContextCS csContext) {
        ExpCS ownedExpression = csContext.getOwnedExpression();
        if (ownedExpression != null) {
            return new ContextCSCompletion((CS2PivotConversion)this.context, csContext);
        }
        return null;
    }

    @Override
    public Continuation<?> visitExpCS(@NonNull ExpCS csExp) {
        return null;
    }

    @Override
    @Nullable
    public final Continuation<?> visitExpSpecificationCS(@NonNull ExpSpecificationCS csElement) {
        if (!(csElement.eContainer() instanceof ConstraintCS)) {
            return new ExpSpecificationCSCompletion((CS2PivotConversion)this.context, csElement);
        }
        return null;
    }

    @Override
    public Continuation<?> visitInfixExpCS(@NonNull InfixExpCS csInfixExp) {
        this.createInfixOperatorTree(csInfixExp);
        this.interleavePrefixes(csInfixExp);
        return null;
    }

    @Override
    public Continuation<?> visitInvocationExpCS(@NonNull InvocationExpCS csNavigatingExp) {
        EList<NavigatingArgCS> csArguments = csNavigatingExp.getArgument();
        if (csArguments.size() > 0) {
            NavigationRole role = NavigationRole.EXPRESSION;
            int i = csArguments.size() - 1;
            while (i >= 0) {
                NavigatingArgCS csArgument = (NavigatingArgCS)csArguments.get(i);
                switch (role) {
                    case EXPRESSION: {
                        csArgument.setRole(NavigationRole.EXPRESSION);
                        if (!"|".equals(csArgument.getPrefix())) break;
                        role = NavigationRole.ACCUMULATOR;
                        break;
                    }
                    case ACCUMULATOR: {
                        if (csArgument.getInit() != null) {
                            this.setParameterRole(csArgument, NavigationRole.ACCUMULATOR);
                            if (!";".equals(csArgument.getPrefix())) break;
                            role = NavigationRole.ITERATOR;
                            break;
                        }
                        role = NavigationRole.ITERATOR;
                        this.setParameterRole(csArgument, NavigationRole.ITERATOR);
                        break;
                    }
                    case ITERATOR: {
                        this.setParameterRole(csArgument, NavigationRole.ITERATOR);
                    }
                }
                --i;
            }
        }
        return null;
    }

    @Override
    public Continuation<?> visitOperatorCS(@NonNull OperatorCS csOperator) {
        return null;
    }

    public Continuation<?> visitPathNameCS(@NonNull PathNameCS object) {
        return super.visitPathNameCS(object);
    }

    @Override
    public Continuation<?> visitPrefixExpCS(@NonNull PrefixExpCS csPrefixExp) {
        if (!(csPrefixExp.eContainer() instanceof InfixExpCS)) {
            this.initializePrefixOperators(csPrefixExp, null);
        }
        return null;
    }

    public final Continuation<?> visitSpecificationCS(@NonNull SpecificationCS csSpecification) {
        return null;
    }

    @Override
    public Continuation<?> visitTypeNameExpCS(@NonNull TypeNameExpCS object) {
        return null;
    }

    @Override
    public Continuation<?> visitVariableCS(@NonNull VariableCS csVariable) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConstraintCSCompletion
    extends SingleContinuation<ConstraintCS> {
        public ConstraintCSCompletion(@NonNull CS2PivotConversion context, @NonNull ConstraintCS csElement) {
            super(context, null, null, (EObject)csElement, new Dependency[0]);
        }

        public BasicContinuation<?> execute() {
            Constraint asConstraint = (Constraint)PivotUtil.getPivot(Constraint.class, (Pivotable)((Pivotable)this.csElement));
            ExpSpecificationCS csStatusSpecification = (ExpSpecificationCS)((ConstraintCS)this.csElement).getSpecification();
            if (asConstraint != null && csStatusSpecification != null) {
                ExpCS csStatusExpression = csStatusSpecification.getOwnedExpression();
                if (csStatusExpression != null) {
                    ExpressionInOCL asSpecification = (ExpressionInOCL)asConstraint.getSpecification();
                    this.context.refreshContextVariable(asSpecification);
                    ExpSpecificationCS csMessageSpecification = (ExpSpecificationCS)((ConstraintCS)this.csElement).getMessageSpecification();
                    String statusText = ElementUtil.getExpressionText((ElementCS)csStatusExpression);
                    if (csMessageSpecification == null) {
                        OCLExpression asExpression = (OCLExpression)this.context.visitLeft2Right(OCLExpression.class, (ElementCS)csStatusExpression);
                        asSpecification.setBodyExpression(asExpression);
                        this.context.setType((TypedElement)asSpecification, asExpression != null ? asExpression.getType() : null, asExpression != null && asExpression.isRequired());
                        PivotUtil.setBody((ExpressionInOCL)asSpecification, (OCLExpression)asExpression, (String)statusText);
                    } else {
                        TupleLiteralPart asStatusTuplePart = (TupleLiteralPart)PivotUtil.getNonNullAst(TupleLiteralPart.class, (Pivotable)csStatusSpecification);
                        OCLExpression asStatusExpression = (OCLExpression)this.context.visitLeft2Right(OCLExpression.class, (ElementCS)csStatusExpression);
                        asStatusTuplePart.setInitExpression(asStatusExpression);
                        TupleLiteralPart asMessageTuplePart = (TupleLiteralPart)PivotUtil.getNonNullAst(TupleLiteralPart.class, (Pivotable)csMessageSpecification);
                        ExpCS csMessageExpression = csMessageSpecification.getOwnedExpression();
                        OCLExpression asMessageExpression = csMessageExpression != null ? (OCLExpression)this.context.visitLeft2Right(OCLExpression.class, (ElementCS)csMessageExpression) : null;
                        asMessageTuplePart.setInitExpression(asMessageExpression);
                        OCLExpression asTuplePartExp = asSpecification.getBodyExpression();
                        this.context.setType((TypedElement)asSpecification, asTuplePartExp.getType(), true);
                        String messageText = csMessageExpression != null ? ElementUtil.getExpressionText((ElementCS)csMessageExpression) : "null";
                        String tupleText = PivotUtil.createTupleValuedConstraint((String)statusText, null, (String)messageText);
                        PivotUtil.setBody((ExpressionInOCL)asSpecification, (OCLExpression)asTuplePartExp, (String)tupleText);
                    }
                } else {
                    OpaqueExpression asSpecification = asConstraint.getSpecification();
                    PivotUtil.setBody((OpaqueExpression)asSpecification, (String)csStatusSpecification.getExprString());
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ContextCSCompletion
    extends SingleContinuation<ContextCS> {
        public ContextCSCompletion(@NonNull CS2PivotConversion context, @NonNull ContextCS csElement) {
            super(context, null, null, (EObject)csElement, new Dependency[0]);
        }

        public BasicContinuation<?> execute() {
            this.context.visitLeft2Right(Element.class, (ElementCS)this.csElement);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExpSpecificationCSCompletion
    extends SingleContinuation<ExpSpecificationCS> {
        public ExpSpecificationCSCompletion(@NonNull CS2PivotConversion context, @NonNull ExpSpecificationCS csElement) {
            super(context, null, null, (EObject)csElement, new Dependency[0]);
        }

        public BasicContinuation<?> execute() {
            ExpressionInOCL asSpecification = (ExpressionInOCL)PivotUtil.getPivot(ExpressionInOCL.class, (Pivotable)((Pivotable)this.csElement));
            if (asSpecification != null) {
                this.context.refreshContextVariable(asSpecification);
                ExpCS csExpression = ((ExpSpecificationCS)this.csElement).getOwnedExpression();
                OCLExpression asExpression = csExpression != null ? (OCLExpression)this.context.visitLeft2Right(OCLExpression.class, (ElementCS)csExpression) : null;
                String statusText = csExpression != null ? ElementUtil.getExpressionText((ElementCS)csExpression) : "null";
                PivotUtil.setBody((ExpressionInOCL)asSpecification, (OCLExpression)asExpression, (String)statusText);
                this.context.setType((TypedElement)asSpecification, asExpression != null ? asExpression.getType() : null, asExpression != null && asExpression.isRequired());
            }
            return null;
        }
    }
}

