/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.modelelement;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.customization.properties.modelelement.GenericAttributeObservable;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.extensible.Query;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.widgets.providers.AbstractStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.views.properties.modelelement.AbstractModelElement;

public class GenericAttributeModelElement
extends AbstractModelElement {
    protected EObject source;
    protected EditingDomain domain;
    private EStructuralFeature createIn;
    private EFactory createFrom;
    private EClass createAsValue;
    private EClass createAsReference;

    public GenericAttributeModelElement(EObject source, EditingDomain domain, EStructuralFeature createIn, EFactory createFrom, EClass createAsValue, EClass createAsReference) {
        this.source = source;
        this.domain = domain;
        this.createIn = createIn;
        this.createFrom = createFrom;
        this.createAsValue = createAsValue;
        this.createAsReference = createAsReference;
    }

    public IObservableValue doGetObservable(String propertyPath) {
        return new GenericAttributeObservable(this.source, this.domain, this.createIn, this.createFrom, this.createAsValue, this.createAsReference, propertyPath);
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        return new AbstractStaticContentProvider(){

            public Object[] getElements() {
                Collection result = ItemPropertyDescriptor.getReachableObjectsOfType((EObject)GenericAttributeModelElement.this.source, (EClassifier)EcorePackage.eINSTANCE.getEObject());
                Iterator iterator = result.iterator();
                while (iterator.hasNext()) {
                    EObject eObject = (EObject)iterator.next();
                    if (eObject instanceof Query) continue;
                    iterator.remove();
                }
                return result.toArray();
            }
        };
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        try {
            return ((LabelProviderService)ServiceUtilsForResource.getInstance().getServiceRegistry(this.source.eResource()).getService(LabelProviderService.class)).getLabelProvider();
        }
        catch (ServiceException ex) {
            return new LabelProvider();
        }
    }

    public Object getDefaultValue(String propertyPath) {
        return "";
    }
}

