/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.storage.actions.workspace;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.papyrus.customization.properties.messages.Messages;
import org.eclipse.papyrus.customization.properties.storage.actions.IContextDeleteAction;
import org.eclipse.papyrus.views.properties.contexts.Context;

public class WorkspaceContextDeleteAction
implements IContextDeleteAction {
    @Override
    public String getToolTip() {
        return Messages.WorkspaceContextDeleteAction_0;
    }

    @Override
    public void delete(Context context, IProgressMonitor monitor) throws CoreException {
        File directory = new File(context.eResource().getURI().toFileString()).getParentFile();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)(String.valueOf(Messages.WorkspaceContextDeleteAction_1) + context.getName()), (int)-1);
        try {
            this.delete(directory);
        }
        finally {
            sub.done();
        }
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File subFile = fileArray[n2];
                this.delete(subFile);
                ++n2;
            }
        }
        file.delete();
    }
}

