/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.custom.ui.internal.query;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.papyrus.emf.facet.custom.metamodel.custompt.IImage;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.ImageProvider;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.custompt.ImageWrapper;
import org.eclipse.papyrus.emf.facet.efacet.core.IFacetManager;
import org.eclipse.papyrus.emf.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetAttribute;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetReference;
import org.eclipse.papyrus.emf.facet.query.java.core.IJavaQuery2;
import org.eclipse.papyrus.emf.facet.query.java.core.IParameterValueList2;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageQuery
implements IJavaQuery2<EObject, IImage> {
    public IImage evaluate(EObject source, IParameterValueList2 parameterValues, IFacetManager facetManager) throws DerivedTypedElementException {
        IImage result = null;
        ETypedElement sfParam = null;
        if (parameterValues != null) {
            sfParam = (ETypedElement)parameterValues.getParameterValueByName("eStructuralFeature").getValue();
        }
        result = sfParam == null ? ImageQuery.getEObjectImage(source) : ImageQuery.getLinkImage(sfParam);
        return result;
    }

    public static IImage getEObjectImage(EObject source) {
        ImageWrapper result = null;
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        try {
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)source, IItemLabelProvider.class);
            if (itemLabelProvider != null) {
                Object imageObject = itemLabelProvider.getImage((Object)source);
                Image image = ExtendedImageRegistry.getInstance().getImage(imageObject);
                result = new ImageWrapper(image);
            }
        }
        finally {
            adapterFactory.dispose();
        }
        return result;
    }

    private static IImage getLinkImage(ETypedElement sfParam) {
        Image image = null;
        image = sfParam instanceof FacetReference ? ImageProvider.getInstance().getFacetLinkIcon() : (sfParam instanceof EReference ? ImageQuery.getReferenceImage((EReference)sfParam) : (sfParam instanceof FacetAttribute ? ImageProvider.getInstance().getFacetAttributeIcon() : (sfParam instanceof EAttribute ? ImageQuery.getAttributeImage() : ImageProvider.getInstance().getFeatureIcon())));
        return new ImageWrapper(image);
    }

    private static Image getReferenceImage(EReference reference) {
        EReference opposite = reference.getEOpposite();
        Image result = reference.isContainment() ? (opposite == null ? ImageProvider.getInstance().getUnidirectionalAggregIcon() : ImageProvider.getInstance().getAggregIcon()) : (opposite != null && opposite.isContainment() ? ImageProvider.getInstance().getInvAggregIcon() : (opposite == null ? ImageProvider.getInstance().getUnidirectionalLinkIcon() : ImageProvider.getInstance().getLinkIcon()));
        return result;
    }

    private static Image getAttributeImage() {
        return ImageProvider.getInstance().getAttributeIcon();
    }
}

