/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.core.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.emf.facet.efacet.core.internal.FacetManagerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FacetCache
extends AdapterImpl {
    private final FacetManagerContext context;
    private long currentGeneration = -1L;
    private final Map<ETypedElement, ETypedElement> overrides = new HashMap<ETypedElement, ETypedElement>();

    FacetCache(EObject owner, FacetManagerContext context) {
        this.context = context;
        owner.eAdapters().add((Object)this);
    }

    static FacetCache getInstance(EObject element, FacetManagerContext context) {
        FacetCache result = (FacetCache)EcoreUtil.getExistingAdapter((Notifier)element, (Object)context);
        if (result == null) {
            result = new FacetCache(element, context);
        }
        return result;
    }

    public boolean isAdapterForType(Object type) {
        return type == this.context;
    }

    public void notifyChanged(Notification msg) {
        if (!msg.isTouch()) {
            this.currentGeneration = -1L;
        }
    }

    public <T extends ETypedElement> T resolve(T feature) {
        if (this.context.facetGeneration > this.currentGeneration) {
            this.overrides.clear();
            this.currentGeneration = this.context.facetGeneration;
        }
        ETypedElement result = this.overrides.get(feature);
        return (T)result;
    }

    <T extends ETypedElement> void add(T feature, T override) {
        this.overrides.put(feature, override);
    }
}

