/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.utils;

import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;

public class TransactionHelper {
    public static void run(EditingDomain domain, Runnable writeOperation) throws InterruptedException, RollbackException {
        if (domain instanceof TransactionalEditingDomain) {
            TransactionHelper.run((TransactionalEditingDomain)domain, writeOperation);
        } else {
            writeOperation.run();
        }
    }

    public static void run(TransactionalEditingDomain domain, final Runnable writeOperation) throws InterruptedException, RollbackException {
        if (domain instanceof InternalTransactionalEditingDomain) {
            TransactionHelper.run((InternalTransactionalEditingDomain)domain, writeOperation);
        } else {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    writeOperation.run();
                }
            });
        }
    }

    public static void run(InternalTransactionalEditingDomain domain, Runnable writeOperation) throws InterruptedException, RollbackException {
        InternalTransaction transaction = domain.startTransaction(false, Collections.emptyMap());
        try {
            writeOperation.run();
        }
        finally {
            transaction.commit();
        }
    }
}

