/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.editor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.contentoutline.ContentOutlineRegistry;
import org.eclipse.papyrus.infra.core.contentoutline.IPapyrusContentOutlinePage;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.editor.IPapyrusPageInput;
import org.eclipse.papyrus.infra.core.editor.IReloadableEditor;
import org.eclipse.papyrus.infra.core.editor.MultiDiagramEditorSelectionContext;
import org.eclipse.papyrus.infra.core.editor.MultiDiagramPropertySheetPage;
import org.eclipse.papyrus.infra.core.editor.reload.EditorReloadEvent;
import org.eclipse.papyrus.infra.core.editor.reload.IEditorReloadListener;
import org.eclipse.papyrus.infra.core.lifecycleevents.DoSaveEvent;
import org.eclipse.papyrus.infra.core.lifecycleevents.IEditorInputChangedListener;
import org.eclipse.papyrus.infra.core.lifecycleevents.ISaveAndDirtyService;
import org.eclipse.papyrus.infra.core.multidiagram.actionbarcontributor.ActionBarContributorRegistry;
import org.eclipse.papyrus.infra.core.multidiagram.actionbarcontributor.CoreComposedActionBarContributor;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IContentChangedListener;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ISashWindowsContentProvider;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.DiSashModelManager;
import org.eclipse.papyrus.infra.core.sasheditor.editor.AbstractMultiPageSashEditor;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sasheditor.editor.gef.MultiDiagramEditorGefDelegate;
import org.eclipse.papyrus.infra.core.services.EditorLifecycleManager;
import org.eclipse.papyrus.infra.core.services.ExtensionServicesRegistry;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceMultiException;
import org.eclipse.papyrus.infra.core.services.ServiceStartKind;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.services.internal.EditorLifecycleManagerImpl;
import org.eclipse.papyrus.infra.core.services.internal.InternalEditorLifecycleManager;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;

public class CoreMultiDiagramEditor
extends AbstractMultiPageSashEditor
implements IMultiDiagramEditor,
ITabbedPropertySheetPageContributor,
IGotoMarker,
IEditingDomainProvider {
    private MultiDiagramEditorGefDelegate gefAdaptorDelegate;
    private ContentOutlineRegistry contentOutlineRegistry;
    private ServicesRegistry servicesRegistry;
    private ActionBarContributorRegistry actionBarContributorRegistry;
    protected DiSashModelManager sashModelMngr;
    protected ISaveAndDirtyService saveAndDirtyService;
    private final List<IPropertySheetPage> propertiesPages = new LinkedList<IPropertySheetPage>();
    protected EditorInputChangedListener editorInputChangedListener;
    private TransactionalEditingDomain transactionalEditingDomain;
    protected ModelSet resourceSet;
    protected DoSaveEvent lifeCycleEvent;
    private ContentChangedListener contentChangedListener;
    private IUndoContext undoContext;
    private CopyOnWriteArrayList<IEditorReloadListener> reloadListeners = new CopyOnWriteArrayList();
    private final AtomicReference<DeferredReload> pendingReload = new AtomicReference();
    private boolean needsRefresh;

    public CoreMultiDiagramEditor() {
        this.addSelfReloadListener();
    }

    protected ContentOutlineRegistry getContentOutlineRegistry() {
        if (this.contentOutlineRegistry == null) {
            this.createContentOutlineRegistry();
        }
        return this.contentOutlineRegistry;
    }

    private void createContentOutlineRegistry() {
        this.contentOutlineRegistry = new ContentOutlineRegistry(this, "org.eclipse.papyrus.infra.core");
    }

    @Override
    public ServicesRegistry getServicesRegistry() {
        if (this.servicesRegistry == null) {
            this.servicesRegistry = this.createServicesRegistry();
        }
        return this.servicesRegistry;
    }

    private ServicesRegistry createServicesRegistry() {
        try {
            ExtensionServicesRegistry servicesRegistry = new ExtensionServicesRegistry("org.eclipse.papyrus.infra.core");
            return servicesRegistry;
        }
        catch (ServiceException e) {
            Activator.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected ISashWindowsContentProvider createPageProvider() {
        throw new UnsupportedOperationException("Not implemented. Should not be called as the ContentProvider is already initialized.");
    }

    protected IPageManager getIPageManager() throws IllegalStateException {
        try {
            return this.sashModelMngr.getIPageManager();
        }
        catch (Exception e) {
            throw new IllegalStateException("Method should be called after CoreMultiDiagramEditor#init(IEditorSite, IEditorInput) is called");
        }
    }

    protected ActionBarContributorRegistry getActionBarContributorRegistry() {
        if (this.actionBarContributorRegistry != null) {
            return this.actionBarContributorRegistry;
        }
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof CoreComposedActionBarContributor) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + " - ActionBarContributorRegistry loaded from CoreComposedActionBarContributor.");
            return ((CoreComposedActionBarContributor)contributor).getActionBarContributorRegistry();
        }
        Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + " - create an ActionBarContributorRegistry.");
        return this.createActionBarContributorRegistry();
    }

    private ActionBarContributorRegistry createActionBarContributorRegistry() {
        return new ActionBarContributorRegistry("org.eclipse.papyrus.infra.core");
    }

    public Object getAdapter(Class adapter) {
        if (ServicesRegistry.class == adapter) {
            return this.getServicesRegistry();
        }
        if (IPageMngr.class == adapter || IPageManager.class == adapter) {
            return this.getIPageManager();
        }
        if (IPropertySheetPage.class == adapter) {
            return this.getPropertySheetPage();
        }
        if (IContentOutlinePage.class == adapter) {
            ContentOutlineRegistry outlineRegistry;
            block14: {
                outlineRegistry = this.getContentOutlineRegistry();
                if (outlineRegistry != null) break block14;
                return null;
            }
            try {
                IPapyrusContentOutlinePage contentOutline = outlineRegistry.getContentOutline();
                if (contentOutline != null) {
                    return contentOutline;
                }
            }
            catch (BackboneException backboneException) {
                // empty catch block
            }
        }
        if (EditingDomain.class == adapter || TransactionalEditingDomain.class == adapter) {
            return this.transactionalEditingDomain;
        }
        if (IUndoContext.class == adapter) {
            return this.undoContext;
        }
        if (IEditingDomainProvider.class == adapter) {
            return this;
        }
        if (adapter == ActionRegistry.class) {
            return this.gefAdaptorDelegate.getActionRegistry();
        }
        if (adapter == ISelection.class) {
            return this.getSite().getSelectionProvider().getSelection();
        }
        if (adapter == IReloadableEditor.class) {
            return this.createReloadAdapter();
        }
        return super.getAdapter(adapter);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setPartName(input.getName());
        this.initContents();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (CoreMultiDiagramEditor.this.servicesRegistry == null) {
                    return;
                }
                CoreMultiDiagramEditor.this.getLifecycleManager().firePostDisplay(CoreMultiDiagramEditor.this);
            }
        });
    }

    protected void loadModelAndServices() throws PartInitException {
        this.gefAdaptorDelegate = new MultiDiagramEditorGefDelegate();
        this.servicesRegistry = this.createServicesRegistry();
        this.servicesRegistry.add(IMultiDiagramEditor.class, 1, this);
        this.servicesRegistry.add(ActionBarContributorRegistry.class, 1, (IService)this.getActionBarContributorRegistry());
        ComposedAdapterFactory factory = null;
        try {
            TransactionalEditingDomain domain = ServiceUtils.getInstance().getTransactionalEditingDomain(this.servicesRegistry);
            if (domain instanceof AdapterFactoryEditingDomain) {
                factory = ((AdapterFactoryEditingDomain)domain).getAdapterFactory();
            }
        }
        catch (ServiceException domain) {
            // empty catch block
        }
        if (factory == null) {
            factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        }
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)factory){

            public String getText(Object object) {
                IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, IItemLabelProvider.class);
                if (object instanceof EObject && ((EObject)object).eIsProxy()) {
                    return "Proxy - " + object;
                }
                return itemLabelProvider != null ? itemLabelProvider.getText(object) : (object == null ? "" : object.toString());
            }
        };
        this.servicesRegistry.add(ILabelProvider.class, 1, labelProvider);
        EditorLifecycleManagerImpl lifecycleManager = new EditorLifecycleManagerImpl();
        this.servicesRegistry.add(EditorLifecycleManager.class, 1, (IService)lifecycleManager, ServiceStartKind.LAZY);
        IEditorInput input = this.getEditorInput();
        URI uri = input instanceof IFileEditorInput ? URI.createPlatformResourceURI((String)((IFileEditorInput)input).getFile().getFullPath().toString(), (boolean)true) : (input instanceof URIEditorInput ? ((URIEditorInput)input).getURI() : URI.createURI((String)((IURIEditorInput)input).getURI().toString()));
        try {
            ArrayList servicesToStart = new ArrayList(1);
            servicesToStart.add(ModelSet.class);
            servicesToStart.add(IMultiDiagramEditor.class);
            this.servicesRegistry.startServicesByClassKeys(servicesToStart);
            this.resourceSet = this.servicesRegistry.getService(ModelSet.class);
            this.resourceSet.loadModels(uri);
            this.servicesRegistry.startRegistry();
        }
        catch (ModelMultiException e) {
            try {
                this.servicesRegistry.startRegistry();
                this.warnUser(e);
            }
            catch (ServiceException e1) {
                Activator.log.error((Throwable)e);
            }
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        try {
            this.transactionalEditingDomain = this.servicesRegistry.getService(TransactionalEditingDomain.class);
            this.sashModelMngr = this.servicesRegistry.getService(DiSashModelManager.class);
            this.saveAndDirtyService = this.servicesRegistry.getService(ISaveAndDirtyService.class);
            this.undoContext = this.servicesRegistry.getService(IUndoContext.class);
        }
        catch (ServiceException e) {
            Activator.log.error("A required service is missing.", (Throwable)e);
            throw new PartInitException("could not initialize services", (Throwable)e);
        }
        this.editorInputChangedListener = new EditorInputChangedListener(this);
        this.saveAndDirtyService.addInputChangedListener(this.editorInputChangedListener);
        this.getLifecycleManager().firePostInit(this);
    }

    private InternalEditorLifecycleManager getLifecycleManager() {
        if (this.servicesRegistry == null) {
            return null;
        }
        try {
            return (InternalEditorLifecycleManager)((Object)this.servicesRegistry.getService(EditorLifecycleManager.class));
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
    }

    protected void loadNestedEditors() throws PartInitException {
        ISashWindowsContentProvider contentProvider = null;
        try {
            contentProvider = this.servicesRegistry.getService(ISashWindowsContentProvider.class);
        }
        catch (ServiceException ex) {
            Activator.log.error("A required service is missing.", (Throwable)ex);
            throw new PartInitException("could not initialize services", (Throwable)ex);
        }
        this.setContentProvider(contentProvider);
        if (this.contentChangedListener == null) {
            this.contentChangedListener = new ContentChangedListener();
        }
        this.sashModelMngr.getSashModelContentChangedProvider().addListener((IContentChangedListener)this.contentChangedListener);
        IEditorInput input = this.getEditorInput();
        if (input instanceof IPapyrusPageInput) {
            IPapyrusPageInput papyrusPageInput = (IPapyrusPageInput)input;
            IPageManager pageManager = this.getIPageManager();
            if (papyrusPageInput.closeOtherPages()) {
                pageManager.closeAllOpenedPages();
            }
            URI[] uRIArray = papyrusPageInput.getPages();
            int n = uRIArray.length;
            int n2 = 0;
            while (n2 < n) {
                URI pageIdentifierURI = uRIArray[n2];
                EObject pageIdentifier = this.resourceSet.getEObject(pageIdentifierURI, true);
                if (!pageManager.allPages().contains(pageIdentifier)) {
                    Activator.log.warn("The object " + pageIdentifier + " does not reference an existing page");
                } else if (pageManager.isOpen((Object)pageIdentifier)) {
                    pageManager.selectPage((Object)pageIdentifier);
                } else {
                    pageManager.openPage((Object)pageIdentifier);
                }
                ++n2;
            }
        }
    }

    protected void warnUser(ModelMultiException e) {
        Activator.log.error((Throwable)e);
        MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)String.format("Your model is corrupted, invalid links have been found :\n%sIt is recommended to fix it before editing it", e.getMessage()));
    }

    protected void activate() {
        super.activate();
        this.initFolderTabMenus();
        try {
            this.getServicesRegistry().add(ISashWindowsContainer.class, 1, this.getISashWindowsContainer());
            this.getServicesRegistry().startServicesByClassKeys(ISashWindowsContainer.class);
            this.sashModelMngr.setCurrentFolderAndPageMngr(this.getISashWindowsContainer());
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void initFolderTabMenus() {
        ISashWindowsContainer container = this.getISashWindowsContainer();
        MenuManager menuManager = new MenuManager("tabmenu");
        menuManager.add((IContributionItem)new Separator("tabcommands"));
        menuManager.add((IContributionItem)new Separator("additions"));
        container.setFolderTabMenuManager(menuManager);
        this.getSite().registerContextMenu("org.eclipse.papyrus.infra.core.editor.ui.tabmenu", menuManager, this.getSite().getSelectionProvider());
    }

    public IPropertySheetPage getPropertySheetPage() {
        MultiDiagramPropertySheetPage propertiesPage = new MultiDiagramPropertySheetPage(this);
        this.propertiesPages.add((IPropertySheetPage)propertiesPage);
        return propertiesPage;
    }

    public void dispose() {
        for (IPropertySheetPage propertiesPage : this.propertiesPages) {
            propertiesPage.dispose();
        }
        this.propertiesPages.clear();
        this.contentOutlineRegistry = null;
        super.dispose();
    }

    private IReloadableEditor createReloadAdapter() {
        return new IReloadableEditor(){

            @Override
            public void reloadEditor(Collection<? extends Resource> triggeringResources, IReloadableEditor.ReloadReason reason, IReloadableEditor.DirtyPolicy dirtyPolicy) throws CoreException {
                CoreMultiDiagramEditor.this.pendingReload.set(new DeferredReload(triggeringResources, reason, dirtyPolicy));
                IWorkbenchPage page = CoreMultiDiagramEditor.this.getSite().getPage();
                if (page.getActiveEditor() == CoreMultiDiagramEditor.this || dirtyPolicy != IReloadableEditor.DirtyPolicy.PROMPT_TO_SAVE) {
                    ((DeferredReload)CoreMultiDiagramEditor.this.pendingReload.get()).reload();
                }
            }

            @Override
            public void addEditorReloadListener(IEditorReloadListener listener) {
                CoreMultiDiagramEditor.this.reloadListeners.addIfAbsent(listener);
            }

            @Override
            public void removeEditorReloadListener(IEditorReloadListener listener) {
                CoreMultiDiagramEditor.this.reloadListeners.remove(listener);
            }
        };
    }

    private void addSelfReloadListener() {
        this.createReloadAdapter().addEditorReloadListener(new IEditorReloadListener(){

            @Override
            public void editorAboutToReload(EditorReloadEvent event) {
                event.putContext(new MultiDiagramEditorSelectionContext(event.getEditor()));
            }

            @Override
            public void editorReloaded(EditorReloadEvent event) {
                ((MultiDiagramEditorSelectionContext)event.getContext()).restore(event.getEditor());
            }
        });
    }

    protected void deactivate() {
        this.getLifecycleManager().fireBeforeClose(this);
        if (this.sashModelMngr != null) {
            this.sashModelMngr.getSashModelContentChangedProvider().removeListener((IContentChangedListener)this.contentChangedListener);
        }
        super.deactivate();
        if (this.servicesRegistry != null) {
            try {
                this.servicesRegistry.disposeRegistry();
                this.servicesRegistry = null;
            }
            catch (ServiceMultiException e) {
                Activator.log.error((Throwable)e);
            }
        }
        if (this.contentChangedListener != null) {
            this.contentChangedListener = null;
        }
        if (this.editorInputChangedListener != null) {
            this.editorInputChangedListener.dispose();
            this.editorInputChangedListener = null;
        }
        if (this.gefAdaptorDelegate != null) {
            this.gefAdaptorDelegate.dispose();
            this.gefAdaptorDelegate = null;
        }
        this.transactionalEditingDomain = null;
        this.resourceSet = null;
        this.undoContext = null;
        this.saveAndDirtyService = null;
        this.sashModelMngr = null;
    }

    void initContents() throws PartInitException {
        this.loadModelAndServices();
        this.loadNestedEditors();
    }

    public void setFocus() {
        super.setFocus();
        DeferredReload reload = this.pendingReload.get();
        if (reload != null) {
            reload.reload();
        }
    }

    private void doReload() throws CoreException {
        IWorkbenchPage page = this.getSite().getPage();
        IWorkbenchPart activePart = page.getActivePart();
        IEditorPart activeEditor = page.getActiveEditor();
        ImmutableList listeners = ImmutableList.copyOf(this.reloadListeners);
        EditorReloadEvent event = new EditorReloadEvent(this);
        try {
            event.dispatchEditorAboutToReload((Iterable<? extends IEditorReloadListener>)listeners);
            this.deactivate();
            this.initContents();
            this.activate();
            event.dispatchEditorReloaded((Iterable<? extends IEditorReloadListener>)listeners);
        }
        finally {
            event.dispose();
            if (activeEditor != null && page.isPartVisible((IWorkbenchPart)activeEditor)) {
                page.activate((IWorkbenchPart)activeEditor);
            }
            if (activePart != null && activePart != activeEditor && page.isPartVisible(activePart)) {
                page.activate(activePart);
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.saveAndDirtyService.doSave(monitor);
    }

    public boolean isDirty() {
        if (this.saveAndDirtyService == null) {
            return false;
        }
        return this.saveAndDirtyService.isDirty();
    }

    public void doSaveAs() {
        this.saveAndDirtyService.doSaveAs();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public String getContributorId() {
        return "TreeOutlinePage";
    }

    public EditingDomain getEditingDomain() {
        return this.transactionalEditingDomain;
    }

    @Override
    @Deprecated
    public void setEditorInput(IEditorInput newInput) {
        this.setInputWithNotify(newInput);
        this.setPartName(newInput.getName());
    }

    @Deprecated
    public void gotoMarker(IMarker marker) {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchPage page = wb.getActiveWorkbenchWindow().getActivePage();
        boolean first = true;
        IViewReference[] iViewReferenceArray = page.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference view = iViewReferenceArray[n2];
            IWorkbenchPart part = view.getPart(false);
            if (part instanceof IGotoMarker) {
                if (first) {
                    page.activate(view.getPart(false));
                    first = false;
                }
                ((IGotoMarker)part).gotoMarker(marker);
            }
            ++n2;
        }
    }

    protected void scheduleRefresh() {
        this.needsRefresh = true;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CoreMultiDiagramEditor.this.refreshTabs();
            }
        });
    }

    protected void refreshTabs() {
        if (!this.needsRefresh) {
            return;
        }
        this.needsRefresh = false;
        super.refreshTabs();
    }

    @Override
    public synchronized IEditorPart getActiveEditor() {
        this.refreshTabs();
        return super.getActiveEditor();
    }

    private class ContentChangedListener
    implements IContentChangedListener {
        private ContentChangedListener() {
        }

        public void contentChanged(IContentChangedListener.ContentEvent event) {
            CoreMultiDiagramEditor.this.scheduleRefresh();
        }
    }

    private final class DeferredReload
    extends IReloadableEditor.Adapter {
        private final Collection<? extends Resource> triggeringResources;
        private final IReloadableEditor.ReloadReason reason;
        private final IReloadableEditor.DirtyPolicy dirtyPolicy;

        DeferredReload(Collection<? extends Resource> triggeringResources, IReloadableEditor.ReloadReason reason, IReloadableEditor.DirtyPolicy dirtyPolicy) {
            super(CoreMultiDiagramEditor.this);
            this.triggeringResources = ImmutableSet.copyOf(triggeringResources);
            this.reason = reason;
            this.dirtyPolicy = dirtyPolicy;
        }

        void reload() {
            try {
                this.reloadEditor(this.triggeringResources, this.reason, this.dirtyPolicy);
            }
            catch (CoreException e) {
                CoreMultiDiagramEditor.this.getSite().getPage().closeEditor((IEditorPart)CoreMultiDiagramEditor.this, false);
                StatusManager.getManager().handle(e.getStatus(), 3);
            }
        }

        @Override
        public void reloadEditor(Collection<? extends Resource> triggeringResources, IReloadableEditor.ReloadReason reason, IReloadableEditor.DirtyPolicy dirtyPolicy) throws CoreException {
            if (!CoreMultiDiagramEditor.this.pendingReload.compareAndSet(this, null)) {
                return;
            }
            IReloadableEditor.DirtyPolicy action = dirtyPolicy.resolve(CoreMultiDiagramEditor.this, triggeringResources, reason);
            if (action == IReloadableEditor.DirtyPolicy.SAVE && CoreMultiDiagramEditor.this.isDirty()) {
                CoreMultiDiagramEditor.this.doSave((IProgressMonitor)new NullProgressMonitor());
            }
            switch (action) {
                case SAVE: 
                case DO_NOT_SAVE: {
                    if (reason.shouldReload(triggeringResources)) {
                        CoreMultiDiagramEditor.this.doReload();
                        break;
                    }
                    CoreMultiDiagramEditor.this.getSite().getPage().closeEditor((IEditorPart)CoreMultiDiagramEditor.this, false);
                    break;
                }
                case IGNORE: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid resolution of editor re-load dirty policy: " + (Object)((Object)action));
                }
            }
        }
    }

    private static class EditorInputChangedListener
    implements IEditorInputChangedListener {
        private CoreMultiDiagramEditor editor;

        public EditorInputChangedListener(CoreMultiDiagramEditor editor) {
            this.editor = editor;
        }

        @Override
        public void editorInputChanged(FileEditorInput fileEditorInput) {
            this.editor.setInputWithNotify((IEditorInput)fileEditorInput);
            this.editor.setPartName(fileEditorInput.getName());
        }

        @Override
        public void isDirtyChanged() {
            this.editor.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (EditorInputChangedListener.this.editor == null) {
                        return;
                    }
                    EditorInputChangedListener.this.editor.firePropertyChange(257);
                }
            });
        }

        public void dispose() {
            this.editor = null;
        }
    }
}

