/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.editor;

import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.papyrus.infra.core.editor.CoreMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.editor.IReloadableEditor;
import org.eclipse.papyrus.infra.core.editor.reload.EditorReloadEvent;
import org.eclipse.papyrus.infra.core.editor.reload.IEditorReloadListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.properties.PropertyShowInContext;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

class MultiDiagramPropertySheetPage
extends TabbedPropertySheetPage
implements IEditorReloadListener {
    private final CoreMultiDiagramEditor multiDiagramEditor;

    public MultiDiagramPropertySheetPage(CoreMultiDiagramEditor editor) {
        super((ITabbedPropertySheetPageContributor)editor);
        this.multiDiagramEditor = editor;
        IReloadableEditor.Adapter.getAdapter(editor).addEditorReloadListener(this);
    }

    public void dispose() {
        IReloadableEditor.Adapter.getAdapter(this.multiDiagramEditor).removeEditorReloadListener(this);
        super.dispose();
    }

    @Override
    public void editorAboutToReload(EditorReloadEvent event) {
        IWorkbenchPart inputPart;
        ShowInContext context;
        Object propertySheet = this.getSite().getService(IViewPart.class);
        if (propertySheet instanceof IShowInSource && (context = ((IShowInSource)propertySheet).getShowInContext()) instanceof PropertyShowInContext && (inputPart = ((PropertyShowInContext)context).getPart()) != null) {
            event.putContext(inputPart);
        }
    }

    @Override
    public void editorReloaded(EditorReloadEvent event) {
        Object propertySheet;
        final IWorkbenchPart inputPart = (IWorkbenchPart)event.getContext();
        if (inputPart != null && (propertySheet = this.getSite().getService(IViewPart.class)) instanceof IPartListener) {
            ((IPartListener)propertySheet).partActivated(inputPart);
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ISelectionProvider selectionProvider = inputPart.getSite().getSelectionProvider();
                    if (selectionProvider != null) {
                        ((ISelectionListener)propertySheet).selectionChanged(inputPart, selectionProvider.getSelection());
                    }
                }
            });
        }
    }
}

