/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.resource.AbstractModel;
import org.eclipse.papyrus.infra.core.resource.IEMFModel;
import org.eclipse.papyrus.infra.core.resource.IVersionableModel;

public abstract class AbstractBaseModel
extends AbstractModel
implements IVersionableModel,
IEMFModel {
    protected Resource resource;
    protected URI resourceURI;

    @Override
    public Resource getResource() {
        return this.resource;
    }

    public URI getResourceURI() {
        return this.resourceURI;
    }

    protected abstract String getModelFileExtension();

    protected boolean resourceIsSet() {
        return this.resource != null;
    }

    @Override
    @Deprecated
    public void createModel(IPath fullPath) {
        this.createModel(this.getPlatformURI(fullPath));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void createModel(URI uri) {
        this.resourceURI = uri.appendFileExtension(this.getModelFileExtension());
        modelSet = this.getModelManager();
        this.resource = modelSet.getResource(this.resourceURI, false);
        if (this.resource != null) {
            try {
                modelSet.getResource(this.resourceURI, true);
            }
            catch (RuntimeException e) {
                attributes = modelSet.getURIConverter().getAttributes(this.resourceURI, Collections.singletonMap("requestedAttributes", Collections.singleton("length")));
                length = (Number)attributes.get("length");
                if (length == null || length.longValue() <= 0L) ** GOTO lbl15
                throw e;
            }
        } else {
            this.resource = this.getModelManager().createResource(this.resourceURI);
        }
lbl15:
        // 3 sources

        this.configureResource(this.resource);
    }

    protected void configureResource(Resource resource) {
        if (resource instanceof XMIResource) {
            ((XMIResource)resource).getDefaultSaveOptions().putAll(this.getSaveOptions());
            ((XMIResource)resource).setEncoding("UTF-8");
        }
    }

    protected URI getPlatformURI(IPath path) {
        return URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
    }

    public void loadModel(IFile file) {
        this.loadModel(file.getFullPath().removeFileExtension());
    }

    @Override
    @Deprecated
    public void loadModel(IPath fullPathWithoutExtension) {
        this.loadModel(this.getPlatformURI(fullPathWithoutExtension));
    }

    @Override
    public void loadModel(URI uriWithoutExtension) {
        this.resourceURI = uriWithoutExtension.appendFileExtension(this.getModelFileExtension());
        this.resource = this.modelSet.getResource(this.resourceURI, true);
        this.configureResource(this.resource);
        this.snippets.performStart(this);
    }

    protected boolean exists(URI uriWithoutExtension) {
        return this.modelSet.getURIConverter().exists(uriWithoutExtension.appendFileExtension(this.getModelFileExtension()), null);
    }

    @Override
    @Deprecated
    public void importModel(IPath fullPathWithoutExtension) {
        this.loadModel(fullPathWithoutExtension);
    }

    @Override
    public void importModel(URI uriWithoutExtension) {
        this.loadModel(uriWithoutExtension);
    }

    @Override
    public void saveModel() throws IOException {
        if (this.getModelManager().shouldSave(this.resource)) {
            this.resource.save(null);
        }
    }

    @Override
    @Deprecated
    public void changeModelPath(IPath fullPath) {
        this.setModelURI(this.getPlatformURI(fullPath));
    }

    @Override
    public void setModelURI(URI uriWithoutExtension) {
        this.resourceURI = uriWithoutExtension.appendFileExtension(this.getModelFileExtension());
        this.resource.setURI(this.resourceURI);
    }

    @Override
    public void unload() {
        this.snippets.performDispose(this);
        if (this.resource != null) {
            this.resource.unload();
            this.resource = null;
        }
        super.unload();
    }

    protected Map<Object, Object> getSaveOptions() {
        HashMap<Object, Object> saveOptions = new HashMap<Object, Object>();
        saveOptions.put("DECLARE_XML", Boolean.TRUE);
        saveOptions.put("PROCESS_DANGLING_HREF", "DISCARD");
        saveOptions.put("SCHEMA_LOCATION", Boolean.TRUE);
        saveOptions.put("USE_XMI_TYPE", Boolean.TRUE);
        saveOptions.put("SAVE_TYPE_INFORMATION", Boolean.TRUE);
        saveOptions.put("SKIP_ESCAPE_URI", Boolean.FALSE);
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("URI_HANDLER", new URIHandlerImpl.PlatformSchemeAware());
        return saveOptions;
    }

    @Override
    public void saveCopy(IPath targetPathWithoutExtension, Map<Object, Object> targetMap) {
        HashMap<String, SaveCopyURIHandlerImp> saveOptions = new HashMap<String, SaveCopyURIHandlerImp>();
        URI targetURI = this.getTargetURI(targetPathWithoutExtension);
        saveOptions.put("URI_HANDLER", new SaveCopyURIHandlerImp(targetMap, targetURI));
        try {
            OutputStream outputStream = this.modelSet.getURIConverter().createOutputStream(targetURI);
            this.resource.save(outputStream, saveOptions);
        }
        catch (IOException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    @Override
    public void fillTargetMap(IPath targetPathWithoutExtension, Map<Object, Object> targetMap) {
        targetMap.put(this.getResourceURI(), this.getTargetURI(targetPathWithoutExtension));
    }

    protected URI getTargetURI(IPath targetPathWithoutExtension) {
        String resourceSegment = this.resourceURI.lastSegment();
        int index = resourceSegment.lastIndexOf(".");
        if (index > -1) {
            String extension = resourceSegment.substring(index + 1);
            IPath targetPath = targetPathWithoutExtension.addFileExtension(extension);
            URI targetURI = targetPath.getDevice() == null ? URI.createPlatformResourceURI((String)targetPath.toOSString(), (boolean)true) : URI.createFileURI((String)targetPath.toString());
            return targetURI;
        }
        return null;
    }

    public URI getURI() {
        return this.resource.getURI();
    }

    @Override
    public Set<URI> getModifiedURIs() {
        if (this.getResource() != null && (!this.getResource().isTrackingModification() || this.getResource().isModified())) {
            return Collections.singleton(this.getResource().getURI());
        }
        return Collections.emptySet();
    }

    @Override
    public void handle(Resource resource) {
    }

    @Override
    public boolean isModelFor(Object element) {
        return element != null && element == this.resource;
    }

    @Override
    public boolean isControlled(Resource resource) {
        boolean isControlled;
        if (resource == this.resource || resource == null) {
            return false;
        }
        if (resource.getContents().isEmpty()) {
            return false;
        }
        EObject rootElement = (EObject)resource.getContents().get(0);
        boolean bl = isControlled = rootElement.eContainer() != null;
        if (isControlled) {
            Resource parentResource = rootElement.eContainer().eResource();
            boolean isChildOfMainResource = parentResource == this.resource || this.isControlled(parentResource);
            return isChildOfMainResource;
        }
        return false;
    }

    protected class SaveCopyURIHandlerImp
    extends URIHandlerImpl.PlatformSchemeAware {
        private Map<Object, Object> targetMap;
        private URI targetURI;

        public SaveCopyURIHandlerImp(Map<Object, Object> targetMap, URI targetURI) {
            this.targetMap = targetMap;
            this.targetURI = targetURI;
        }

        public void setBaseURI(URI baseURI) {
            super.setBaseURI(this.targetURI);
        }

        public URI deresolve(URI uri) {
            Object target;
            URI resourceURI = uri.trimFragment();
            if (!AbstractBaseModel.this.resourceURI.equals(resourceURI) && this.targetMap.containsKey(resourceURI) && (target = this.targetMap.get(resourceURI)) instanceof URI) {
                URI targetURI = (URI)target;
                if (uri.fragment() != null) {
                    targetURI = targetURI.appendFragment(uri.fragment());
                }
                return targetURI;
            }
            return super.deresolve(uri);
        }
    }
}

