/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import java.io.IOException;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.resource.AbstractBaseModel;

public abstract class AbstractDynamicModel<T extends EObject>
extends AbstractBaseModel {
    @Override
    public void loadModel(IPath fullPathWithoutExtension) {
        try {
            super.loadModel(fullPathWithoutExtension);
            return;
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof ResourceException)) {
                throw e;
            }
            this.createModel(fullPathWithoutExtension);
            this.snippets.performStart(this);
            return;
        }
    }

    @Override
    public void saveModel() throws IOException {
        if (this.getResource().getContents().size() <= 0) {
            return;
        }
        super.saveModel();
    }

    public void addModelRoot(T root) {
        this.getResource().getContents().add(root);
    }
}

