/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import com.google.common.base.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler;
import org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler2;
import org.eclipse.papyrus.infra.core.resource.IReadOnlyListener;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyEvent;

public abstract class AbstractReadOnlyHandler
implements IReadOnlyHandler2 {
    private EditingDomain editingDomain;
    private CopyOnWriteArrayList<IReadOnlyListener> listeners = new CopyOnWriteArrayList();

    public AbstractReadOnlyHandler(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public static IReadOnlyHandler2 adapt(IReadOnlyHandler handler, EditingDomain domain) {
        return new Adapter(handler, domain);
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    @Override
    @Deprecated
    public Optional<Boolean> anyReadOnly(URI[] uris) {
        return this.anyReadOnly(ReadOnlyAxis.permissionAxes(), uris);
    }

    @Override
    @Deprecated
    public Optional<Boolean> isReadOnly(EObject eObject) {
        return this.isReadOnly(ReadOnlyAxis.permissionAxes(), eObject);
    }

    @Override
    public Optional<Boolean> isReadOnly(Set<ReadOnlyAxis> axes, EObject eObject) {
        Resource res = eObject.eResource();
        if (res != null && res.getURI() != null) {
            return this.anyReadOnly(axes, new URI[]{res.getURI()});
        }
        return Optional.absent();
    }

    @Override
    @Deprecated
    public Optional<Boolean> makeWritable(URI[] uris) {
        return this.makeWritable(ReadOnlyAxis.permissionAxes(), uris);
    }

    @Override
    @Deprecated
    public Optional<Boolean> makeWritable(EObject eObject) {
        return this.makeWritable(ReadOnlyAxis.permissionAxes(), eObject);
    }

    @Override
    public Optional<Boolean> makeWritable(Set<ReadOnlyAxis> axes, EObject eObject) {
        Resource res = eObject.eResource();
        if (res != null && res.getURI() != null) {
            return this.makeWritable(axes, new URI[]{res.getURI()});
        }
        return Optional.absent();
    }

    @Override
    public Optional<Boolean> canMakeWritable(Set<ReadOnlyAxis> axes, URI[] uris) {
        return Optional.absent();
    }

    @Override
    public Optional<Boolean> canMakeWritable(Set<ReadOnlyAxis> axes, EObject object) {
        Resource res = object.eResource();
        if (res != null && res.getURI() != null) {
            return this.canMakeWritable(axes, new URI[]{res.getURI()});
        }
        return Optional.absent();
    }

    @Override
    public void addReadOnlyListener(IReadOnlyListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    @Override
    public void removeReadOnlyListener(IReadOnlyListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireReadOnlyStateChanged(ReadOnlyAxis axis, URI resourceURI, boolean readOnly) {
        if (!this.listeners.isEmpty()) {
            ReadOnlyEvent event = new ReadOnlyEvent((IReadOnlyHandler2)this, axis, resourceURI, readOnly);
            for (IReadOnlyListener next : this.listeners) {
                try {
                    next.readOnlyStateChanged(event);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in read-only state change listener.", (Throwable)e);
                }
            }
        }
    }

    protected void fireReadOnlyStateChanged(ReadOnlyAxis axis, EObject object, boolean readOnly) {
        if (!this.listeners.isEmpty()) {
            ReadOnlyEvent event = new ReadOnlyEvent((IReadOnlyHandler2)this, axis, object, readOnly);
            for (IReadOnlyListener next : this.listeners) {
                try {
                    next.readOnlyStateChanged(event);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in read-only state change listener.", (Throwable)e);
                }
            }
        }
    }

    private static class Adapter
    extends AbstractReadOnlyHandler {
        private final IReadOnlyHandler delegate;

        Adapter(IReadOnlyHandler handler, EditingDomain editingDomain) {
            super(editingDomain);
            this.delegate = handler;
        }

        @Override
        public Optional<Boolean> anyReadOnly(Set<ReadOnlyAxis> axes, URI[] uris) {
            return !axes.contains((Object)ReadOnlyAxis.PERMISSION) ? Optional.absent() : this.delegate.anyReadOnly(uris);
        }

        @Override
        public Optional<Boolean> isReadOnly(Set<ReadOnlyAxis> axes, EObject eObject) {
            return !axes.contains((Object)ReadOnlyAxis.PERMISSION) ? Optional.absent() : this.delegate.isReadOnly(eObject);
        }

        @Override
        public Optional<Boolean> makeWritable(Set<ReadOnlyAxis> axes, URI[] uris) {
            Optional<Boolean> result;
            Optional<Boolean> optional = result = !axes.contains((Object)ReadOnlyAxis.PERMISSION) ? Optional.absent() : this.delegate.makeWritable(uris);
            if (((Boolean)result.or((Object)false)).booleanValue()) {
                URI[] uRIArray = uris;
                int n = uris.length;
                int n2 = 0;
                while (n2 < n) {
                    URI next = uRIArray[n2];
                    this.fireReadOnlyStateChanged(ReadOnlyAxis.PERMISSION, next, true);
                    ++n2;
                }
            }
            return result;
        }

        @Override
        public Optional<Boolean> makeWritable(Set<ReadOnlyAxis> axes, EObject eObject) {
            Optional<Boolean> result;
            Optional<Boolean> optional = result = !axes.contains((Object)ReadOnlyAxis.PERMISSION) ? Optional.absent() : this.delegate.makeWritable(eObject);
            if (((Boolean)result.or((Object)false)).booleanValue()) {
                this.fireReadOnlyStateChanged(ReadOnlyAxis.PERMISSION, eObject, true);
            }
            return result;
        }
    }
}

