/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public abstract class ResourceAdapter
extends AdapterImpl {
    public void setTarget(Notifier newTarget) {
        if (newTarget instanceof ResourceSet) {
            super.setTarget(newTarget);
        }
    }

    protected ResourceSet getResourceSet() {
        return (ResourceSet)this.getTarget();
    }

    public void notifyChanged(Notification msg) {
        Object notifier = msg.getNotifier();
        if (!msg.isTouch()) {
            if (notifier instanceof ResourceSet) {
                if (msg.getFeatureID(ResourceSet.class) == 0) {
                    this.handleResourceSetResources(msg);
                }
            } else if (notifier instanceof Resource) {
                switch (msg.getFeatureID(Resource.class)) {
                    case 4: {
                        switch (msg.getEventType()) {
                            case 1: 
                            case 2: {
                                if (msg.getNewBooleanValue()) {
                                    this.handleResourceLoaded((Resource)notifier);
                                    break;
                                }
                                this.handleResourceUnloaded((Resource)notifier);
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (msg.getEventType()) {
                            case 1: 
                            case 2: {
                                this.handleResourceURI((Resource)notifier, (URI)msg.getOldValue(), (URI)msg.getNewValue());
                            }
                        }
                        break;
                    }
                    case 2: {
                        this.handleResourceContents(msg);
                    }
                }
            }
        }
    }

    protected void addAdapter(Notifier notifier) {
        EList adapters = notifier.eAdapters();
        if (!adapters.contains((Object)this)) {
            adapters.add((Object)this);
        }
    }

    protected void removeAdapter(Notifier notifier) {
        notifier.eAdapters().remove((Object)this);
    }

    protected void handleResourceSetResources(Notification msg) {
        switch (msg.getEventType()) {
            case 3: {
                Resource resource = (Resource)msg.getNewValue();
                this.addAdapter((Notifier)resource);
                this.handleResourceAdded(resource);
                break;
            }
            case 5: {
                for (Object next : (Iterable)msg.getNewValue()) {
                    Resource resource = (Resource)next;
                    this.addAdapter((Notifier)resource);
                    this.handleResourceAdded(resource);
                }
                break;
            }
            case 4: {
                Resource resource = (Resource)msg.getOldValue();
                try {
                    this.handleResourceRemoved(resource);
                    break;
                }
                finally {
                    this.removeAdapter((Notifier)resource);
                }
            }
            case 6: {
                for (Object next : (Iterable)msg.getOldValue()) {
                    Resource resource = (Resource)next;
                    try {
                        this.handleResourceRemoved(resource);
                    }
                    finally {
                        this.removeAdapter((Notifier)resource);
                    }
                }
                break;
            }
            case 1: {
                Resource oldResource = (Resource)msg.getOldValue();
                try {
                    this.handleResourceRemoved(oldResource);
                }
                finally {
                    this.removeAdapter((Notifier)oldResource);
                }
                Resource newResource = (Resource)msg.getOldValue();
                this.addAdapter((Notifier)newResource);
                this.handleResourceAdded(newResource);
            }
        }
    }

    protected void handleResourceContents(Notification msg) {
        Resource.Internal resource = (Resource.Internal)msg.getNotifier();
        if (resource.isLoaded() && !resource.isLoading()) {
            switch (msg.getEventType()) {
                case 3: {
                    this.handleRootAdded((Resource)resource, (EObject)msg.getNewValue());
                    break;
                }
                case 5: {
                    for (Object next : (Iterable)msg.getNewValue()) {
                        this.handleRootAdded((Resource)resource, (EObject)next);
                    }
                    break;
                }
                case 4: {
                    this.handleRootRemoved((Resource)resource, (EObject)msg.getOldValue());
                    break;
                }
                case 6: {
                    for (Object next : (Iterable)msg.getOldValue()) {
                        this.handleRootRemoved((Resource)resource, (EObject)next);
                    }
                    break;
                }
                case 1: {
                    this.handleRootRemoved((Resource)resource, (EObject)msg.getOldValue());
                    this.handleRootAdded((Resource)resource, (EObject)msg.getNewValue());
                }
            }
        }
    }

    protected void handleResourceAdded(Resource resource) {
    }

    protected void handleResourceRemoved(Resource resource) {
    }

    protected void handleResourceLoaded(Resource resource) {
    }

    protected void handleResourceUnloaded(Resource resource) {
    }

    protected void handleResourceURI(Resource resource, URI oldURI, URI newURI) {
    }

    protected void handleRootAdded(Resource resource, EObject root) {
    }

    protected void handleRootRemoved(Resource resource, EObject root) {
    }
}

