/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.readonly;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionChangeRecorder;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler2;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;
import org.eclipse.papyrus.infra.core.resource.ResourceAdapter;
import org.eclipse.papyrus.infra.core.resource.RollbackStatus;
import org.eclipse.papyrus.infra.core.utils.TransactionHelper;
import org.eclipse.papyrus.infra.emf.readonly.ControlledResourceTracker;
import org.eclipse.papyrus.infra.emf.readonly.ReadOnlyManager;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.infra.onefile.model.PapyrusModelHelper;
import org.eclipse.papyrus.infra.onefile.utils.OneFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusROTransactionalEditingDomain
extends TransactionalEditingDomainImpl {
    public PapyrusROTransactionalEditingDomain(AdapterFactory adapterFactory, TransactionalCommandStack stack, ResourceSet resourceSet) {
        super(adapterFactory, stack, resourceSet);
        if (stack instanceof IWorkspaceCommandStack) {
            resourceSet.eAdapters().add((Object)this.createResourceUndoContextHandler());
        }
    }

    public boolean isReadOnly(Resource resource) {
        return this.isReadOnly((Set<ReadOnlyAxis>)ReadOnlyAxis.anyAxis(), resource);
    }

    public boolean isReadOnly(EObject eObject) {
        return this.isReadOnly((Set<ReadOnlyAxis>)ReadOnlyAxis.anyAxis(), eObject);
    }

    protected TransactionChangeRecorder createChangeRecorder(ResourceSet rset) {
        ControlledResourceTracker.getInstance((EditingDomain)this);
        return this.doCreateChangeRecorder(rset);
    }

    protected TransactionChangeRecorder doCreateChangeRecorder(ResourceSet rset) {
        return new TransactionChangeRecorder((InternalTransactionalEditingDomain)this, rset){

            protected void appendNotification(Notification notification) {
                super.appendNotification(notification);
                if (!NotificationFilter.READ.matches(notification)) {
                    PapyrusROTransactionalEditingDomain.this.assertNotReadOnly(notification.getNotifier());
                } else {
                    PapyrusROTransactionalEditingDomain.this.handleCrossResourceContainmentProxy(notification);
                }
            }
        };
    }

    protected void handleCrossResourceContainmentProxy(Notification notification) {
        InternalEObject newValue;
        EReference reference;
        if (notification.getEventType() == 9 && (reference = (EReference)notification.getFeature()).isContainment() && (newValue = (InternalEObject)notification.getNewValue()).eDirectResource() != null) {
            ControlledResourceTracker.getInstance((EditingDomain)this).handleCrossResourceContainment(newValue);
        }
    }

    protected void assertNotReadOnly(Object object) {
        InternalTransaction tx = this.getActiveTransaction();
        if (!(tx == null || tx.isRollingBack() || Boolean.TRUE.equals(tx.getOptions().get("unprotected")) || this.willRollBack((Transaction)tx))) {
            boolean readOnly;
            Set axes = TransactionHelper.getReadOnlyAxisOption((Transaction)tx);
            if (object instanceof Resource) {
                Resource.Internal resource = (Resource.Internal)object;
                if (resource.isLoading()) {
                    return;
                }
                readOnly = this.isReadOnly((Set<ReadOnlyAxis>)axes, (Resource)resource) && (!TransactionHelper.isInteractive((Transaction)tx) || !this.makeWritable((Set<ReadOnlyAxis>)axes, (Resource)resource));
            } else {
                EObject eObject;
                readOnly = object instanceof EObject ? this.isReadOnly((Set<ReadOnlyAxis>)axes, eObject = (EObject)object) && (!TransactionHelper.isInteractive((Transaction)tx) || !this.makeWritable((Set<ReadOnlyAxis>)axes, eObject)) : false;
            }
            if (readOnly) {
                String message = "Attempt to modify object(s) in a read-only model.";
                Set<Object> offenders = Collections.singleton(object);
                tx.abort((IStatus)new RollbackStatus("org.eclipse.papyrus.infra.emf.readonly", 2, message, offenders));
            }
        }
    }

    private boolean willRollBack(Transaction tx) {
        IStatus status = tx.getStatus();
        return status != null && status.getSeverity() >= 4;
    }

    protected boolean isReadOnly(Set<ReadOnlyAxis> axes, Resource resource) {
        if (resource != null && resource.getURI() != null) {
            return (Boolean)ReadOnlyManager.getReadOnlyHandler((EditingDomain)this).anyReadOnly(axes, new URI[]{resource.getURI()}).get();
        }
        return false;
    }

    protected boolean isReadOnly(Set<ReadOnlyAxis> axes, EObject eObject) {
        return (Boolean)ReadOnlyManager.getReadOnlyHandler((EditingDomain)this).isReadOnly(axes, eObject).get();
    }

    protected boolean makeWritable(Set<ReadOnlyAxis> axes, Resource resource) {
        URI[] uris = this.getCompositeModelURIs(resource.getURI());
        IReadOnlyHandler2 handler = ReadOnlyManager.getReadOnlyHandler((EditingDomain)this);
        if (!((Boolean)handler.canMakeWritable(axes, uris).or((Object)false)).booleanValue()) {
            return false;
        }
        return (Boolean)handler.makeWritable(axes, uris).get();
    }

    protected boolean makeWritable(Set<ReadOnlyAxis> axes, EObject object) {
        IReadOnlyHandler2 handler = ReadOnlyManager.getReadOnlyHandler((EditingDomain)this);
        boolean result = (Boolean)handler.canMakeWritable(axes, object).or((Object)false) == false ? false : (Boolean)handler.makeWritable(axes, object).get();
        return result;
    }

    protected URI[] getCompositeModelURIs(URI memberURI) {
        IFile file;
        URI[] result = null;
        if (memberURI.isPlatformResource() && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(memberURI.trimFragment().toPlatformString(true)))) != null && file.exists()) {
            IPapyrusFile composite = PapyrusModelHelper.getPapyrusModelFactory().createIPapyrusFile(file);
            HashSet<URI> memberURIs = new HashSet<URI>();
            IFile[] iFileArray = OneFileUtils.getAssociatedFiles((IPapyrusFile)composite);
            int n = iFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFile member = iFileArray[n2];
                memberURIs.add(URI.createPlatformResourceURI((String)member.getFullPath().toString(), (boolean)true));
                ++n2;
            }
            result = memberURIs.toArray(new URI[memberURIs.size()]);
        }
        if (result == null) {
            result = new URI[]{memberURI};
        }
        return result;
    }

    public void dispose() {
        try {
            super.dispose();
        }
        finally {
            this.resourceSet = null;
            this.adapterFactory = null;
            ReadOnlyManager.roHandlers.remove((Object)this);
        }
    }

    protected Adapter createResourceUndoContextHandler() {
        return new ResourceUndoContextHandler(this.getCommandStack());
    }

    protected class ResourceUndoContextHandler
    extends ResourceAdapter {
        private final IOperationHistory history;

        protected ResourceUndoContextHandler(CommandStack stack) {
            this.history = ((IWorkspaceCommandStack)stack).getOperationHistory();
        }

        protected void handleResourceUnloaded(Resource resource) {
            ResourceUndoContext resourceContext = new ResourceUndoContext((TransactionalEditingDomain)PapyrusROTransactionalEditingDomain.this, resource);
            this.history.dispose((IUndoContext)resourceContext, true, true, true);
        }
    }
}

