/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.resource;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.emf.resource.DependencyManagementHelper;
import org.eclipse.papyrus.infra.emf.resource.IDependencyReplacementParticipant;
import org.eclipse.papyrus.infra.emf.resource.Replacement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyManager {
    private final Collection<Resource> resources;
    private final EditingDomain editingDomain;

    public DependencyManager(Resource resource) {
        this(Collections.singletonList(resource));
    }

    public DependencyManager(Collection<Resource> resources) {
        this(resources, (EditingDomain)(resources.isEmpty() ? null : TransactionUtil.getEditingDomain((Resource)resources.iterator().next())));
    }

    public DependencyManager(ResourceSet resourceSet) {
        this((Collection<Resource>)resourceSet.getResources(), (EditingDomain)TransactionUtil.getEditingDomain((ResourceSet)resourceSet));
    }

    public DependencyManager(EditingDomain editingDomain) {
        this((Collection<Resource>)editingDomain.getResourceSet().getResources(), editingDomain);
    }

    protected DependencyManager(Collection<Resource> resources, EditingDomain editingDomain) {
        this.resources = resources;
        this.editingDomain = editingDomain;
    }

    public Collection<Replacement> updateDependencies(final URI oldURI, URI newURI, DiagnosticChain diagnostics, IProgressMonitor monitor) {
        List<? extends IDependencyReplacementParticipant> participants = this.loadParticipants(oldURI, newURI);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(participants.size() * 2 + 1));
        ImmutableList resourcesToUpdate = ImmutableList.copyOf((Iterable)Iterables.filter(this.resources, (Predicate)new Predicate<Resource>(){

            public boolean apply(Resource input) {
                return !oldURI.equals(input.getURI());
            }
        }));
        SubMonitor child = subMonitor.newChild(participants.size() + 1);
        child.beginTask("Updating references ...", -1);
        Collection<Replacement> result = DependencyManagementHelper.updateDependencies(oldURI, newURI, (Collection<Resource>)resourcesToUpdate, this.editingDomain);
        child.done();
        if (!result.isEmpty()) {
            for (IDependencyReplacementParticipant iDependencyReplacementParticipant : participants) {
                try {
                    iDependencyReplacementParticipant.postProcessReplacements(result, (Collection<? extends Resource>)resourcesToUpdate, (IProgressMonitor)subMonitor.newChild(1), diagnostics);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in dependency update participant.", (Throwable)e);
                }
            }
        }
        subMonitor.done();
        return result;
    }

    protected List<? extends IDependencyReplacementParticipant> loadParticipants(URI oldURI, URI newURI) {
        ArrayList result = Lists.newArrayList();
        EvaluationContext context = new EvaluationContext(null, this.resources);
        context.addVariable("oldURI", (Object)oldURI);
        context.addVariable("newURI", (Object)newURI);
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.emf", "dependencyUpdateParticipant");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] enablement;
            IConfigurationElement next = iConfigurationElementArray[n2];
            if ("replaceParticipant".equals(next.getName()) && ((enablement = next.getChildren("enablement")) == null || enablement.length == 0 || this.matches(enablement[0], (IEvaluationContext)context))) {
                try {
                    result.add((IDependencyReplacementParticipant)next.createExecutableExtension("class"));
                }
                catch (Exception e) {
                    Activator.log.error("Invalid replaceParticipant extension in " + next.getContributor().getName(), (Throwable)e);
                }
            }
            ++n2;
        }
        return result;
    }

    protected boolean matches(IConfigurationElement enablement, IEvaluationContext context) {
        EvaluationResult result = EvaluationResult.NOT_LOADED;
        try {
            ExpressionConverter.getDefault().perform(enablement).evaluate(context);
        }
        catch (Exception e) {
            Activator.log.error("Problem evaluating replaceParticipant enablement expression.", (Throwable)e);
        }
        return result.or(EvaluationResult.FALSE).equals(EvaluationResult.TRUE);
    }
}

