/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.extendedtypes.provider;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.papyrus.infra.extendedtypes.ActionConfiguration;
import org.eclipse.papyrus.infra.extendedtypes.Activator;
import org.eclipse.papyrus.infra.extendedtypes.ExtendedtypesPackage;
import org.eclipse.papyrus.infra.extendedtypes.IActionConfigurationModelCreation;
import org.eclipse.papyrus.infra.extendedtypes.provider.AspectSemanticTypeConfigurationItemProvider;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomAspectSemanticTypeConfigurationItemProvider
extends AspectSemanticTypeConfigurationItemProvider {
    protected Map<String, IActionConfigurationModelCreation<ActionConfiguration>> configurationToFactory = new HashMap<String, IActionConfigurationModelCreation<ActionConfiguration>>();

    public CustomAspectSemanticTypeConfigurationItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        this.addFromExtensionPoints(newChildDescriptors, object);
    }

    protected void addFromExtensionPoints(Collection<Object> newChildDescriptors, Object object) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.extendedtypes.aspectActionConfiguration");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String configurationModelCreationClassName = configurationElement.getAttribute("configurationModelCreation");
            if (configurationModelCreationClassName != null) {
                String contributorName = configurationElement.getContributor().getName();
                IActionConfigurationModelCreation<ActionConfiguration> configurationModelCreation = this.configurationToFactory.get(configurationModelCreationClassName);
                if (configurationModelCreation == null) {
                    Class<IActionConfigurationModelCreation<ActionConfiguration>> configurationClass = null;
                    try {
                        configurationClass = this.loadAspectActionConfigurationModelCreationClass(configurationModelCreationClassName, contributorName);
                    }
                    catch (ClassNotFoundException e1) {
                        Activator.log.error((Throwable)e1);
                    }
                    if (configurationClass != null) {
                        try {
                            configurationModelCreation = configurationClass.newInstance();
                            this.configurationToFactory.put(configurationModelCreationClassName, configurationModelCreation);
                        }
                        catch (InstantiationException e) {
                            Activator.log.error((Throwable)e);
                        }
                        catch (IllegalAccessException e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                }
                if (configurationModelCreation != null) {
                    newChildDescriptors.add(this.createChildParameter(ExtendedtypesPackage.eINSTANCE.getAspectSemanticTypeConfiguration_ActionConfiguration(), configurationModelCreation.createConfigurationModel()));
                }
            }
            ++n2;
        }
    }

    protected Class<IActionConfigurationModelCreation<ActionConfiguration>> loadAspectActionConfigurationModelCreationClass(String className, String bundleId) throws ClassNotFoundException {
        int state;
        Class found = null;
        Bundle bundle = CustomAspectSemanticTypeConfigurationItemProvider.basicGetBundle(bundleId);
        if (bundle != null && ((state = bundle.getState()) == 32 || state == 8)) {
            found = bundle.loadClass(className);
            return found;
        }
        return null;
    }

    private static Bundle basicGetBundle(String bundleId) {
        return Platform.getBundle((String)bundleId);
    }
}

