/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.papyrus.commands.CheckedOperationHistory;
import org.eclipse.papyrus.commands.ICreationCommand;
import org.eclipse.papyrus.commands.OpenDiagramCommand;
import org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler2;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;
import org.eclipse.papyrus.infra.core.resource.sasheditor.DiModelUtils;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.readonly.ReadOnlyManager;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.messages.Messages;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.services.edit.internal.context.TypeContext;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.viewpoints.configuration.ModelAutoCreate;
import org.eclipse.papyrus.infra.viewpoints.configuration.OwningRule;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class AbstractPapyrusGmfCreateDiagramCommandHandler
extends AbstractHandler
implements IHandler,
ICreationCommand {
    protected Resource getNotationResource(ModelSet modelSet, EObject owner, EObject element) {
        if (element == null) {
            return NotationUtils.getNotationResource(modelSet);
        }
        URI uriWithoutExtension = element.eResource().getURI().trimFileExtension();
        URI notationURI = uriWithoutExtension.appendFileExtension("notation");
        Resource notationResource = modelSet.getResource(notationURI, false);
        if (notationResource == null) {
            notationResource = modelSet.createResource(notationURI);
            if (notationResource == null) {
                modelSet.getResources().remove((Object)notationResource);
                return null;
            }
            EditingDomain editingDomain = EMFHelper.resolveEditingDomain((EObject)element);
            if (EMFHelper.isReadOnly((Resource)notationResource, (EditingDomain)editingDomain)) {
                IReadOnlyHandler2 roHandler = ReadOnlyManager.getReadOnlyHandler((EditingDomain)editingDomain);
                if (((Boolean)roHandler.canMakeWritable(ReadOnlyAxis.anyAxis(), new URI[]{notationResource.getURI()}).or((Object)false)).booleanValue()) {
                    return notationResource;
                }
                modelSet.getResources().remove((Object)notationResource);
                return null;
            }
        }
        return notationResource;
    }

    private EObject getRootElement(Resource modelResource) {
        Object root;
        EObject rootElement = null;
        if (modelResource != null && modelResource.getContents() != null && modelResource.getContents().size() > 0 && (root = modelResource.getContents().get(0)) instanceof EObject) {
            rootElement = (EObject)root;
        }
        return rootElement;
    }

    private void attachModelToResource(EObject root, Resource resource) {
        resource.getContents().add((Object)root);
    }

    private String openDiagramNameDialog(String defaultValue) {
        InputDialog inputDialog;
        int result;
        if (defaultValue == null) {
            defaultValue = "";
        }
        if ((result = (inputDialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.AbstractPapyrusGmfCreateDiagramCommandHandler_SelectNewDiagramName, Messages.AbstractPapyrusGmfCreateDiagramCommandHandler_NewDiagramName, defaultValue, null)).open()) == 0) {
            String name = inputDialog.getValue();
            if (name == null || name.length() == 0) {
                name = defaultValue;
            }
            return name;
        }
        return null;
    }

    public final Diagram createDiagram(ModelSet modelSet, EObject owner, String name) {
        ViewPrototype proto = ViewPrototype.get((String)this.getCreatedDiagramType(), (EObject)owner, (EObject)owner);
        if (proto == null) {
            return null;
        }
        return this.createDiagram(modelSet, owner, owner, proto, name);
    }

    public final Diagram createDiagram(ModelSet modelSet, EObject owner, EObject element, ViewPrototype prototype, String name) {
        ICommand createCmd = this.getCreateDiagramCommand(modelSet, owner, element, prototype, name);
        TransactionalEditingDomain dom = modelSet.getTransactionalEditingDomain();
        CompositeCommand cmd = new CompositeCommand("Create diagram");
        cmd.add((IUndoableOperation)createCmd);
        cmd.add((IUndoableOperation)new OpenDiagramCommand(dom, createCmd));
        try {
            IStatus status = CheckedOperationHistory.getInstance().execute((IUndoableOperation)cmd, (IProgressMonitor)new NullProgressMonitor(), null);
            if (status.isOK()) {
                CommandResult result = cmd.getCommandResult();
                Object returnValue = result.getReturnValue();
                if (returnValue instanceof Collection) {
                    for (Object returnElement : (Collection)returnValue) {
                        if (!(returnElement instanceof Diagram)) continue;
                        return (Diagram)returnElement;
                    }
                }
            } else if (status.getSeverity() != 8) {
                StatusManager.getManager().handle(status, 2);
            }
        }
        catch (ExecutionException ex) {
            Activator.log.error((Throwable)ex);
        }
        return null;
    }

    public final ICommand getCreateDiagramCommand(ModelSet modelSet, EObject owner, String name) {
        ViewPrototype proto = ViewPrototype.get((String)this.getCreatedDiagramType(), (EObject)owner, (EObject)owner);
        if (proto == null) {
            return null;
        }
        return this.getCreateDiagramCommand(modelSet, owner, owner, proto, name);
    }

    public final ICommand getCreateDiagramCommand(final ModelSet modelSet, final EObject owner, final EObject element, final ViewPrototype prototype, final String name) {
        Resource notationResource = NotationUtils.getNotationResource(modelSet);
        Resource diResource = DiModelUtils.getDiResource((ModelSet)modelSet);
        ArrayList<IFile> modifiedFiles = new ArrayList<IFile>();
        if (notationResource.getURI().isPlatformResource()) {
            modifiedFiles.add(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(notationResource.getURI().toPlatformString(true))));
        }
        if (diResource.getURI().isPlatformResource()) {
            modifiedFiles.add(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(diResource.getURI().toPlatformString(true))));
        }
        return new AbstractTransactionalCommand(modelSet.getTransactionalEditingDomain(), Messages.AbstractPapyrusGmfCreateDiagramCommandHandler_CreateDiagramCommandLabel, modifiedFiles){
            private Diagram diagram;
            private EObject diagramElement;
            private EObject diagramOwner;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.diagram = null;
                this.diagramElement = null;
                this.diagramOwner = null;
            }

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Creator creator = new Creator(modelSet, owner, element, prototype, name);
                try {
                    CommandResult commandResult = creator.createDiagram();
                    if (!commandResult.getStatus().isOK()) {
                        return commandResult;
                    }
                    this.diagram = (Diagram)commandResult.getReturnValue();
                    this.diagramElement = this.diagram.getElement();
                    this.diagramOwner = DiagramUtils.getOwner(this.diagram);
                    return commandResult;
                }
                catch (ServiceException e) {
                    Activator.log.error((Throwable)e);
                    return CommandResult.newErrorCommandResult((String)"Error during diagram creation");
                }
            }

            protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                IStatus status = super.doUndo(monitor, info);
                this.diagram.setElement(null);
                return status;
            }

            protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                this.diagram.setElement(this.diagramElement);
                DiagramUtils.setOwner(this.diagram, this.diagramOwner);
                IStatus status = super.doRedo(monitor, info);
                return status;
            }
        };
    }

    public String getCreatedDiagramType() {
        return this.getDiagramNotationID();
    }

    public boolean isParentReassignable() {
        return true;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        throw new UnsupportedOperationException();
    }

    protected abstract String getDiagramNotationID();

    protected abstract PreferencesHint getPreferenceHint();

    protected abstract String getDefaultDiagramName();

    protected Diagram doCreateDiagram(Resource diagramResource, EObject owner, EObject element, ViewPrototype prototype, String name) {
        Diagram diagram = ViewService.createDiagram((EObject)element, (String)this.getDiagramNotationID(), (PreferencesHint)this.getPreferenceHint());
        if (diagram != null) {
            diagram.setName(name);
            diagram.setElement(element);
            DiagramUtils.setOwner(diagram, owner);
            if (!prototype.isNatural()) {
                DiagramUtils.setPrototype(diagram, prototype);
            }
            this.initializeDiagram((EObject)diagram);
            diagramResource.getContents().add((Object)diagram);
        }
        return diagram;
    }

    protected void initializeDiagram(EObject diagram) {
    }

    private class Creator {
        private ModelSet modelSet;
        private EObject owner;
        private EObject element;
        private ViewPrototype prototype;
        private OwningRule rule;
        private String name;
        private IElementEditService service;
        private IClientContext clientContext;

        public Creator(ModelSet modelSet, EObject owner, EObject element, ViewPrototype prototype, String name) {
            this.modelSet = modelSet;
            this.owner = owner;
            this.element = element;
            this.prototype = prototype;
            this.name = name;
        }

        private CommandResult createDiagram() throws ServiceException {
            Resource modelResource = UmlUtils.getUmlResource((ModelSet)this.modelSet);
            Resource notationResource = AbstractPapyrusGmfCreateDiagramCommandHandler.this.getNotationResource(this.modelSet, this.owner, this.element);
            if (notationResource == null) {
                return CommandResult.newErrorCommandResult((String)"Cannot create a diagram on the selected element (ReadOnly?)");
            }
            Resource diResource = DiModelUtils.getDiResource((ModelSet)this.modelSet);
            if (this.owner == null) {
                this.owner = AbstractPapyrusGmfCreateDiagramCommandHandler.this.getRootElement(modelResource);
                AbstractPapyrusGmfCreateDiagramCommandHandler.this.attachModelToResource(this.owner, modelResource);
            }
            this.service = ElementEditServiceUtils.getCommandProvider((Object)this.owner);
            if (this.service == null) {
                return null;
            }
            try {
                this.clientContext = TypeContext.getContext();
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
            if (this.clientContext == null) {
                return null;
            }
            this.rule = PolicyChecker.getCurrent().getOwningRuleFor(this.prototype, this.owner);
            if (this.rule == null) {
                return null;
            }
            this.element = this.owner;
            if (this.rule.getNewModelPath() != null) {
                for (ModelAutoCreate auto : this.rule.getNewModelPath()) {
                    EObject temp;
                    EReference ref = auto.getFeature();
                    String type = auto.getCreationType();
                    this.element = ref.isMany() ? this.create(this.element, ref, type) : ((temp = (EObject)this.element.eGet((EStructuralFeature)ref)) != null ? temp : this.create(this.element, ref, type));
                }
            }
            if (this.name == null) {
                this.name = AbstractPapyrusGmfCreateDiagramCommandHandler.this.openDiagramNameDialog(this.prototype.isNatural() ? AbstractPapyrusGmfCreateDiagramCommandHandler.this.getDefaultDiagramName() : "New" + this.prototype.getLabel().replace(" ", ""));
            }
            if (this.name == null) {
                return CommandResult.newCancelledCommandResult();
            }
            Diagram diagram = AbstractPapyrusGmfCreateDiagramCommandHandler.this.doCreateDiagram(notationResource, this.owner, this.element, this.prototype, this.name);
            if (diagram != null) {
                IPageManager pageManager = ServiceUtilsForResource.getInstance().getIPageManager((Object)diResource);
                pageManager.addPage((Object)diagram);
                return CommandResult.newOKCommandResult((Object)diagram);
            }
            return CommandResult.newCancelledCommandResult();
        }

        private EObject create(EObject origin, EReference reference, String typeID) {
            IElementType itype = ElementTypeRegistry.getInstance().getType(typeID);
            CreateElementRequest request = new CreateElementRequest(origin, itype, reference);
            ICommand command = this.service.getEditCommand((IEditCommandRequest)request);
            IStatus status = null;
            try {
                status = command.execute(null, null);
            }
            catch (ExecutionException e) {
                return null;
            }
            if (!status.isOK()) {
                return null;
            }
            CommandResult result = command.getCommandResult();
            if (result == null) {
                return null;
            }
            return (EObject)result.getReturnValue();
        }
    }
}

