/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpolicies;

import java.util.Arrays;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.gef.handles.MoveHandle;

public class LabelPrimarySelectionEditPolicy
extends SelectionHandlesEditPolicy {
    public static final String LABEL_PRIMARY_SELECTION_KEY = "primary_label";

    protected List<IFigure> createSelectionHandles() {
        PapyrusLabelHandle labelHandle = new PapyrusLabelHandle((GraphicalEditPart)this.getHost());
        return Arrays.asList(new IFigure[]{labelHandle});
    }

    private class PapyrusLabelHandle
    extends MoveHandle {
        private LineBorder lineBorder;

        public PapyrusLabelHandle(GraphicalEditPart owner) {
            super(owner);
        }

        protected void initialize() {
            this.lineBorder = new LineBorder(null, 1, 3);
            this.setOpaque(false);
            this.setBorder((Border)this.getStyleLine());
        }

        protected LineBorder getStyleLine() {
            return this.isPrimary() ? this.lineBorder : null;
        }

        protected boolean isPrimary() {
            return this.getOwner().getSelected() == 2;
        }

        protected void paintFigure(Graphics graphics) {
            this.setBorder((Border)this.getStyleLine());
            super.paintFigure(graphics);
        }
    }
}

