/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.model;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.infra.emf.utils.BusinessModelResolver;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;

public class NotationUtils {
    @Deprecated
    public static Resource getNotationResource() {
        return NotationUtils.getNotationModel().getResource();
    }

    public static NotationModel getNotationModel() {
        try {
            return (NotationModel)ServiceUtilsForActionHandlers.getInstance().getModelSet().getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        }
        catch (ServiceException e) {
            return null;
        }
    }

    public static NotationModel getNotationModelChecked() throws ServiceException {
        return (NotationModel)ServiceUtilsForActionHandlers.getInstance().getModelSet().getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
    }

    public static NotationModel getNotationModel(ModelSet modelsManager) {
        return (NotationModel)modelsManager.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
    }

    public static Diagram getAssociatedDiagram(Resource notationResource, EObject eObject) {
        if (notationResource != null) {
            for (EObject obj : notationResource.getContents()) {
                Diagram diagram;
                if (!(obj instanceof Diagram) || DiagramUtils.getOwner(diagram = (Diagram)obj) != eObject) continue;
                return diagram;
            }
        }
        return null;
    }

    public static Diagram getAssociatedDiagram(Resource notationResource, EObject eObject, boolean resolve) {
        if (notationResource != null && resolve) {
            EcoreUtil.resolveAll((Resource)notationResource);
        }
        return NotationUtils.getAssociatedDiagram(notationResource, eObject);
    }

    public static List<Diagram> getDiagrams(Resource notationResource, EObject eObject) {
        LinkedList<Diagram> diagrams = new LinkedList<Diagram>();
        if (notationResource != null) {
            for (EObject obj : notationResource.getContents()) {
                Diagram diagram;
                if (!(obj instanceof Diagram) || !EcoreUtil.isAncestor((EObject)eObject, (EObject)DiagramUtils.getOwner(diagram = (Diagram)obj))) continue;
                diagrams.add(diagram);
            }
        }
        return diagrams;
    }

    public static List<Diagram> getDiagrams(Resource notationResource, EObject eObject, boolean resolve) {
        if (notationResource != null && resolve) {
            EcoreUtil.resolveAll((Resource)notationResource);
        }
        return NotationUtils.getDiagrams(notationResource, eObject);
    }

    public static Resource getNotationResource(ModelSet from) {
        IModel notationModel = from.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        if (notationModel instanceof NotationModel) {
            return ((NotationModel)notationModel).getResource();
        }
        return null;
    }

    public static Resource getNotationResource(ServicesRegistry registry) {
        try {
            ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)registry);
            return NotationUtils.getNotationResource(modelSet);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
    }

    public static Resource getNotationResourceForDiagram(EObject eObject, TransactionalEditingDomain domain) {
        Object object = BusinessModelResolver.getInstance().getBusinessModel((Object)eObject);
        EObject semanticObject = !(object instanceof EObject) ? eObject : (EObject)object;
        Resource containerResource = semanticObject.eResource();
        if (containerResource == null) {
            return null;
        }
        ResourceSet resourceSet = containerResource.getResourceSet();
        if (resourceSet instanceof ModelSet) {
            ModelSet modelSet = (ModelSet)resourceSet;
            Resource destinationResource = modelSet.getAssociatedResource(semanticObject, "notation", true);
            return destinationResource;
        }
        throw new RuntimeException("Resource Set is not a ModelSet or is null");
    }
}

