/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.utils;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.tools.util.EditorHelper;
import org.eclipse.ui.IWorkbenchPart;

public class DiagramEditPartsUtil {
    private DiagramEditPartsUtil() {
    }

    public static EditPart getEditPartFromView(View view, EditPart anyEditPart) {
        if (view != null && anyEditPart != null) {
            return (EditPart)anyEditPart.getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    public static DiagramEditPart getDiagramEditPart(EditPart editPart) {
        if (editPart == null) {
            return null;
        }
        if (editPart instanceof IGraphicalEditPart) {
            IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)editPart;
            View view = graphicalEditPart.getNotationView();
            Diagram diagram = view.getDiagram();
            Object object = graphicalEditPart.getViewer().getEditPartRegistry().get(diagram);
            if (object instanceof DiagramEditPart) {
                return (DiagramEditPart)object;
            }
        }
        if (editPart instanceof DiagramEditPart) {
            return (DiagramEditPart)editPart;
        }
        EditPart actual = editPart;
        EditPart parent = null;
        while ((parent = actual.getParent()) != null) {
            if (parent instanceof DiagramEditPart) {
                return (DiagramEditPart)parent;
            }
            actual = parent;
        }
        return null;
    }

    public static Collection<EditPart> getAllTopSemanticEditPart(EditPart ep) {
        HashSet<EditPart> editparts = new HashSet<EditPart>();
        for (Object current : ep.getChildren()) {
            if (!(current instanceof EditPart)) continue;
            editparts.addAll(DiagramEditPartsUtil.getAllTopSemanticEditPart((EditPart)current));
            EditPart topEP = DiagramEditPartsUtil.getTopSemanticEditPart((EditPart)current);
            if (topEP == null) continue;
            editparts.add(topEP);
        }
        return editparts;
    }

    public static final EditPart getTopSemanticEditPart(EditPart ep) {
        EObject currentEObject = (EObject)ep.getAdapter(EObject.class);
        if (currentEObject != null) {
            EditPart previousParent = ep;
            EditPart parent = ep;
            while (parent != null) {
                if (parent.getAdapter(EObject.class) != currentEObject || parent instanceof DiagramEditPart) {
                    return previousParent;
                }
                previousParent = parent;
                parent = parent.getParent();
            }
            return previousParent;
        }
        return null;
    }

    public static final IDiagramGraphicalViewer getActiveDiagramGraphicalViewer() {
        IDiagramWorkbenchPart part = DiagramEditPartsUtil.getActiveDiagramWorkbenchPart();
        return part != null ? part.getDiagramGraphicalViewer() : null;
    }

    public static final IDiagramWorkbenchPart getActiveDiagramWorkbenchPart() {
        IDiagramWorkbenchPart diagramPart = null;
        IWorkbenchPart part = EditorHelper.getActivePart();
        if (part instanceof IDiagramWorkbenchPart) {
            diagramPart = (IDiagramWorkbenchPart)part;
        } else if (part != null) {
            diagramPart = (IDiagramWorkbenchPart)part.getAdapter(IDiagramWorkbenchPart.class);
        }
        return diagramPart;
    }

    public static final IPreferenceStore getDiagramWorkspacePreferenceStore(EditPart anEditPart) {
        EditPartViewer viewer = anEditPart.getViewer();
        if (viewer instanceof DiagramGraphicalViewer) {
            return ((DiagramGraphicalViewer)viewer).getWorkspaceViewerPreferenceStore();
        }
        return null;
    }

    public static final boolean isSnapToGridActive(EditPart anEditPart) {
        boolean result = false;
        IPreferenceStore store = DiagramEditPartsUtil.getDiagramWorkspacePreferenceStore(anEditPart);
        if (store != null) {
            result = store.getBoolean("rulergrid.snaptogrid");
        }
        return result;
    }

    public static final double getDiagramGridSpacing(EditPart anEditPart) {
        RootEditPart rootEP = anEditPart.getRoot();
        if (rootEP instanceof DiagramRootEditPart) {
            return ((DiagramRootEditPart)rootEP).getGridSpacing();
        }
        return -1.0;
    }

    public static final EditPart getContainerEditPart(GraphicalEditPart currentEP) {
        EditPart parent = currentEP.getParent();
        EditPart container = parent instanceof AbstractConnectionEditPart ? parent.getParent() : (parent instanceof AbstractBorderItemEditPart ? parent.getParent().getParent() : (currentEP instanceof AbstractBorderItemEditPart ? parent.getParent() : parent));
        return container;
    }
}

