/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum KIND implements Enumerator
{
    FIRST_CHILD(0, "FIRST_CHILD", ">"),
    SIBLING(1, "SIBLING", "+");

    public static final int FIRST_CHILD_VALUE = 0;
    public static final int SIBLING_VALUE = 1;
    private static final KIND[] VALUES_ARRAY;
    public static final List<KIND> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new KIND[]{FIRST_CHILD, SIBLING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static KIND get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            KIND result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static KIND getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            KIND result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static KIND get(int value) {
        switch (value) {
            case 0: {
                return FIRST_CHILD;
            }
            case 1: {
                return SIBLING;
            }
        }
        return null;
    }

    private KIND(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

