/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.preferences.pages;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.gmf.runtime.diagram.ui.preferences.DiagramsPreferencePage;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.papyrus.infra.gmfdiag.preferences.PapyrusPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.preferences.pages.internal.VisiblePageSingleton;
import org.eclipse.papyrus.infra.gmfdiag.preferences.ui.AbstractGroup;
import org.eclipse.papyrus.infra.gmfdiag.preferences.ui.diagram.DiagramBackgroundColor;
import org.eclipse.papyrus.infra.gmfdiag.preferences.ui.diagram.DiagramConnectionGroup;
import org.eclipse.papyrus.infra.gmfdiag.preferences.ui.diagram.DiagramDecorationGroup;
import org.eclipse.papyrus.infra.gmfdiag.preferences.ui.diagram.DiagramFontGroup;
import org.eclipse.papyrus.infra.gmfdiag.preferences.ui.diagram.DiagramNodeColorGroup;
import org.eclipse.papyrus.infra.gmfdiag.preferences.ui.diagram.DiagramRulersAndGridGroup;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class DiagramPreferencePage
extends DiagramsPreferencePage {
    private Set<AbstractGroup> groupSet;
    private String key = null;

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.initGroup();
    }

    protected Control createContents(Composite parent) {
        Group contentGroup = new Group(parent, 2);
        contentGroup.setLayout((Layout)new GridLayout(4, false));
        DiagramFontGroup fontGroupComposite = new DiagramFontGroup((Composite)contentGroup, this.getPreferenceKey(), (DialogPage)this);
        this.addAbstractGroup(fontGroupComposite);
        DiagramNodeColorGroup colorGroupForNodeComposite = new DiagramNodeColorGroup((Composite)contentGroup, this.getPreferenceKey(), (DialogPage)this);
        this.addAbstractGroup(colorGroupForNodeComposite);
        DiagramConnectionGroup connectionGroupComposite = new DiagramConnectionGroup((Composite)contentGroup, this.getPreferenceKey(), (DialogPage)this);
        this.addAbstractGroup(connectionGroupComposite);
        DiagramBackgroundColor backgroundColorGroup = new DiagramBackgroundColor((Composite)contentGroup, this.getPreferenceKey(), (DialogPage)this);
        this.addAbstractGroup(backgroundColorGroup);
        DiagramDecorationGroup decorationGroupComposite = new DiagramDecorationGroup((Composite)contentGroup, this.getPreferenceKey(), (DialogPage)this);
        this.addAbstractGroup(decorationGroupComposite);
        DiagramRulersAndGridGroup viewGroupComposite = new DiagramRulersAndGridGroup(parent, this.getPreferenceKey(), (DialogPage)this);
        this.addAbstractGroup(viewGroupComposite);
        return super.createContents(parent);
    }

    protected String getPreferenceKey() {
        return this.key;
    }

    private void initGroup() {
        if (this.groupSet != null) {
            for (AbstractGroup gs : this.groupSet) {
                gs.setPreferenceStore(this.getPreferenceStore());
                gs.load();
            }
        }
    }

    public boolean performOk() {
        VisiblePageSingleton.getInstance().store();
        return super.performOk();
    }

    public void storePreferences() {
        if (this.groupSet != null) {
            for (AbstractGroup gs : this.groupSet) {
                gs.storePreferences();
            }
        }
    }

    public void storeAllPreferences() {
        this.storePreferences();
        ((PapyrusPreferenceStore)this.getPreferenceStore()).deleteAllSubPreference("DIAGRAM_");
    }

    protected void setPreferenceKey(String aKey) {
        this.key = aKey;
    }

    public void dispose() {
        super.dispose();
        if (this.groupSet != null) {
            for (AbstractGroup gs : this.groupSet) {
                gs.dispose();
            }
        }
    }

    protected void addAbstractGroup(AbstractGroup fe) {
        if (this.groupSet == null) {
            this.groupSet = new HashSet<AbstractGroup>();
        }
        this.groupSet.add(fe);
    }

    private void loadDefaultPreferences() {
        if (this.groupSet != null) {
            for (AbstractGroup gs : this.groupSet) {
                gs.loadDefault();
            }
        }
    }

    protected void performDefaults() {
        this.loadDefaultPreferences();
        super.performDefaults();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            VisiblePageSingleton.getInstance().setVisiblePage((IPreferencePage)this);
            this.initGroup();
        }
        super.setVisible(visible);
    }
}

