/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForHandlers;
import org.eclipse.papyrus.infra.nattable.common.Activator;
import org.eclipse.papyrus.infra.nattable.common.handlers.CreateNatTableEditorHandler;
import org.eclipse.papyrus.infra.nattable.common.wizards.CreateNattableFromCatalogWizard;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CreateNatTableFromCatalogHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject context = this.getSelection().get(0);
        CreateNattableFromCatalogWizard wizard = new CreateNattableFromCatalogWizard(context);
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        ServicesRegistry serviceRegistry = null;
        TransactionalEditingDomain domain = null;
        try {
            serviceRegistry = ServiceUtilsForHandlers.getInstance().getServiceRegistry(event);
            domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)serviceRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
        if (dialog.open() == 0) {
            CompoundCommand compoundCommand = new CompoundCommand("Create tables from Catalog");
            for (TableConfiguration tableConfiguration : wizard.getSelectedConfig().keySet()) {
                CreateNatTableEditorHandler handler = new CreateNatTableEditorHandler();
                handler.setType(tableConfiguration.getType());
                Integer tablesQuantity = wizard.getSelectedConfig().get(tableConfiguration);
                String tableConfigName = wizard.getTableNames().get(tableConfiguration);
                int i = 0;
                while (i < tablesQuantity) {
                    try {
                        Command cmd = handler.getCreateNattableEditorCommandWithNameInitialization(domain, serviceRegistry, event, String.valueOf(tableConfigName) + "_" + i);
                        compoundCommand.append(cmd);
                    }
                    catch (ServiceException e) {
                        Activator.log.error((Throwable)e);
                    }
                    ++i;
                }
            }
            if (!compoundCommand.isEmpty()) {
                domain.getCommandStack().execute((Command)compoundCommand);
            }
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(this.getSelection().size() == 1);
    }

    protected List<EObject> getSelection() {
        ISelection selection;
        ArrayList<EObject> selectedElements = new ArrayList<EObject>();
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (ww != null && (selection = ww.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object object : structuredSelection) {
                EObject currentEObject = EMFHelper.getEObject(object);
                if (currentEObject == null) continue;
                selectedElements.add(currentEObject);
            }
        }
        return selectedElements;
    }
}

