/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.layerstack;

import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.action.KeyEditAction;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.action.IKeyAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IKeyEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.KeyEventMatcher;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.papyrus.infra.nattable.configuration.StyleConfiguration;
import org.eclipse.papyrus.infra.nattable.layer.PapyrusSelectionLayer;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.reorder.CustomDefaultColumnReorderBindings;
import org.eclipse.papyrus.infra.nattable.utils.DefaultSizeUtils;

public class BodyLayerStack
extends AbstractLayerTransform {
    private final SelectionLayer selectionLayer;
    private final DataLayer bodyDataLayer;
    private final ViewportLayer viewportLayer;
    private final ColumnHideShowLayer columnHideShowLayer;
    private final ColumnReorderLayer columnReorderLayer;

    public BodyLayerStack(IDataProvider dataProvider, INattableModelManager manager) {
        this.bodyDataLayer = new DataLayer(dataProvider, DefaultSizeUtils.getDefaultCellWidth(), DefaultSizeUtils.getDefaultCellHeight());
        this.bodyDataLayer.addConfiguration((IConfiguration)new StyleConfiguration());
        this.columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)this.bodyDataLayer, false);
        this.columnReorderLayer.addConfiguration((IConfiguration)new CustomDefaultColumnReorderBindings(manager));
        this.columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)this.columnReorderLayer);
        this.selectionLayer = new PapyrusSelectionLayer((IUniqueIndexLayer)this.columnHideShowLayer);
        this.viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer);
        this.setUnderlyingLayer((ILayer)this.viewportLayer);
        this.setRegionName("BODY");
    }

    public SelectionLayer getSelectionLayer() {
        return this.selectionLayer;
    }

    public DataLayer getBodyDataLayer() {
        return this.bodyDataLayer;
    }

    public ViewportLayer getViewportLayer() {
        return this.viewportLayer;
    }

    public ColumnHideShowLayer getColumnHideShowLayer() {
        return this.columnHideShowLayer;
    }

    public ColumnReorderLayer getColumnReorderLayer() {
        return this.columnReorderLayer;
    }

    public void configure(ConfigRegistry configRegistry, UiBindingRegistry uiBindingRegistry) {
        super.configure(configRegistry, uiBindingRegistry);
        uiBindingRegistry.registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(0, 0x100000B), (IKeyAction)new KeyEditAction());
    }
}

