/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.axis;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;

public class AxisManagerFactory {
    private static final String CLASS_MANAGER = "manager";
    private static final String CLASS_ID = "id";
    private final Map<String, Class<IAxisManager>> map = new HashMap<String, Class<IAxisManager>>();
    private static final String EXTENSION_ID = "org.eclipse.papyrus.infra.nattable.axismanager";
    public static final AxisManagerFactory INSTANCE = new AxisManagerFactory();

    private AxisManagerFactory() {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String id = iConfigurationElement.getAttribute(CLASS_ID);
            try {
                IAxisManager axisManager = (IAxisManager)iConfigurationElement.createExecutableExtension(CLASS_MANAGER);
                Class<?> myClass = axisManager.getClass();
                this.map.put(id, myClass);
            }
            catch (CoreException e) {
                Activator.log.error(String.format(Messages.AxisManagerFactory_AxisManagerClassCantBeLoaded, id), (Throwable)e);
            }
            ++n2;
        }
    }

    public IAxisManager getAxisManager(AxisManagerRepresentation axisManagerRepresentation) {
        Class<IAxisManager> managerClass = this.map.get(axisManagerRepresentation.getAxisManagerId());
        IAxisManager axisManager = null;
        if (managerClass != null) {
            try {
                axisManager = managerClass.newInstance();
            }
            catch (InstantiationException e) {
                Activator.log.error(Messages.AxisManagerFactory_TheClassCantBeInstanciated, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return axisManager;
    }
}

