/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.event.ISelectionEvent;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.provider.TableStructuredSelection;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;
import org.eclipse.ui.services.IDisposable;

public class TableSelectionProvider
implements ISelectionProvider,
IDisposable {
    private SelectionLayer selectionLayer;
    private final ILayerListener selectionListener;
    private ISelection currentSelection;
    private final List<ISelectionChangedListener> listeners;
    private INattableModelManager manager;

    public TableSelectionProvider(INattableModelManager manager, SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
        this.selectionListener = new ILayerListener(){

            public void handleLayerEvent(ILayerEvent event) {
                if (event instanceof ISelectionEvent) {
                    TableSelectionProvider.this.calculateAndStoreNewSelection(event);
                }
            }
        };
        this.selectionLayer.addLayerListener(this.selectionListener);
        this.currentSelection = new StructuredSelection();
        this.listeners = new ArrayList<ISelectionChangedListener>();
        this.manager = manager;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public synchronized ISelection getSelection() {
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void setSelection(ISelection selection) {
        if (this.currentSelection.equals(selection)) {
            return;
        }
        this.currentSelection = selection;
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.currentSelection);
        for (ISelectionChangedListener current : this.listeners) {
            current.selectionChanged(event);
        }
    }

    protected void calculateAndStoreNewSelection(ILayerEvent event) {
        StructuredSelection newSelection;
        HashSet<Object> selection = new HashSet<Object>();
        if (event instanceof ISelectionEvent) {
            Object el;
            List<PositionCoordinate> selectedCells = Arrays.asList(this.selectionLayer.getSelectedCellPositions());
            TableSelectionWrapper wrapper = new TableSelectionWrapper(selectedCells);
            ArrayList<Integer> selectedRowsIndexes = new ArrayList<Integer>();
            int[] nArray = this.selectionLayer.getFullySelectedRowPositions();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                selectedRowsIndexes.add(new Integer(i));
                el = this.manager.getRowElement(i);
                if (el != null) {
                    el = AxisUtils.getRepresentedElement(el);
                    selection.add(el);
                }
                ++n2;
            }
            ArrayList<Integer> selectedColumnsIndexes = new ArrayList<Integer>();
            el = this.selectionLayer.getFullySelectedColumnPositions();
            int n3 = ((int[])el).length;
            n = 0;
            while (n < n3) {
                int i = el[n];
                selectedColumnsIndexes.add(new Integer(i));
                Object el2 = this.manager.getColumnElement(i);
                if (el2 != null) {
                    el2 = AxisUtils.getRepresentedElement(el2);
                    selection.add(el2);
                }
                ++n;
            }
            for (PositionCoordinate cellLocation : selectedCells) {
                Object value;
                ILayerCell cell;
                int colPos = cellLocation.getColumnPosition();
                int rowPos = cellLocation.getRowPosition();
                if (selectedColumnsIndexes.contains(new Integer(colPos)) || selectedRowsIndexes.contains(new Integer(rowPos)) || (cell = this.selectionLayer.getCellByPosition(colPos, rowPos)) == null || (value = cell.getDataValue()) == null) continue;
                if (value instanceof Collection) {
                    for (Object current : (Collection)value) {
                        selection.add(current);
                    }
                    continue;
                }
                selection.add(value);
            }
            newSelection = new TableStructuredSelection(selection.toArray(), wrapper);
        } else {
            newSelection = new StructuredSelection();
        }
        this.setSelection((ISelection)newSelection);
    }

    public void dispose() {
        this.selectionLayer.removeLayerListener(this.selectionListener);
        this.selectionLayer = null;
    }
}

