/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public final class DefaultSizeUtils {
    private static final float MARGINE = 4.0f;
    private static final float FONT_CELL_RATIO = 2.0f;
    private static final float WIDTH_HEIGHT_RATIO = 8.0f;
    private static final float ROW_HEADER_RATIO = 2.0f;
    private static final float DEFAULT_DPI = 96.0f;

    private DefaultSizeUtils() {
    }

    public static int getDefaultCellHeight() {
        float dpiY = Display.getDefault().getDPI().y;
        FontData[] fd = Display.getDefault().getSystemFont().getFontData();
        float height = (float)fd[0].getHeight() * 2.0f + 4.0f;
        float value = height * (dpiY / 96.0f);
        return (int)Math.ceil(value);
    }

    public static int getDefaultCellWidth() {
        float width = (float)DefaultSizeUtils.getDefaultCellHeight() * 8.0f;
        return (int)Math.ceil(width);
    }

    public static int getDefaultRowHeaderWidth() {
        float width = (float)DefaultSizeUtils.getDefaultCellHeight() * 2.0f;
        return (int)Math.ceil(width);
    }

    public static Font getHeaderFont() {
        FontData[] fd = (FontData[])Display.getDefault().getSystemFont().getFontData().clone();
        fd[0].setStyle(1);
        Font headerFont = new Font((Device)Display.getDefault(), fd);
        return headerFont;
    }
}

