/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AbstractHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.PasteEObjectConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;

public class FillingConfigurationUtils {
    private FillingConfigurationUtils() {
    }

    public static final Collection<IFillingConfiguration> getFillingConfigurationUsedInTable(Table table, boolean onColumn) {
        ArrayList<IFillingConfiguration> confs = new ArrayList<IFillingConfiguration>();
        AbstractHeaderAxisConfiguration tableHeaderAxisConfiguration = onColumn ? HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisInTableConfiguration(table) : HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTableConfiguration(table);
        for (IAxisConfiguration currentConfiguration : tableHeaderAxisConfiguration.getOwnedAxisConfigurations()) {
            if (!(currentConfiguration instanceof IFillingConfiguration)) continue;
            confs.add((IFillingConfiguration)currentConfiguration);
        }
        return confs;
    }

    public static String getElementTypeIdToCreate(Table table, boolean onColumn) {
        Collection<IFillingConfiguration> fillingConfiguration = FillingConfigurationUtils.getFillingConfigurationUsedInTable(table, onColumn);
        for (IFillingConfiguration iFillingConfiguration : fillingConfiguration) {
            if (!(iFillingConfiguration instanceof PasteEObjectConfiguration)) continue;
            return ((PasteEObjectConfiguration)fillingConfiguration).getPastedElementId();
        }
        return null;
    }

    public static EStructuralFeature getContainmentFeature(Table table, boolean onColumn) {
        Collection<IFillingConfiguration> fillingConfiguration = FillingConfigurationUtils.getFillingConfigurationUsedInTable(table, onColumn);
        for (IFillingConfiguration iFillingConfiguration : fillingConfiguration) {
            if (!(iFillingConfiguration instanceof PasteEObjectConfiguration)) continue;
            return ((PasteEObjectConfiguration)fillingConfiguration).getPasteElementContainementFeature();
        }
        return null;
    }
}

