/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.IControlModeManager;
import org.eclipse.papyrus.infra.services.controlmode.commands.BasicControlCommand;
import org.eclipse.papyrus.infra.services.controlmode.commands.BasicUncontrolCommand;
import org.eclipse.papyrus.infra.services.controlmode.commands.CreateControlResource;
import org.eclipse.papyrus.infra.services.controlmode.commands.RemoveControlResourceCommand;
import org.eclipse.papyrus.infra.services.controlmode.participants.IControlCommandParticipant;
import org.eclipse.papyrus.infra.services.controlmode.participants.IControlModeParticipant;
import org.eclipse.papyrus.infra.services.controlmode.participants.IUncontrolCommandParticipant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlModeManager
implements IControlModeManager {
    protected static String EXTENSION_ID = "org.eclipse.papyrus.infra.services.controlmode.participant";
    protected static String PARTICPANT_ATTRIBUTE = "class";
    protected ArrayList<IControlCommandParticipant> controlCommandParticipants = new ArrayList();
    protected ArrayList<IUncontrolCommandParticipant> uncontrolCommandParticipants = new ArrayList();

    public static IControlModeManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public ControlModeManager() {
        this.initParticipants();
    }

    @Override
    public ICommand getControlCommand(ControlModeRequest request) {
        boolean isOK = this.verifCorrectCommand(request);
        if (!isOK) {
            return UnexecutableCommand.INSTANCE;
        }
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(request.getEditingDomain(), "Control command [Composite parent]");
        ICompositeCommand preCommand = this.getPreCommand(request);
        if (preCommand != null && !preCommand.isEmpty()) {
            cc.compose((IUndoableOperation)preCommand);
        }
        cc.compose((IUndoableOperation)new CreateControlResource(request));
        cc.compose((IUndoableOperation)new BasicControlCommand(request));
        ICompositeCommand postCommand = this.getPostCommand(request);
        if (postCommand != null && !postCommand.isEmpty()) {
            cc.compose((IUndoableOperation)postCommand);
        }
        return cc;
    }

    protected boolean verifCorrectCommand(ControlModeRequest request) {
        EObject container;
        EObject objectToControl = request.getTargetObject();
        return objectToControl != null && (container = objectToControl.eContainer()) != null;
    }

    protected List<IControlCommandParticipant> getControlCommandParticipants() {
        return this.controlCommandParticipants;
    }

    protected ICompositeCommand getPostCommand(ControlModeRequest request) {
        boolean isControlRequest = request.isControlRequest();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(request.getEditingDomain(), isControlRequest ? "Control Command [ Post commands]" : "UnControl Command [ post commands]");
        if (isControlRequest) {
            this.getPostControlCommand(request, cc);
        } else {
            this.getPostUncontrolMethod(request, cc);
        }
        return cc;
    }

    protected void getPostControlCommand(ControlModeRequest request, CompositeTransactionalCommand cc) {
        ListIterator<IControlCommandParticipant> participantIterator = this.getControlCommandParticipants().listIterator(this.getControlCommandParticipants().size());
        while (participantIterator.hasPrevious()) {
            ICommand cmd;
            IControlCommandParticipant iControlCommandParticipant = participantIterator.previous();
            if (!iControlCommandParticipant.provideControlCommand(request) || (cmd = iControlCommandParticipant.getPostControlCommand(request)) == null) continue;
            cc.compose((IUndoableOperation)cmd);
        }
    }

    protected void getPostUncontrolMethod(ControlModeRequest request, CompositeTransactionalCommand cc) {
        ListIterator<IUncontrolCommandParticipant> participantIterator = this.getUncontrolCommandParticipants().listIterator(this.getUncontrolCommandParticipants().size());
        while (participantIterator.hasPrevious()) {
            ICommand cmd;
            IUncontrolCommandParticipant iControlCommandParticipant = participantIterator.previous();
            if (!iControlCommandParticipant.provideUnControlCommand(request) || (cmd = iControlCommandParticipant.getPostUncontrolCommand(request)) == null) continue;
            cc.compose((IUndoableOperation)cmd);
        }
    }

    protected ICompositeCommand getPreCommand(ControlModeRequest request) {
        boolean isControlRequest = request.isControlRequest();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(request.getEditingDomain(), isControlRequest ? "Control Command [ Pre commands]" : "UnControl Command [ Pre commands]");
        if (isControlRequest) {
            this.getPreControlCommand(request, cc);
        } else {
            this.getPreUncontrolCommand(request, cc);
        }
        return cc;
    }

    protected void getPreControlCommand(ControlModeRequest request, CompositeTransactionalCommand cc) {
        for (IControlCommandParticipant iControlCommandParticipant : this.getControlCommandParticipants()) {
            ICommand cmd;
            if (!iControlCommandParticipant.provideControlCommand(request) || (cmd = iControlCommandParticipant.getPreControlCommand(request)) == null) continue;
            cc.compose((IUndoableOperation)cmd);
        }
    }

    protected void getPreUncontrolCommand(ControlModeRequest request, CompositeTransactionalCommand cc) {
        for (IUncontrolCommandParticipant iControlCommandParticipant : this.getUncontrolCommandParticipants()) {
            ICommand cmd;
            if (!iControlCommandParticipant.provideUnControlCommand(request) || (cmd = iControlCommandParticipant.getPreUncontrolCommand(request)) == null) continue;
            cc.compose((IUndoableOperation)cmd);
        }
    }

    @Override
    public ICommand getUncontrolCommand(ControlModeRequest request) {
        boolean isOK = this.verifCorrectCommand(request);
        if (!isOK) {
            return UnexecutableCommand.INSTANCE;
        }
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(request.getEditingDomain(), "Uncontrol command [Composite parent]");
        ICompositeCommand preCommand = this.getPreCommand(request);
        if (preCommand != null && !preCommand.isEmpty()) {
            cc.compose((IUndoableOperation)preCommand);
        }
        cc.compose((IUndoableOperation)new BasicUncontrolCommand(request));
        cc.compose((IUndoableOperation)new RemoveControlResourceCommand(request));
        ICompositeCommand postCommand = this.getPostCommand(request);
        if (postCommand != null && !postCommand.isEmpty()) {
            cc.compose((IUndoableOperation)postCommand);
        }
        return cc;
    }

    protected List<IUncontrolCommandParticipant> getUncontrolCommandParticipants() {
        return this.uncontrolCommandParticipants;
    }

    protected void initParticipants() {
        IConfigurationElement[] extensions;
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object particpant = e.createExecutableExtension(PARTICPANT_ATTRIBUTE);
                if (particpant instanceof IControlCommandParticipant) {
                    this.getControlCommandParticipants().add((IControlCommandParticipant)particpant);
                }
                if (particpant instanceof IUncontrolCommandParticipant) {
                    this.getUncontrolCommandParticipants().add((IUncontrolCommandParticipant)particpant);
                }
            }
            catch (CoreException exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        PartipantComparator comparator = new PartipantComparator();
        Collections.sort(this.uncontrolCommandParticipants, comparator);
        Collections.sort(this.controlCommandParticipants, comparator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class PartipantComparator
    implements Comparator<IControlModeParticipant> {
        protected PartipantComparator() {
        }

        @Override
        public int compare(IControlModeParticipant arg0, IControlModeParticipant arg1) {
            int j;
            int i = arg1.getPriority();
            return i >= (j = arg0.getPriority()) ? (i != j ? 1 : 0) : -1;
        }
    }

    private static class SingletonHolder {
        private static ControlModeManager INSTANCE = new ControlModeManager();

        private SingletonHolder() {
        }
    }
}

