/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.commands;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.AbstractControlResourceCommand;

public class RemoveControlResourceCommand
extends AbstractControlResourceCommand {
    public RemoveControlResourceCommand(ControlModeRequest request) {
        super(request, "Uncontrol command", Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)request.getTargetObject().eResource())));
    }

    public RemoveControlResourceCommand(ControlModeRequest request, String fileExtension) {
        super(request, fileExtension, "Uncontrol command", Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)request.getTargetObject().eResource())));
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        EObject objectToControl = this.getRequest().getTargetObject();
        if (objectToControl == null) {
            return CommandResult.newErrorCommandResult((String)"The object to uncontrol is null");
        }
        ModelSet modelSet = this.getRequest().getModelSet();
        if (modelSet == null) {
            return CommandResult.newErrorCommandResult((String)"The resource is not contained in any resource set");
        }
        Resource resource = modelSet.getResource(this.getSourceUri(), false);
        if (resource == null) {
            return CommandResult.newErrorCommandResult((String)"The resource is null");
        }
        modelSet.getResourcesToDeleteOnSave().add(resource.getURI());
        Resource targetResource = this.getTargetResource(objectToControl);
        if (targetResource == null) {
            return CommandResult.newErrorCommandResult((String)("unable to retrieve the target resource for the extension " + this.getFileExtension()));
        }
        this.getRequest().setTargetResource(targetResource, this.getFileExtension());
        this.getRequest().setSourceResource(resource, this.getFileExtension());
        modelSet.getResources().remove((Object)resource);
        return CommandResult.newOKCommandResult();
    }

    protected Resource getTargetResource(EObject objectToUncontrol) {
        return this.getRequest().getModelSet().getAssociatedResource(objectToUncontrol, this.getFileExtension(), true);
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus superStatus = super.doUndo(monitor, info);
        ModelSet modelSet = this.getRequest().getModelSet();
        if (modelSet == null) {
            return CommandResult.newErrorCommandResult((String)"The resource is not contained in any resource set").getStatus();
        }
        Resource resource = this.getRequest().getSourceResource(this.getFileExtension());
        if (resource == null) {
            return CommandResult.newErrorCommandResult((String)"The resource is null").getStatus();
        }
        modelSet.getResources().add((Object)resource);
        modelSet.getResourcesToDeleteOnSave().remove(resource.getURI());
        return superStatus;
    }

    protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus superStatus = super.doRedo(monitor, info);
        Resource resource = this.getRequest().getSourceResource(this.getFileExtension());
        if (resource == null) {
            return CommandResult.newErrorCommandResult((String)"Unable to find previous resource").getStatus();
        }
        ModelSet modelSet = this.getRequest().getModelSet();
        if (modelSet == null) {
            return CommandResult.newErrorCommandResult((String)"The resource is not contained in any resource set").getStatus();
        }
        modelSet.getResources().remove((Object)resource);
        modelSet.getResourcesToDeleteOnSave().add(resource.getURI());
        return superStatus;
    }
}

