/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.resourceloading.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.util.EditPartUtilities;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.TransactionHelper;
import org.eclipse.papyrus.infra.services.resourceloading.Activator;
import org.eclipse.papyrus.infra.services.resourceloading.Messages;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.Type;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadingUtils {
    private static final Set<String> COMMON_EXTENSIONS = new HashSet<String>();

    static {
        COMMON_EXTENSIONS.add("uml");
        COMMON_EXTENSIONS.add("notation");
        COMMON_EXTENSIONS.add("di");
    }

    public static void loadResourcesInModelSet(final ModelSet modelSet, final URI uriWithoutFileExtension) {
        final IEditorPart editor = LoadingUtils.getEditor();
        if (editor instanceof IMultiDiagramEditor) {
            final NotificationBuilder error = NotificationBuilder.createAsyncPopup((String)Messages.LoadingUtils_ErrorTitle, (String)String.format(Messages.LoadingUtils_ErrorMessage, uriWithoutFileExtension.toString())).setType(Type.ERROR).setDelay(2000L);
            LoadingUtils.runInEditingDomain(modelSet.getTransactionalEditingDomain(), editor, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IMultiDiagramEditor core = (IMultiDiagramEditor)editor;
                        try {
                            IPageManager pageMngr = (IPageManager)core.getServicesRegistry().getService(IPageManager.class);
                            List allPages = pageMngr.allPages();
                            monitor.beginTask(Messages.LoadingUtils_RefreshPagesTask, allPages.size());
                            for (Object o : allPages) {
                                InternalEObject internal;
                                URI uriProxy;
                                URI trimFragment;
                                EObject eobject;
                                if (o instanceof EObject && (eobject = (EObject)o).eIsProxy() && uriWithoutFileExtension.equals((trimFragment = (uriProxy = (internal = (InternalEObject)eobject).eProxyURI()).trimFragment()).trimFileExtension())) {
                                    try {
                                        Resource r = modelSet.getResource(trimFragment, true);
                                        if (r != null) {
                                            EObject newEObject = r.getEObject(uriProxy.fragment());
                                            if (pageMngr.isOpen((Object)newEObject)) {
                                                pageMngr.selectPage((Object)newEObject);
                                            }
                                        } else {
                                            error.run();
                                        }
                                    }
                                    catch (Exception e) {
                                        error.run();
                                        Activator.logError(e);
                                    }
                                }
                                monitor.worked(1);
                            }
                            Set extensions = LoadingUtils.getExtensions(modelSet);
                            monitor.beginTask(Messages.LoadingUtils_LoadModelsTask, extensions.size());
                            for (String s : extensions) {
                                try {
                                    URI uriToLoad = uriWithoutFileExtension.appendFileExtension(s);
                                    Resource r = modelSet.getResource(uriToLoad, true);
                                    if (r == null) {
                                        error.run();
                                    }
                                }
                                catch (Exception re) {
                                    error.run();
                                    Activator.logError(re);
                                }
                                monitor.worked(1);
                            }
                        }
                        catch (ServiceException e) {
                            Activator.logError((Exception)((Object)e));
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
    }

    public static void unloadResourcesFromModelSet(ModelSet modelSet, URI uriWithoutFileExtension) {
        LoadingUtils.unloadResourcesFromModelSet(modelSet, uriWithoutFileExtension, false);
    }

    public static void unloadResourcesFromModelSet(final ModelSet modelSet, final URI uriWithoutFileExtension, final boolean refreshDiagramsWithProxies) {
        final IEditorPart editor = LoadingUtils.getEditor();
        if (editor instanceof IMultiDiagramEditor) {
            LoadingUtils.runInEditingDomain(modelSet.getTransactionalEditingDomain(), editor, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IMultiDiagramEditor core = (IMultiDiagramEditor)editor;
                        try {
                            IPageManager pageMngr = (IPageManager)core.getServicesRegistry().getService(IPageManager.class);
                            List allPages = pageMngr.allPages();
                            ArrayList<URI> pagesURIToOpen = new ArrayList<URI>(allPages.size());
                            ArrayList<URI> pagesURIToRefresh = new ArrayList<URI>(allPages.size());
                            if (refreshDiagramsWithProxies) {
                                monitor.beginTask(Messages.LoadingUtils_RefreshPagesTask, allPages.size());
                                for (Object o : allPages) {
                                    EObject eobject;
                                    if (o instanceof EObject && !(eobject = (EObject)o).eIsProxy()) {
                                        URI trimFragment = eobject.eResource().getURI();
                                        String frag = eobject.eResource().getURIFragment(eobject);
                                        if (uriWithoutFileExtension.equals(trimFragment.trimFileExtension())) {
                                            if (pageMngr.isOpen((Object)eobject)) {
                                                pageMngr.closePage((Object)eobject);
                                                pagesURIToOpen.add(trimFragment.appendFragment(frag));
                                            }
                                        } else if (pageMngr.isOpen((Object)eobject)) {
                                            pagesURIToRefresh.add(trimFragment.appendFragment(frag));
                                        }
                                    }
                                    monitor.worked(1);
                                }
                            }
                            monitor.beginTask(Messages.LoadingUtils_UnloadModelsTask, modelSet.getResources().size());
                            String unloadPlatformString = uriWithoutFileExtension.isPlatform() ? uriWithoutFileExtension.toPlatformString(true) : URI.decode((String)uriWithoutFileExtension.toString());
                            for (Resource res : new ArrayList(modelSet.getResources())) {
                                URI normalizedURI = res.getURI();
                                String platformString = normalizedURI.isPlatform() ? normalizedURI.trimFileExtension().toPlatformString(true) : URI.decode((String)normalizedURI.trimFileExtension().toString());
                                if (platformString != null && platformString.equals(unloadPlatformString)) {
                                    res.unload();
                                }
                                monitor.worked(1);
                            }
                            if (refreshDiagramsWithProxies) {
                                monitor.beginTask(Messages.LoadingUtils_RefreshPagesTask, allPages.size());
                                for (Object page : allPages) {
                                    if (page instanceof EObject) {
                                        Diagram diag;
                                        EObject eobject = (EObject)page;
                                        if (eobject.eIsProxy()) {
                                            InternalEObject internal = (InternalEObject)eobject;
                                            URI uriProxy = internal.eProxyURI();
                                            if (pagesURIToOpen.contains(uriProxy)) {
                                                pageMngr.openPage((Object)eobject);
                                            }
                                        } else if (eobject instanceof Diagram && pageMngr.isOpen((Object)(diag = (Diagram)eobject))) {
                                            IDiagramGraphicalViewer graphicalViewer = (IDiagramGraphicalViewer)core.getAdapter(IDiagramGraphicalViewer.class);
                                            if (graphicalViewer == null) continue;
                                            Object part = graphicalViewer.getEditPartRegistry().get(diag);
                                            if (part instanceof GraphicalEditPart) {
                                                for (Object child : EditPartUtilities.getAllChildren((GraphicalEditPart)((GraphicalEditPart)part))) {
                                                    if (!(child instanceof EditPart)) continue;
                                                    ((EditPart)child).refresh();
                                                }
                                                for (Object child : EditPartUtilities.getAllNestedConnectionEditParts((GraphicalEditPart)((GraphicalEditPart)part))) {
                                                    if (!(child instanceof EditPart)) continue;
                                                    ((EditPart)child).refresh();
                                                }
                                            }
                                        }
                                    }
                                    monitor.worked(1);
                                }
                            }
                        }
                        catch (ServiceException e) {
                            Activator.logError((Exception)((Object)e));
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
    }

    static void runInEditingDomain(TransactionalEditingDomain domain, IEditorPart editorContext, IRunnableWithProgress operation) {
        IWorkbenchSiteProgressService progress = (IWorkbenchSiteProgressService)editorContext.getSite().getService(IWorkbenchSiteProgressService.class);
        try {
            try {
                progress.incrementBusy();
                progress.busyCursorWhile(TransactionHelper.createPrivilegedRunnableWithProgress((TransactionalEditingDomain)domain, (IRunnableWithProgress)operation));
            }
            catch (InterruptedException e) {
                Activator.log.error((Throwable)e);
                progress.decrementBusy();
            }
            catch (InvocationTargetException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.papyrus.infra.services.resourceloading", "Failed to manage controlled resources.", e.getTargetException()), 2);
                progress.decrementBusy();
            }
        }
        finally {
            progress.decrementBusy();
        }
    }

    private static Set<String> getExtensions(ModelSet modelSet) {
        return COMMON_EXTENSIONS;
    }

    public static IEditorPart getEditor() {
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbenchWindow;
        IEditorPart editor = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (activeWorkbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (activePage = activeWorkbenchWindow.getActivePage()) != null) {
            editor = activePage.getActiveEditor();
        }
        return editor;
    }

    public static IFile getFile(URI uri) {
        IPath path = LoadingUtils.getPath(uri);
        if (path != null) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        }
        return null;
    }

    public static IPath getPath(URI uri) {
        String scheme = uri.scheme();
        IPath path = null;
        if ("platform".equals(scheme)) {
            path = Path.fromPortableString((String)uri.toPlatformString(true));
        } else if ("file".equals(scheme)) {
            path = Path.fromPortableString((String)uri.toFileString());
        }
        return path;
    }
}

