/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.databinding;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservablesListener;
import org.eclipse.core.databinding.observable.ObservableEvent;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.papyrus.infra.tools.databinding.DelegatingInvocationHandler;
import org.eclipse.papyrus.infra.tools.databinding.DelegatingObservableCollection;
import org.eclipse.papyrus.infra.tools.databinding.IDelegatingObservable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingObservableSet
extends DelegatingObservableCollection<IObservableSet>
implements IObservableSet {
    private static final Object SET_EVENT_TYPE = new Object();
    private ISetChangeListener forwardingSetChangeListener;

    DelegatingObservableSet(IObservableSet delegate) {
        super(delegate, IObservableSet.class);
    }

    DelegatingObservableSet(Realm realm) {
        super(realm, IObservableSet.class);
    }

    public static IObservableSet wrap(IObservableSet observable) {
        IObservableSet result;
        if (observable instanceof IDelegatingObservable) {
            try {
                result = (IObservableSet)observable.getClass().getDeclaredConstructor(IObservableSet.class).newInstance(observable);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("observable is an invalid implementation of IDelegatingObservable", e);
            }
        } else {
            result = DelegatingInvocationHandler.wrap(new DelegatingObservableSet(observable), IObservableSet.class);
        }
        return result;
    }

    public static IObservableSet create(Realm realm, ClassLoader loader, Class<?> ... mixins) {
        return DelegatingInvocationHandler.wrap(new DelegatingObservableSet(realm), IObservableSet.class, loader, mixins);
    }

    public void addSetChangeListener(ISetChangeListener listener) {
        this.addListener(SET_EVENT_TYPE, (IObservablesListener)listener);
    }

    public void removeSetChangeListener(ISetChangeListener listener) {
        this.removeListener(SET_EVENT_TYPE, (IObservablesListener)listener);
    }

    @Override
    protected void hookDelegate(IObservableSet delegate) {
        super.hookDelegate(delegate);
        delegate.addSetChangeListener(this.getForwardingSetChangeListener());
    }

    @Override
    protected void unhookDelegate(IObservableSet delegate) {
        delegate.removeSetChangeListener(this.getForwardingSetChangeListener());
        super.unhookDelegate(delegate);
    }

    @Override
    protected void delegateChanged(IObservableSet oldDelegate, IObservableSet newDelegate) {
        super.delegateChanged(oldDelegate, newDelegate);
        Set oldSet = oldDelegate == null || oldDelegate.isDisposed() ? Collections.EMPTY_SET : oldDelegate;
        Set newSet = newDelegate == null ? Collections.EMPTY_SET : newDelegate;
        this.fireEvent((ObservableEvent)new MySetChangeEvent(Diffs.computeSetDiff((Set)oldSet, (Set)newSet)));
    }

    private ISetChangeListener getForwardingSetChangeListener() {
        if (this.forwardingSetChangeListener == null) {
            this.forwardingSetChangeListener = new ISetChangeListener(){

                public void handleSetChange(SetChangeEvent event) {
                    MySetChangeEvent myEvent = new MySetChangeEvent(event.diff);
                    DelegatingObservableSet.this.fireEvent((ObservableEvent)myEvent);
                }
            };
        }
        return this.forwardingSetChangeListener;
    }

    class MySetChangeEvent
    extends SetChangeEvent {
        private static final long serialVersionUID = 1L;

        MySetChangeEvent(SetDiff diff) {
            super((IObservableSet)DelegatingObservableSet.this.getRealObservable(), diff);
        }

        protected Object getListenerType() {
            return SET_EVENT_TYPE;
        }
    }
}

