/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.configuration.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.papyrus.infra.viewpoints.configuration.ConfigurationFactory;
import org.eclipse.papyrus.infra.viewpoints.configuration.ConfigurationPackage;
import org.eclipse.papyrus.infra.viewpoints.configuration.EPackagePropertyDescriptor;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusConfiguration;
import org.eclipse.papyrus.infra.viewpoints.iso42010.Iso42010Factory;
import org.eclipse.papyrus.infra.viewpoints.iso42010.Iso42010Package;
import org.eclipse.papyrus.infra.viewpoints.iso42010.provider.ArchitectureFrameworkItemProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusConfigurationItemProvider
extends ArchitectureFrameworkItemProvider {
    public PapyrusConfigurationItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addDefaultStakeholderPropertyDescriptor(object);
            this.addMetamodelPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addDefaultStakeholderPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PapyrusConfiguration_defaultStakeholder_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PapyrusConfiguration_defaultStakeholder_feature", "_UI_PapyrusConfiguration_type"), (EStructuralFeature)ConfigurationPackage.Literals.PAPYRUS_CONFIGURATION__DEFAULT_STAKEHOLDER, true, false, true, null, null, null));
    }

    protected void addMetamodelPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new EPackagePropertyDescriptor((IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PapyrusConfiguration_metamodel_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PapyrusConfiguration_metamodel_feature", "_UI_PapyrusConfiguration_type"), (EStructuralFeature)ConfigurationPackage.Literals.PAPYRUS_CONFIGURATION__METAMODEL, true, false, true, null, null, null)));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ConfigurationPackage.Literals.PAPYRUS_CONFIGURATION__CATEGORIES);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/PapyrusConfiguration.png"));
    }

    public String getText(Object object) {
        PapyrusConfiguration config = (PapyrusConfiguration)object;
        if (config.getMetamodel() != null) {
            return "Papyrus Configuration (" + config.getMetamodel().getNsURI() + ")";
        }
        return "Papyrus Configuration (?)";
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(PapyrusConfiguration.class)) {
            case 6: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        newChildDescriptors.add(this.createChildParameter(Iso42010Package.Literals.ARCHITECTURE_FRAMEWORK__VIEWPOINTS, ConfigurationFactory.eINSTANCE.createPapyrusViewpoint()));
        newChildDescriptors.add(this.createChildParameter(Iso42010Package.Literals.ARCHITECTURE_FRAMEWORK__STAKEHOLDERS, Iso42010Factory.eINSTANCE.createStakeholder()));
        newChildDescriptors.add(this.createChildParameter(ConfigurationPackage.Literals.PAPYRUS_CONFIGURATION__CATEGORIES, ConfigurationFactory.eINSTANCE.createCategory()));
    }

    public ResourceLocator getResourceLocator() {
        return ((IChildCreationExtender)this.adapterFactory).getResourceLocator();
    }
}

