/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.toolbox.notification.builders;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.ICompositeCreator;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.NotificationRunnable;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.Type;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyWrapper {
    private boolean asynchronous = false;
    private String message = null;
    private ICompositeCreator composite = null;
    private Collection<NotificationRunnable> actions = null;
    private Long delay = null;
    private boolean temporary = false;
    private String title = null;
    private boolean html = false;
    private Type type = null;
    private Image image = null;
    private Map<String, Object> others = new HashMap<String, Object>();

    public PropertyWrapper(Map<String, Object> properties) {
        for (String s : properties.keySet()) {
            if (NotificationBuilder.ASYNCHRONOUS.equals(s)) {
                this.asynchronous = (Boolean)properties.get(s);
                continue;
            }
            if (NotificationBuilder.COMPOSITE.equals(s)) {
                this.composite = (ICompositeCreator)properties.get(s);
                continue;
            }
            if (NotificationBuilder.MESSAGE.equals(s)) {
                this.message = (String)properties.get(s);
                continue;
            }
            if (NotificationBuilder.ACTION.equals(s)) {
                this.actions = (Collection)properties.get(s);
                continue;
            }
            if (NotificationBuilder.DELAY.equals(s)) {
                this.delay = (Long)properties.get(s);
                continue;
            }
            if (NotificationBuilder.HTML.equals(s)) {
                this.html = (Boolean)properties.get(s);
                continue;
            }
            if (NotificationBuilder.TEMPORARY.equals(s)) {
                this.temporary = (Boolean)properties.get(s);
                continue;
            }
            if (NotificationBuilder.TITLE.equals(s)) {
                this.title = (String)properties.get(s);
                continue;
            }
            if (NotificationBuilder.TYPE.equals(s)) {
                this.type = (Type)((Object)properties.get(s));
                continue;
            }
            if (NotificationBuilder.IMAGE.equals(s)) {
                this.image = (Image)properties.get(s);
                continue;
            }
            this.others.put(s, properties.get(s));
        }
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public String getMessage() {
        return this.message;
    }

    public ICompositeCreator getComposite() {
        return this.composite;
    }

    public Collection<NotificationRunnable> getActions() {
        return this.actions;
    }

    public Long getDelay() {
        return this.delay;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isHtml() {
        return this.html;
    }

    public Type getType() {
        return this.type;
    }

    public Image getImage() {
        return this.image;
    }

    public Map<String, Object> getCustomParameters() {
        return this.others;
    }
}

