/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.toolbox.notification.view;

import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.papyrus.infra.core.utils.PapyrusImageUtils;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.ICallBack;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.ICompositeCreator;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.NotificationRunnable;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.PapyrusToolkit;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.Type;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.utils.PapyrusControlsFactory;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.view.AbstractInsideComposite;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.view.MessageComposite;
import org.eclipse.papyrus.infra.widgets.toolbox.utils.ToolbooxImageUtils;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusNotificationView
extends ViewPart
implements ICallBack {
    public static final String ID = "org.eclipse.papyrus.infra.widgets.toolbox.notification.view.PapyrusNotificationView";
    private Action closeAllAction;
    private Action collapseAllAction;
    private Action allDefaultAction;
    private boolean isCollapse = true;
    private ScrolledForm form;
    private FormToolkit toolkit = PapyrusToolkit.INSTANCE;

    public void createPartControl(Composite parent) {
        this.setTitleImage(PapyrusImageUtils.getDefaultIcon());
        this.createContent(parent);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    public AbstractInsideComposite setComposite(final ICompositeCreator creator, Collection<NotificationRunnable> collection) {
        MessageComposite composite = new MessageComposite(this, this.form, this.toolkit, collection){

            protected Control doCreateContents(FormToolkit toolkit, Composite compo) {
                Composite composite = creator.createComposite(compo, toolkit);
                this.setCompositeCreated(composite);
                return composite;
            }
        };
        this.manageComposite(composite);
        return composite;
    }

    public AbstractInsideComposite setComposite(ICompositeCreator creator, String messageTitle, Collection<NotificationRunnable> runnables) {
        return this.setComposite(creator, messageTitle, runnables, null);
    }

    public AbstractInsideComposite setComposite(final ICompositeCreator creator, final String messageTitle, Collection<NotificationRunnable> runnables, final Type type) {
        MessageComposite composite = new MessageComposite(this, this.form, this.toolkit, runnables){

            protected Control doCreateContents(FormToolkit toolkit, Composite composite) {
                Composite compo = null;
                if (type != null) {
                    compo = PapyrusControlsFactory.createCompositeWithType(Display.getDefault().getActiveShell(), toolkit, composite, type, null, null, false, creator, this.context);
                } else {
                    compo = creator.createComposite(composite, toolkit);
                    this.setCompositeCreated(compo);
                }
                return compo;
            }

            protected String getSectionName() {
                if (messageTitle == null) {
                    return super.getSectionName();
                }
                return messageTitle;
            }
        };
        this.manageComposite(composite);
        return composite;
    }

    public AbstractInsideComposite setMessage(String message, final String title, Collection<NotificationRunnable> runnables) {
        MessageComposite compo = new MessageComposite(this, this.form, this.toolkit, runnables){

            protected String getSectionName() {
                if (title == null) {
                    return super.getSectionName();
                }
                return title;
            }
        };
        compo.setText(message);
        this.manageComposite(compo);
        return compo;
    }

    public void setMessage(String message) {
        this.setMessage(message, null);
    }

    public void setMessage(String message, Collection<NotificationRunnable> runnables) {
        MessageComposite compo = new MessageComposite(this, this.form, this.toolkit, runnables);
        compo.setText(message);
        this.manageComposite(compo);
    }

    private void manageComposite(AbstractInsideComposite compo) {
        if (this.form.getBody().getChildren().length > 1) {
            Control previous = this.form.getBody().getChildren()[this.form.getBody().getChildren().length - 2];
            this.manageComposite((Control)compo, previous);
        } else {
            this.manageComposite((Control)compo, null);
        }
    }

    private void manageComposite(Control created, Control previous) {
        AbstractInsideComposite inside;
        FormData data = new FormData();
        data.bottom = previous != null ? new FormAttachment(previous, -5) : new FormAttachment(98, -5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        created.setLayoutData((Object)data);
        this.form.reflow(true);
        if (created instanceof AbstractInsideComposite) {
            inside = (AbstractInsideComposite)created;
            inside.setPrevious(previous);
        }
        if (previous instanceof AbstractInsideComposite) {
            inside = (AbstractInsideComposite)previous;
            inside.setAfter(created);
        }
        created.setFocus();
    }

    private void createContent(Composite parent) {
        parent.setLayout((Layout)new FillLayout(512));
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.getBody().setLayout((Layout)new FormLayout());
        this.form.setShowFocusedControl(true);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PapyrusNotificationView.this.fillContextMenu(manager);
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.allDefaultAction);
        manager.add((IAction)this.closeAllAction);
        manager.add((IAction)this.collapseAllAction);
        manager.add((IContributionItem)new Separator());
    }

    private void fillContextMenu(IMenuManager manager) {
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.allDefaultAction);
        manager.add((IAction)this.closeAllAction);
        manager.add((IAction)this.collapseAllAction);
    }

    private void makeActions() {
        this.allDefaultAction = new Action(){

            public void run() {
                Control[] controlArray = PapyrusNotificationView.this.form.getBody().getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    if (c instanceof AbstractInsideComposite) {
                        AbstractInsideComposite compo = (AbstractInsideComposite)c;
                        compo.runDefault();
                    }
                    ++n2;
                }
                PapyrusNotificationView.this.form.getBody().layout(true, true);
                PapyrusNotificationView.this.form.layout(true, true);
            }
        };
        this.allDefaultAction.setText("Run all default action");
        this.allDefaultAction.setToolTipText("Run all default action");
        this.allDefaultAction.setImageDescriptor(ToolbooxImageUtils.getImageDescriptor(0));
        this.closeAllAction = new Action(){

            public void run() {
                Control[] controlArray = PapyrusNotificationView.this.form.getBody().getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    c.dispose();
                    ++n2;
                }
                PapyrusNotificationView.this.form.getBody().layout(true, true);
                PapyrusNotificationView.this.form.layout(true, true);
            }
        };
        this.closeAllAction.setText("Close All");
        this.closeAllAction.setToolTipText("Close all the messages");
        this.closeAllAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_DELETE"));
        this.collapseAllAction = new Action(){

            public void run() {
                Control[] controlArray = PapyrusNotificationView.this.form.getBody().getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    if (c instanceof AbstractInsideComposite) {
                        AbstractInsideComposite compo = (AbstractInsideComposite)c;
                        if (PapyrusNotificationView.this.isCollapse) {
                            compo.collapse();
                        } else {
                            compo.expand();
                        }
                    }
                    ++n2;
                }
                PapyrusNotificationView.this.isCollapse = !PapyrusNotificationView.this.isCollapse;
                if (PapyrusNotificationView.this.isCollapse) {
                    PapyrusNotificationView.this.collapseAllAction.setText("Collapse all the messages");
                    PapyrusNotificationView.this.collapseAllAction.setToolTipText("Collapse all the messages");
                } else {
                    PapyrusNotificationView.this.collapseAllAction.setText("Expand all the messages");
                    PapyrusNotificationView.this.collapseAllAction.setToolTipText("Expand all the messages");
                }
                PapyrusNotificationView.this.form.getBody().layout(true, true);
                PapyrusNotificationView.this.form.layout(true, true);
            }
        };
        this.collapseAllAction.setText("Collapse all the messages");
        this.collapseAllAction.setToolTipText("Collapse all the messages");
        this.collapseAllAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_COLLAPSEALL"));
    }

    private void hookDoubleClickAction() {
    }

    public void setFocus() {
        this.form.setFocus();
    }

    @Override
    public void callBack(Object element) {
        this.destroy(element);
    }

    protected void destroy(Object element) {
        if (element instanceof AbstractInsideComposite) {
            AbstractInsideComposite inside = (AbstractInsideComposite)((Object)element);
            if (inside != null) {
                Control previous = inside.getPrevious();
                Control after = inside.getAfter();
                if (!(after == null || after.isDisposed() || previous != null && previous.isDisposed())) {
                    this.manageComposite(after, previous);
                } else if (previous instanceof AbstractInsideComposite && !previous.isDisposed()) {
                    AbstractInsideComposite compo = (AbstractInsideComposite)previous;
                    compo.setAfter(null);
                }
            }
            if (!inside.isDisposed()) {
                inside.dispose();
            }
            this.form.getBody().layout(true, true);
            this.form.layout(true, true);
        }
    }
}

