/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.controlmode.profile;

import java.util.Collections;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.AskUserCommand;
import org.eclipse.papyrus.infra.services.controlmode.participants.IControlCommandParticipant;
import org.eclipse.papyrus.infra.services.controlmode.participants.IUncontrolCommandParticipant;
import org.eclipse.papyrus.uml.controlmode.profile.commands.CopyProfileApplicationCommand;
import org.eclipse.papyrus.uml.controlmode.profile.commands.MoveProfileApplicationCommand;
import org.eclipse.papyrus.uml.controlmode.profile.commands.MoveStereotypeApplicationToControlResource;
import org.eclipse.papyrus.uml.controlmode.profile.commands.RemoveDuplicationProfileApplicationCommand;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class UMLProfileControlParticipant
implements IControlCommandParticipant,
IUncontrolCommandParticipant {
    protected IUndoableOperation getCopyProfileApplication(ControlModeRequest request) {
        return new CopyProfileApplicationCommand(request);
    }

    public String getID() {
        return "org.eclipse.papyrus.uml.controlmode.profile.UMLProfileControlParticipant";
    }

    private String getPreControlCommandMessage(Element objectToControl) {
        return "This element is not a package. Due to UML restrictions, the newly created model fragment is not allowed to be modified in the standalone mode";
    }

    protected IUndoableOperation getMoveStereotypeCommand(ControlModeRequest request) {
        return new MoveStereotypeApplicationToControlResource(Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)request.getTargetObject().eResource())), request);
    }

    public ICommand getPostControlCommand(ControlModeRequest request) {
        CompositeCommand cc = new CompositeCommand("Composite command for control command [UML Part]");
        if (request.getTargetObject() instanceof Package) {
            cc.compose((IUndoableOperation)this.getMoveProfileAppliationCommand(request));
        }
        cc.compose(this.getMoveStereotypeCommand(request));
        if (request.getTargetObject() instanceof Package) {
            cc.compose(this.getCopyProfileApplication(request));
        }
        return cc;
    }

    public ICommand getPostUncontrolCommand(ControlModeRequest request) {
        CompositeCommand cc = new CompositeCommand("Composite command for uncontrol command [UML Part]");
        if (cc.isEmpty()) {
            return null;
        }
        return cc;
    }

    protected ICommand getMoveProfileAppliationCommand(ControlModeRequest request) {
        return new MoveProfileApplicationCommand(request);
    }

    protected ICommand getRemoveProfileApplication(ControlModeRequest request) {
        return new RemoveDuplicationProfileApplicationCommand(request);
    }

    public ICommand getPreControlCommand(ControlModeRequest request) {
        Element elem = (Element)request.getTargetObject();
        if (request.isUIAction() && !(elem instanceof Package)) {
            return new AskUserCommand(request.getEditingDomain(), this.getPreControlCommandMessage(elem), this.getPreControlCommandDialogTitle(elem), true, "org.eclipse.papyrus.controlmode.umlprofiles.participants.UMLProfileParticipant.openstandalonemodeldialog");
        }
        return null;
    }

    public ICommand getPreUncontrolCommand(ControlModeRequest request) {
        CompositeCommand cc = new CompositeCommand("Composite command for pre uncontrol command [UML Part]");
        if (request.getTargetObject() instanceof Package) {
            cc.compose((IUndoableOperation)this.getRemoveProfileApplication(request));
        }
        cc.compose(this.getMoveStereotypeCommand(request));
        return cc;
    }

    public int getPriority() {
        return 100;
    }

    protected String getPreControlCommandDialogTitle(Element elem) {
        return "Warning: The element is not a Package";
    }

    public boolean provideControlCommand(ControlModeRequest request) {
        return request.getTargetObject() instanceof Element;
    }

    public boolean provideUnControlCommand(ControlModeRequest request) {
        return request.getTargetObject() instanceof Element;
    }
}

