/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.part;

import org.eclipse.draw2d.AbstractPointListShape;
import org.eclipse.draw2d.PolylineShape;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.BorderedBorderItemEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ControlFlowEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ObjectFlowEditPart;
import org.eclipse.papyrus.uml.diagram.activity.figures.PinFigure;
import org.eclipse.papyrus.uml.diagram.activity.helper.ActivityFigureDrawer;

public abstract class AbstractPinEditPart
extends BorderedBorderItemEditPart {
    public AbstractPinEditPart(View view) {
        super(view);
    }

    protected void fireTargetConnectionAdded(ConnectionEditPart connection, int index) {
        super.fireTargetConnectionAdded(connection, index);
        if (connection instanceof ObjectFlowEditPart || connection instanceof ControlFlowEditPart) {
            PinFigure pinFigure = this.getPrimaryShape();
            PolylineShape arrow = pinFigure.getOptionalArrowFigure();
            ActivityFigureDrawer.undrawFigure((AbstractPointListShape)arrow);
        }
    }

    protected void fireRemovingTargetConnection(ConnectionEditPart connection, int index) {
        super.fireRemovingTargetConnection(connection, index);
        boolean hasActivityEdge = false;
        for (Object connect : this.getTargetConnections()) {
            if (connection.equals(connect) || !(connect instanceof ObjectFlowEditPart) && !(connect instanceof ControlFlowEditPart)) continue;
            hasActivityEdge = true;
            break;
        }
        if (!hasActivityEdge) {
            PinFigure pinFigure = this.getPrimaryShape();
            PolylineShape arrow = pinFigure.getOptionalArrowFigure();
            int side = this.getBorderItemLocator().getCurrentSideOfParent();
            int direction = ActivityFigureDrawer.getOppositeDirection(side);
            ActivityFigureDrawer.redrawPinArrow((AbstractPointListShape)arrow, this.getMapMode(), this.getSize(), direction);
        }
    }

    public abstract PinFigure getPrimaryShape();

    public void activate() {
        super.activate();
        boolean hasActivityEdge = false;
        for (Object connection : this.getTargetConnections()) {
            if (!(connection instanceof ObjectFlowEditPart) && !(connection instanceof ControlFlowEditPart)) continue;
            hasActivityEdge = true;
            break;
        }
        if (!hasActivityEdge) {
            PinFigure pinFigure = this.getPrimaryShape();
            PolylineShape arrow = pinFigure.getOptionalArrowFigure();
            int side = this.getBorderItemLocator().getCurrentSideOfParent();
            int direction = ActivityFigureDrawer.getOppositeDirection(side);
            ActivityFigureDrawer.redrawPinArrow((AbstractPointListShape)arrow, this.getMapMode(), this.getSize(), direction);
        }
    }
}

