/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.actions;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.dialogs.SelectDiagramViewsFilterDialog;
import org.eclipse.papyrus.uml.diagram.common.util.MDTUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class FilterViewsLabelsAction
extends DiagramAction {
    public FilterViewsLabelsAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
        this.setText("Filter views...");
    }

    public FilterViewsLabelsAction(IWorkbenchPart workbenchpart) {
        super(workbenchpart);
        this.setText("Filter views...");
    }

    protected Request createTargetRequest() {
        return new Request((Object)"none");
    }

    protected boolean isSelectionListener() {
        return true;
    }

    public boolean isEnabled() {
        return this.getDiagramEditPart() != null && this.getTransactionalEditingDomain() != null;
    }

    public void runWithEvent(Event event) {
        this.run();
    }

    public void run() {
        if (this.getDiagramEditPart() == null || this.getTransactionalEditingDomain() == null) {
            return;
        }
        SelectDiagramViewsFilterDialog dialog = new SelectDiagramViewsFilterDialog(Display.getCurrent().getActiveShell(), this.getDiagramEditPart());
        int result = dialog.open();
        if (result == 0) {
            this.executeCommand(dialog.getSelected());
        }
    }

    protected TransactionalEditingDomain getTransactionalEditingDomain() {
        if (this.getDiagramEditPart() != null) {
            View eObject = this.getDiagramEditPart().getNotationView();
            return TransactionUtil.getEditingDomain((EObject)eObject);
        }
        if (this.getDiagramEditPart() != null && this.getDiagramEditPart().getDiagramEditDomain() instanceof TransactionalEditingDomain) {
            return this.getDiagramEditPart().getEditingDomain();
        }
        return null;
    }

    protected Diagram getDiagram() {
        if (this.getDiagramEditPart() != null) {
            Diagram diagram = (Diagram)this.getDiagramEditPart().getNotationView();
            return diagram;
        }
        return null;
    }

    protected void executeCommand(final Collection<Integer> infos) {
        final Diagram diagram = this.getDiagram();
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(this.getTransactionalEditingDomain(), "Add filter references", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                MDTUtil.setElementsToFilterToDiagram(diagram, infos);
                return null;
            }
        };
        this.execute((Command)new ICommandProxy((ICommand)command), (IProgressMonitor)new NullProgressMonitor());
    }
}

