/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.GMFUnsafe;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.uml.appearance.helper.AppliedStereotypeHelper;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.modelrepair.service.IStereotypeRepairService;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public abstract class AbstractAppliedStereotypeDisplayEditPolicy
extends GraphicalEditPolicy
implements NotificationListener,
IPapyrusListener {
    public static final String STEREOTYPE_LABEL_POLICY = "AppliedStereotypeDisplayEditPolicy";
    protected Element hostSemanticElement;

    protected void cleanStereotypeDisplayInEAnnotation() {
        final Element umlElement = this.getUMLElement();
        ArrayList missingStereotypes = null;
        String stereotypesToDisplay = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)((View)this.getHost().getModel()));
        StringTokenizer strQualifiedName = new StringTokenizer(stereotypesToDisplay, ",");
        while (strQualifiedName.hasMoreElements()) {
            String currentStereotype = strQualifiedName.nextToken();
            Stereotype stereotype = umlElement.getAppliedStereotype(currentStereotype);
            if (stereotype != null) continue;
            if (missingStereotypes == null) {
                missingStereotypes = Lists.newArrayListWithExpectedSize((int)1);
            }
            missingStereotypes.add(currentStereotype);
        }
        if (missingStereotypes != null) {
            final ArrayList _missingStereotypes = missingStereotypes;
            Runnable cleanStereotypesOperation = new Runnable(){

                @Override
                public void run() {
                    AbstractAppliedStereotypeDisplayEditPolicy.this.doCleanStereotypeDisplay(umlElement, _missingStereotypes);
                }
            };
            try {
                IStereotypeRepairService repair = (IStereotypeRepairService)ServiceUtilsForEditPart.getInstance().getService(IStereotypeRepairService.class, (Object)this.getHost());
                repair.getPostRepairExecutor().execute(cleanStereotypesOperation);
            }
            catch (ServiceException e) {
                cleanStereotypesOperation.run();
            }
        }
    }

    protected void doCleanStereotypeDisplay(Element umlElement, Collection<String> missingStereotypes) {
        for (String currentStereotype : missingStereotypes) {
            Stereotype stereotype = umlElement.getAppliedStereotype(currentStereotype);
            if (stereotype == null) {
                this.removeEAnnotationAboutStereotype(currentStereotype);
                continue;
            }
            this.refreshDisplay();
        }
    }

    public void activate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.hostSemanticElement = this.getUMLElement();
        this.getDiagramEventBroker().addNotificationListener((EObject)view, (NotificationListener)this);
        if (this.hostSemanticElement == null) {
            return;
        }
        this.getDiagramEventBroker().addNotificationListener((EObject)this.hostSemanticElement, (NotificationListener)this);
        for (EObject stereotypeApplication : this.hostSemanticElement.getStereotypeApplications()) {
            this.getDiagramEventBroker().addNotificationListener(stereotypeApplication, (NotificationListener)this);
        }
        this.refreshDisplay();
        this.cleanStereotypeDisplayInEAnnotation();
    }

    public void deactivate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.getDiagramEventBroker().removeNotificationListener((EObject)view, (NotificationListener)this);
        if (this.hostSemanticElement == null) {
            return;
        }
        for (EObject stereotypeApplication : this.hostSemanticElement.getStereotypeApplications()) {
            this.getDiagramEventBroker().removeNotificationListener(stereotypeApplication, (NotificationListener)this);
        }
        this.getDiagramEventBroker().removeNotificationListener((EObject)this.hostSemanticElement, (NotificationListener)this);
        this.hostSemanticElement = null;
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    protected Element getUMLElement() {
        EObject element = this.getView().getElement();
        if (element instanceof Element) {
            return (Element)element;
        }
        return null;
    }

    protected View getView() {
        return (View)this.getHost().getModel();
    }

    protected void removeEAnnotationAboutStereotype(final String stereotypeQN) {
        try {
            TransactionalEditingDomain editingDomain;
            if (this.getView() != null && (editingDomain = TransactionUtil.getEditingDomain((EObject)this.getView())) != null) {
                editingDomain.runExclusive(new Runnable(){

                    @Override
                    public void run() {
                        Display.getCurrent().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (AbstractAppliedStereotypeDisplayEditPolicy.this.getView() != null && editingDomain != null) {
                                    String presentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)AbstractAppliedStereotypeDisplayEditPolicy.this.getView());
                                    final RecordingCommand command = AppliedStereotypeHelper.getRemoveAppliedStereotypeCommand((TransactionalEditingDomain)editingDomain, (EModelElement)AbstractAppliedStereotypeDisplayEditPolicy.this.getView(), (String)stereotypeQN, (String)presentationKind);
                                    try {
                                        GMFUnsafe.write((TransactionalEditingDomain)editingDomain, (Runnable)new Runnable(){

                                            @Override
                                            public void run() {
                                                command.execute();
                                            }
                                        });
                                    }
                                    catch (RollbackException e) {
                                        Activator.log.error((Throwable)e);
                                    }
                                    catch (InterruptedException e) {
                                        Activator.log.error((Throwable)e);
                                    }
                                }
                            }
                        });
                    }
                });
            }
        }
        catch (InterruptedException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public void notifyChanged(Notification notification) {
        int eventType = notification.getEventType();
        if (eventType == 20) {
            this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
        } else if (eventType == 21) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
            this.cleanStereotypeDisplayInEAnnotation();
        }
        if (notification.getNotifier() instanceof EAnnotation && "Stereotype_Annotation" == ((EAnnotation)notification.getNotifier()).getSource()) {
            this.refreshDisplay();
        }
        if (eventType == 22) {
            this.refreshDisplay();
        }
        if (notification.getNotifier() instanceof DynamicEObjectImpl && this.hostSemanticElement != null && this.hostSemanticElement.getStereotypeApplications().contains(notification.getNotifier())) {
            this.refreshDisplay();
        }
    }

    public abstract void refreshDisplay();

    protected Map<String, List<String>> parseStereotypeProperties(String stereotypesToDisplay, String stereotypesPropertiesToDisplay) {
        HashMap<String, List<String>> propertiesMap = new HashMap<String, List<String>>();
        StringTokenizer stringTokenizer = new StringTokenizer(stereotypesPropertiesToDisplay, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String propertyName = stringTokenizer.nextToken();
            String stereotypeName = propertyName.substring(0, propertyName.lastIndexOf("."));
            if (!propertiesMap.containsKey(stereotypeName)) {
                ArrayList propertiesForStereotype = new ArrayList();
                propertiesMap.put(stereotypeName, propertiesForStereotype);
            }
            ((List)propertiesMap.get(stereotypeName)).add(propertyName.substring(propertyName.lastIndexOf(".") + 1, propertyName.length()));
        }
        return propertiesMap;
    }

    public Image stereotypeIconToDisplay() {
        String stereotypesToDisplay;
        StringTokenizer tokenizer;
        String stereotypespresentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)((View)this.getHost().getModel()));
        if (stereotypespresentationKind == null) {
            return null;
        }
        if ((stereotypespresentationKind.equals("IconStereotype") || stereotypespresentationKind.equals("TextIconStereotype")) && (tokenizer = new StringTokenizer(stereotypesToDisplay = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)((View)this.getHost().getModel())), ",")).hasMoreTokens()) {
            String firstStereotypeName = tokenizer.nextToken();
            Stereotype stereotype = this.getUMLElement().getAppliedStereotype(firstStereotypeName);
            return Activator.getIconElement(this.getUMLElement(), stereotype, false);
        }
        return null;
    }
}

