/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.resourceupdate;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.lifecycleevents.ILifeCycleEventsProvider;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.resourceupdate.PartActivationListener;
import org.eclipse.papyrus.uml.diagram.common.resourceupdate.SaveListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.uml2.uml.Profile;

@Deprecated
public class ResourceUpdateService
implements IService,
IResourceChangeListener,
IResourceDeltaVisitor {
    public static final String RESOURCE_UPDATE_ID = "org.eclipse.papyrus.uml.diagram.common.resourceUpdate";
    private IMultiDiagramEditor editor;
    private ModelSet modelSet;
    private PartActivationListener partActivationListener;
    private SaveListener saveListener;

    public void init(ServicesRegistry serviceRegistry) throws ServiceException {
        this.modelSet = (ModelSet)serviceRegistry.getService(ModelSet.class);
        this.editor = (IMultiDiagramEditor)serviceRegistry.getService(IMultiDiagramEditor.class);
        ILifeCycleEventsProvider lcEventsProvider = (ILifeCycleEventsProvider)serviceRegistry.getService(ILifeCycleEventsProvider.class);
        this.saveListener = new SaveListener();
        lcEventsProvider.addDoSaveListener(this.saveListener.preSaveListener);
        lcEventsProvider.addPostDoSaveListener(this.saveListener.postSaveListener);
        this.partActivationListener = new PartActivationListener(this.editor);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                break;
            }
            case 1: {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                    break;
                }
                catch (CoreException coreException) {
                    Activator.log.error((Throwable)coreException);
                }
            }
        }
    }

    public boolean visit(IResourceDelta delta) {
        IResource changedResource = delta.getResource();
        if (delta.getFlags() == 131072) {
            return false;
        }
        if (!(changedResource instanceof IFile)) {
            return true;
        }
        String changedResourcePath = changedResource.getFullPath().toString();
        URI changedResourceURIWOExt = URI.createPlatformResourceURI((String)changedResource.getFullPath().toString(), (boolean)true).trimFileExtension();
        URIConverter uriConverter = this.modelSet.getURIConverter();
        for (Resource resource : this.modelSet.getResources()) {
            EList contents;
            URI uri = resource.getURI();
            URI normalizedURI = uriConverter.normalize(uri);
            if (!normalizedURI.path().endsWith(changedResourcePath)) continue;
            if (changedResourceURIWOExt.equals(this.modelSet.getURIWithoutExtension())) {
                if (this.saveListener.isSaveActive()) continue;
                this.partActivationListener.setModificationData(changedResource.getFullPath(), delta, true, resource.isModified());
                continue;
            }
            if (!resource.isLoaded() || (contents = resource.getContents()).size() > 0 && contents.get(0) instanceof Profile || this.saveListener.isSaveActive()) continue;
            this.partActivationListener.setModificationData(changedResource.getFullPath(), delta, false, resource.isModified());
        }
        return true;
    }

    private void activate() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        IWorkbenchPage page = this.editor.getSite().getPage();
        page.addPartListener((IPartListener)this.partActivationListener);
    }

    private void deactivate() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        IWorkbenchPage page = this.editor.getSite().getPage();
        page.removePartListener((IPartListener)this.partActivationListener);
    }

    public void startService() throws ServiceException {
        this.activate();
    }

    public void disposeService() throws ServiceException {
        this.deactivate();
    }
}

