/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.strategy.paste;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.core.clipboard.IClipboardAdditionalData;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.AbstractPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.DefaultPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.IPasteStrategy;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.tools.commands.ApplyProfileCommand;
import org.eclipse.papyrus.uml.tools.commands.ApplyStereotypeCommand;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class StereotypePasteStrategy
extends AbstractPasteStrategy
implements IPasteStrategy {
    private static IPasteStrategy instance = new StereotypePasteStrategy();

    public static IPasteStrategy getInstance() {
        return instance;
    }

    public String getLabel() {
        return "StereotypeStrategy";
    }

    public String getID() {
        return "org.eclipse.papyrus.uml.diagram.common.StereotypeStrategy";
    }

    public String getDescription() {
        return "Paste stereotype elements";
    }

    public IPasteStrategy dependsOn() {
        return DefaultPasteStrategy.getInstance();
    }

    public Command getSemanticCommand(EditingDomain domain, EObject targetOwner, PapyrusClipboard<Object> papyrusClipboard) {
        if (targetOwner instanceof Element) {
            CompoundCommand compoundCommand = new CompoundCommand("Copy all stereotypes");
            HashMap<Profile, ArrayList<ApplyStereotypeCommand>> missingProfiles = new HashMap<Profile, ArrayList<ApplyStereotypeCommand>>();
            Package targetPackage = ((Element)targetOwner).getNearestPackage();
            for (Object object : papyrusClipboard) {
                Map additionalDataMap;
                Object additionnalData;
                EObject target = papyrusClipboard.getTragetCopyFromInternalClipboardCopy(object);
                if (target == null || !(target instanceof Element) || !((additionnalData = (additionalDataMap = papyrusClipboard.getAdditionalDataForStrategy(this.getID())).get(object)) instanceof StereotypeClipboard)) continue;
                StereotypeClipboard stereotypeClipboard = (StereotypeClipboard)additionnalData;
                Collection<Stereotype> stereotypes = stereotypeClipboard.getStereotypes();
                for (Stereotype stereotype : stereotypes) {
                    Stereotype stereotypeInTargetContext = (Stereotype)EMFHelper.reloadIntoContext((EObject)stereotype, (EObject)targetOwner);
                    Profile profile = stereotypeInTargetContext.getProfile();
                    ApplyStereotypeCommand applyStereotypeCommand = new ApplyStereotypeCommand((Element)target, stereotypeInTargetContext, (TransactionalEditingDomain)domain);
                    if (this.isProfileAppliedRecursive((Element)targetPackage, profile)) {
                        compoundCommand.append((Command)applyStereotypeCommand);
                        continue;
                    }
                    ArrayList<ApplyStereotypeCommand> stereotypeListMissingProfiles = (ArrayList<ApplyStereotypeCommand>)missingProfiles.get(profile);
                    if (stereotypeListMissingProfiles != null && !stereotypeListMissingProfiles.isEmpty()) {
                        stereotypeListMissingProfiles.add(applyStereotypeCommand);
                        continue;
                    }
                    stereotypeListMissingProfiles = new ArrayList<ApplyStereotypeCommand>();
                    stereotypeListMissingProfiles.add(applyStereotypeCommand);
                    missingProfiles.put(profile, stereotypeListMissingProfiles);
                }
            }
            IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
            String preferenceProfileStrategy = preferenceStore.getString("PROFILE_STRATEGY");
            if (!"ASK_POPUP".equals(preferenceProfileStrategy) && "IMPORT_MISSING_PROFILE".equals(preferenceProfileStrategy)) {
                Set keySet = missingProfiles.keySet();
                Package rootPackage = PackageUtil.getRootPackage((Element)((Element)targetOwner));
                ApplyProfileCommand applyProfileCommand = new ApplyProfileCommand(rootPackage, keySet, (TransactionalEditingDomain)domain);
                compoundCommand.append((Command)applyProfileCommand);
                for (Profile profile : keySet) {
                    List list = (List)missingProfiles.get(profile);
                    for (ApplyStereotypeCommand applyStereotypeCommand : list) {
                        compoundCommand.append((Command)applyStereotypeCommand);
                    }
                }
            }
            if (compoundCommand.getCommandList().isEmpty()) {
                return null;
            }
            return compoundCommand;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected boolean isProfileAppliedRecursive(Element element, Profile profile) {
        if (element instanceof Package) {
            Package pkg = (Package)element;
            boolean profileApplied = pkg.isProfileApplied(profile);
            if (pkg instanceof Model) {
                return profileApplied;
            }
            if (!profileApplied) {
                return this.isProfileAppliedRecursive(element.getOwner(), profile);
            }
            return true;
        }
        return this.isProfileAppliedRecursive(element.getOwner(), profile);
    }

    public void prepare(PapyrusClipboard<Object> papyrusClipboard, Collection<EObject> selection) {
        HashMap<Object, StereotypeClipboard> mapCopyToStereotypeData = new HashMap<Object, StereotypeClipboard>();
        Iterator iterator = papyrusClipboard.iterateOnSource();
        while (iterator.hasNext()) {
            Element element;
            EList stereotypeApplications;
            EObject eObjectSource = (EObject)iterator.next();
            if (!(eObjectSource instanceof Element) || (stereotypeApplications = (element = (Element)eObjectSource).getStereotypeApplications()) == null || stereotypeApplications.isEmpty()) continue;
            ArrayList<Stereotype> stereotypeList = new ArrayList<Stereotype>();
            for (EObject stereotypeApplication : stereotypeApplications) {
                Stereotype stereotype = UMLUtil.getStereotype((EObject)stereotypeApplication);
                stereotypeList.add(stereotype);
            }
            StereotypeClipboard stereotypeClipboard = new StereotypeClipboard(stereotypeList);
            Object copy = papyrusClipboard.getCopyFromSource(eObjectSource);
            mapCopyToStereotypeData.put(copy, stereotypeClipboard);
        }
        papyrusClipboard.pushAdditionalData(this.getID(), mapCopyToStereotypeData);
    }

    protected class StereotypeClipboard
    implements IClipboardAdditionalData {
        protected Collection<Stereotype> stereotypes;

        public StereotypeClipboard(Collection<Stereotype> stereotypes) {
            this.stereotypes = stereotypes;
        }

        public Collection<Stereotype> getStereotypes() {
            return this.stereotypes;
        }
    }
}

