/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.component.custom.edit.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.uml.diagram.component.edit.commands.ConnectorCreateCommand;
import org.eclipse.papyrus.uml.diagram.component.providers.ElementInitializers;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.UMLFactory;

public class CustomConnectorCreateCommand
extends ConnectorCreateCommand {
    protected Property sourcePartWithPort = null;
    protected Property targetPartWithPort = null;
    protected GraphicalEditPart sourceGraphicalEditPart = null;
    protected GraphicalEditPart targetGraphicalEditPart = null;

    public CustomConnectorCreateCommand(CreateRelationshipRequest req, EObject source, EObject target) {
        super(req, source, target);
        if (req.getParameter("SOURCE_PARENT") instanceof Property) {
            this.sourcePartWithPort = (Property)req.getParameter("SOURCE_PARENT");
        }
        if (req.getParameter("TARGET_PARENT") instanceof Property) {
            this.targetPartWithPort = (Property)req.getParameter("TARGET_PARENT");
        }
        if (req.getParameter("SOURCE_GRAPHICAL") instanceof GraphicalEditPart) {
            this.sourceGraphicalEditPart = (GraphicalEditPart)req.getParameter("SOURCE_GRAPHICAL");
        }
        if (req.getParameter("TARGET_GRAPHICAL") instanceof GraphicalEditPart) {
            this.targetGraphicalEditPart = (GraphicalEditPart)req.getParameter("TARGET_GRAPHICAL");
        }
        this.container = this.deduceContainer((EObject)this._getSource(), (EObject)this._getTarget());
    }

    protected ConnectableElement _getSource() {
        return (ConnectableElement)this.source;
    }

    protected ConnectableElement _getTarget() {
        return (ConnectableElement)this.target;
    }

    @Override
    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof ConnectableElement)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof ConnectableElement)) {
            return false;
        }
        if (this.source == null) {
            return true;
        }
        return this.target == null || this.getContainer() != null;
    }

    @Override
    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        Connector newElement = UMLFactory.eINSTANCE.createConnector();
        this.getContainer().getOwnedConnectors().add((Object)newElement);
        ConnectorEnd end0 = UMLFactory.eINSTANCE.createConnectorEnd();
        end0.setLower(1);
        end0.setUpper(1);
        if (this._getSource() instanceof Port) {
            end0.setRole(this._getSource());
            end0.setPartWithPort(this.sourcePartWithPort);
        } else if (this._getSource() instanceof ConnectableElement) {
            end0.setRole(this._getSource());
        } else {
            throw new ExecutionException("Invalid source in create Connector command");
        }
        ConnectorEnd end1 = UMLFactory.eINSTANCE.createConnectorEnd();
        end1.setLower(1);
        end1.setUpper(1);
        if (this._getTarget() instanceof Port) {
            end1.setRole(this._getTarget());
            end1.setPartWithPort(this.targetPartWithPort);
        } else if (this._getTarget() instanceof ConnectableElement) {
            end1.setRole(this._getTarget());
        } else {
            throw new ExecutionException("Invalid target in create Connector command");
        }
        newElement.getEnds().add((Object)end0);
        newElement.getEnds().add((Object)end1);
        ElementInitializers.getInstance().init_Connector_4019(newElement);
        this.doConfigure(newElement, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
        return CommandResult.newOKCommandResult((Object)newElement);
    }

    @Override
    protected void doConfigure(Connector newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        configureRequest.setParameter("CreateRelationshipRequest.source", (Object)this._getSource());
        configureRequest.setParameter("CreateRelationshipRequest.target", (Object)this._getTarget());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    @Override
    protected StructuredClassifier deduceContainer(EObject source, EObject target) {
        if (this.sourceGraphicalEditPart != null && this.targetGraphicalEditPart != null) {
            StructuredClassifier containerProposedBySource = this.proposedContainer(this.sourceGraphicalEditPart);
            StructuredClassifier containerProposedByTarget = this.proposedContainer(this.targetGraphicalEditPart);
            if (containerProposedBySource != null && containerProposedByTarget != null && containerProposedBySource == containerProposedByTarget) {
                return containerProposedBySource;
            }
        }
        return null;
    }

    private StructuredClassifier proposedContainer(GraphicalEditPart graphicalEditPart) {
        GraphicalEditPart ep = graphicalEditPart;
        while (ep != null) {
            GraphicalEditPart parent;
            EObject semanticParent;
            if (ep instanceof GraphicalEditPart && (semanticParent = (parent = ep).resolveSemanticElement()) instanceof StructuredClassifier) {
                return (StructuredClassifier)semanticParent;
            }
            ep = ep.getParent();
        }
        return null;
    }
}

