/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.interactionoverview.figures;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.papyrus.uml.diagram.interactionoverview.figures.InteractionUseFigure;
import org.eclipse.papyrus.uml.diagram.interactionoverview.utils.CreateDiagramImage;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class InteractionWithSnapshotFigure
extends InteractionUseFigure {
    protected static String HEADER_NAME = "SD";
    protected ImageFigure imageFigure;
    protected Image originalSnapshot;
    protected Image currentSnapshot;

    public InteractionWithSnapshotFigure() {
        this.corner = 0;
        this.originalSnapshot = null;
        this.currentSnapshot = null;
    }

    @Override
    protected void createContents() {
        this.add((IFigure)this.createInteractionFigureHeader());
        this.add(this.createImagePane());
        this.setLayoutManager((LayoutManager)new InteractionLayoutManager());
        this.interactionHeader.setText(HEADER_NAME);
    }

    @Override
    public WrappingLabel getNameLabel() {
        return this.interactionHeader;
    }

    protected IFigure createImagePane() {
        this.imageFigure = new ImageFigure();
        return this.imageFigure;
    }

    public void setSnapshot(Image image) {
        if (image != null) {
            this.originalSnapshot = image;
            this.currentSnapshot = new Image((Device)Display.getDefault(), image, 0);
            this.imageFigure.setImage(image);
        }
    }

    public void updateSnapshot(Rectangle newBounds) {
        if (this.originalSnapshot != null) {
            Image newImage = CreateDiagramImage.resize(this.originalSnapshot, newBounds.width, newBounds.height);
            this.imageFigure.setImage(newImage);
            this.currentSnapshot.dispose();
            this.currentSnapshot = newImage;
        }
    }

    public void resetImage() {
        this.imageFigure.setImage(null);
        this.originalSnapshot.dispose();
        this.currentSnapshot.dispose();
    }

    public ImageFigure getImageFigure() {
        return this.imageFigure;
    }

    public boolean isImageSizeFitsImageFigure() {
        return this.isImageFigureHasBound() && this.getBounds().width == this.imageFigure.getBounds().height;
    }

    private boolean isImageFigureHasBound() {
        return this.imageFigure.getBounds().height != 0 && this.imageFigure.getBounds().width != 0;
    }

    protected class InteractionLayoutManager
    extends AbstractLayout {
        protected InteractionLayoutManager() {
        }

        public void layout(IFigure container) {
            List childrenList = container.getChildren();
            int i = 0;
            while (i < container.getChildren().size()) {
                IFigure currentFigure = (IFigure)childrenList.get(i);
                if (currentFigure.equals(InteractionWithSnapshotFigure.this.interactionLabelContainer) || currentFigure.equals(InteractionWithSnapshotFigure.this.imageFigure)) {
                    Rectangle bound = new Rectangle(((IFigure)childrenList.get(i)).getBounds());
                    bound.setSize(((IFigure)childrenList.get(i)).getPreferredSize());
                    bound.y = i > 0 ? ((IFigure)childrenList.get((int)(i - 1))).getBounds().getBottomLeft().y + 1 : InteractionWithSnapshotFigure.this.getBounds().y;
                    ((IFigure)childrenList.get(i)).setBounds(bound);
                }
                ++i;
            }
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            return new Dimension(-1, -1);
        }
    }
}

